/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.client.AnimationTicker;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLaserEntity
extends Entity
implements TraceableEntity {
    public LivingEntity caster;
    public float yaw;
    public float pitch;
    public float preYaw;
    public float prePitch;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public Direction blockSide = null;
    public boolean on = true;
    public AnimationTicker ticker = new AnimationTicker(3);
    private static final EntityDataAccessor<Integer> DATA_CASTER_ID = SynchedEntityData.defineId(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> DATA_YAW = SynchedEntityData.defineId(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> DATA_PITCH = SynchedEntityData.defineId(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> DATA_DURATION = SynchedEntityData.defineId(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_COUNT_DOWN = SynchedEntityData.defineId(AbstractLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public AbstractLaserEntity(EntityType<?> type, Level level, int countDown) {
        super(type, level);
        this.setCountDown(countDown);
        this.noCulling = true;
    }

    public void tick() {
        super.tick();
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.preYaw = this.yaw;
        this.prePitch = this.pitch;
        this.yaw = this.getYaw();
        this.pitch = this.getPitch();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.tickCount == 1 && this.level().isClientSide) {
            this.caster = (LivingEntity)this.level().getEntity(this.getCasterId());
        }
        this.beamTick();
        if (!this.on && this.ticker.isStopped() || this.caster != null && !this.caster.isAlive()) {
            this.discard();
        }
        this.ticker.changeTimer(this.on && this.isAccumulating());
        if (this.tickCount - this.getCountDown() > this.getDuration()) {
            this.on = false;
        }
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
    }

    protected void beamTick() {
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.caster;
    }

    public boolean isPickable() {
        return super.isPickable();
    }

    public void push(@NotNull Entity entityIn) {
    }

    @NotNull
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_CASTER_ID, (Object)-1).define(DATA_YAW, (Object)Float.valueOf(0.0f)).define(DATA_PITCH, (Object)Float.valueOf(0.0f)).define(DATA_DURATION, (Object)0).define(DATA_COUNT_DOWN, (Object)0);
    }

    public void setCasterId(int id) {
        this.entityData.set(DATA_CASTER_ID, (Object)id);
    }

    public int getCasterId() {
        return (Integer)this.entityData.get(DATA_CASTER_ID);
    }

    public boolean isAccumulating() {
        return this.tickCount > this.getCountDown();
    }

    public float getYaw() {
        return ((Float)this.getEntityData().get(DATA_YAW)).floatValue();
    }

    public void setYaw(float rotAngle) {
        this.getEntityData().set(DATA_YAW, (Object)Float.valueOf(rotAngle));
    }

    public float getPitch() {
        return ((Float)this.getEntityData().get(DATA_PITCH)).floatValue();
    }

    public void setPitch(float rotAngle) {
        this.getEntityData().set(DATA_PITCH, (Object)Float.valueOf(rotAngle));
    }

    public int getDuration() {
        return (Integer)this.getEntityData().get(DATA_DURATION);
    }

    public void setDuration(int duration) {
        this.getEntityData().set(DATA_DURATION, (Object)duration);
    }

    public int getCountDown() {
        return (Integer)this.getEntityData().get(DATA_COUNT_DOWN);
    }

    public void setCountDown(int countDown) {
        this.getEntityData().set(DATA_COUNT_DOWN, (Object)countDown);
    }

    protected void calculateEndPos(double radius) {
        if (this.level().isClientSide()) {
            this.endPosX = this.getX() + radius * Math.cos(this.yaw) * Math.cos(this.pitch);
            this.endPosZ = this.getZ() + radius * Math.sin(this.yaw) * Math.cos(this.pitch);
            this.endPosY = this.getY() + radius * Math.sin(this.pitch);
        } else {
            this.endPosX = this.getX() + radius * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.getZ() + radius * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.getY() + radius * Math.sin(this.getPitch());
        }
    }

    public CustomHitResult raytraceEntities(Level world, Vec3 from, Vec3 to) {
        CustomHitResult result = new CustomHitResult();
        result.setBlockHit((HitResult)world.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.getBlockHit() != null) {
            Vec3 hitVec = result.getBlockHit().getLocation();
            this.collidePosX = hitVec.x;
            this.collidePosY = hitVec.y;
            this.collidePosZ = hitVec.z;
            this.blockSide = result.getBlockHit().getDirection();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.getEntitiesOfClass(LivingEntity.class, new AABB(Math.min(this.getX(), this.collidePosX), Math.min(this.getY(), this.collidePosY), Math.min(this.getZ(), this.collidePosZ), Math.max(this.getX(), this.collidePosX), Math.max(this.getY(), this.collidePosY), Math.max(this.getZ(), this.collidePosZ)).inflate(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.getPickRadius() + this.getBaseScale();
            AABB aabb = entity.getBoundingBox().inflate((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.clip(from, to);
            if (aabb.contains(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    protected void onHit(HitResult hitResult) {
        HitResult.Type hitresult$type = hitResult.getType();
        if (hitresult$type == HitResult.Type.ENTITY) {
            this.onHitEntity((EntityHitResult)hitResult);
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, hitResult.getLocation(), GameEvent.Context.of((Entity)this, null));
        } else if (hitresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockhitresult = (BlockHitResult)hitResult;
            this.onHitBlock(blockhitresult);
            BlockPos blockpos = blockhitresult.getBlockPos();
            this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockpos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockpos)));
        }
    }

    protected void onHitEntity(EntityHitResult result) {
    }

    protected void onHitBlock(BlockHitResult result) {
    }

    protected float getBaseScale() {
        return 0.5f;
    }

    public static class CustomHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public List<LivingEntity> getEntities() {
            return this.entities;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.getType() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

