/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class FastThrowableProjectile
extends ThrowableItemProjectile
implements CustomSyncMotionEntity,
IEntityWithComplexSpawn {
    public static Consumer<FastThrowableProjectile> flySound = projectile -> {};
    public static Consumer<FastThrowableProjectile> nearFlySound = projectile -> {};
    private boolean isFastMoving = false;

    public FastThrowableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FastThrowableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public FastThrowableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, @Nullable LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pLevel);
        this.setOwner((Entity)pShooter);
        if (pShooter != null) {
            this.setPos(pShooter.getX(), pShooter.getEyeY() - (double)0.1f, pShooter.getZ());
        }
    }

    public void tick() {
        super.tick();
        if (!this.isFastMoving && this.isFastMoving() && this.level().isClientSide) {
            flySound.accept(this);
            nearFlySound.accept(this);
        }
        this.isFastMoving = this.isFastMoving();
        Vec3 vec3 = this.getDeltaMovement();
        float friction = this.isInWater() ? 0.8f : 0.99f;
        vec3 = vec3.add(0.0, this.getGravity(), 0.0);
        this.setDeltaMovement(vec3.scale((double)(1.0f / friction)));
        this.applyGravity();
        this.syncMotion();
    }

    @Override
    public void syncMotion() {
        if (this.level().isClientSide) {
            return;
        }
        if (!this.shouldSyncMotion()) {
            return;
        }
        if (this.tickCount % this.getType().updateInterval() == 0) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ClientMotionSyncMessage((Entity)this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isFastMoving() {
        return this.getDeltaMovement().lengthSqr() >= 6.25;
    }

    public boolean shouldSyncMotion() {
        return false;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        Vec3 motion = this.getDeltaMovement();
        buffer.writeFloat((float)motion.x);
        buffer.writeFloat((float)motion.y);
        buffer.writeFloat((float)motion.z);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.setDeltaMovement(additionalData.readFloat(), additionalData.readFloat(), additionalData.readFloat());
    }

    @NotNull
    public SoundEvent getCloseSound() {
        return SoundEvents.EMPTY;
    }

    @NotNull
    public SoundEvent getSound() {
        return SoundEvents.EMPTY;
    }

    public float getVolume() {
        return 0.5f;
    }
}

