/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.AbstractLaserEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class LaserEntity
extends AbstractLaserEntity {
    public static final double RADIUS = 512.0;

    public LaserEntity(EntityType<? extends LaserEntity> type, Level level) {
        super(type, level, 1);
    }

    public LaserEntity(Level level, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration) {
        super((EntityType)ModEntities.LASER.get(), level, 1);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.setPos(x, y, z);
        this.calculateEndPos(512.0);
        if (!this.level().isClientSide) {
            this.setCasterId(caster.getId());
        }
    }

    @Override
    public void beamTick() {
        if (!this.level().isClientSide) {
            if (this.caster instanceof Player) {
                this.updateWithPlayer();
            } else if (this.caster != null) {
                this.updateWithEntity();
            }
        }
        if (this.caster != null) {
            this.yaw = (float)Math.toRadians(this.caster.yHeadRot + 90.0f);
            this.pitch = (float)(-Math.toRadians(this.caster.getXRot()));
        }
        if (this.tickCount >= this.getCountDown()) {
            this.calculateEndPos(512.0);
            this.raytraceEntities(this.level(), new Vec3(this.getX(), this.getY(), this.getZ()), new Vec3(this.endPosX, this.endPosY, this.endPosZ));
            if (this.blockSide != null) {
                this.spawnExplosionParticles();
            }
        }
    }

    @Override
    public AbstractLaserEntity.CustomHitResult raytraceEntities(Level world, Vec3 from, Vec3 to) {
        AbstractLaserEntity.CustomHitResult result = new AbstractLaserEntity.CustomHitResult();
        result.setBlockHit((HitResult)this.level().clip(new ClipContext(new Vec3(this.getX(), this.getY(), this.getZ()), new Vec3(this.endPosX, this.endPosY, this.endPosZ), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.getBlockHit() != null) {
            Vec3 hitVec = result.getBlockHit().getLocation();
            this.collidePosX = hitVec.x;
            this.collidePosY = hitVec.y;
            this.collidePosZ = hitVec.z;
            this.blockSide = result.getBlockHit().getDirection();
        } else {
            List entities = world.getEntitiesOfClass(LivingEntity.class, new AABB(Math.min(this.getX(), this.collidePosX), Math.min(this.getY(), this.collidePosY), Math.min(this.getZ(), this.collidePosZ), Math.max(this.getX(), this.collidePosX), Math.max(this.getY(), this.collidePosY), Math.max(this.getZ(), this.collidePosZ)).inflate(1.0, 1.0, 1.0));
            for (LivingEntity entity : entities) {
                if (entity == this.caster) continue;
                float pad = entity.getPickRadius() + this.getBaseScale();
                AABB aabb = entity.getBoundingBox().inflate((double)pad, (double)pad, (double)pad);
                Optional hit = aabb.clip(from, to);
                if (aabb.contains(from)) {
                    result.addEntityHit(entity);
                    continue;
                }
                if (!hit.isPresent()) continue;
                result.addEntityHit(entity);
            }
            Optional<LivingEntity> target = result.getEntities().stream().min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)this.caster)));
            if (target.isPresent()) {
                this.collidePosX = target.get().getX();
                this.collidePosY = target.get().getY();
                this.collidePosZ = target.get().getZ();
            } else {
                this.collidePosX = this.endPosX;
                this.collidePosY = this.endPosY;
                this.collidePosZ = this.endPosZ;
            }
            this.blockSide = null;
        }
        return result;
    }

    public void spawnExplosionParticles() {
    }

    @Override
    protected void readAdditionalSaveData(@NotNull CompoundTag compoundTag) {
        if (this.caster == null) {
            this.discard();
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    private void updateWithPlayer() {
        this.setYaw((float)Math.toRadians(this.caster.yHeadRot + 90.0f));
        this.setPitch((float)Math.toRadians(-this.caster.getXRot()));
        Vec3 vecOffset = this.caster.getLookAngle().normalize().scale(1.25);
        this.setPos(this.caster.getX() + vecOffset.x(), this.caster.getY() + (double)(this.caster.getBbHeight() * 0.5f) + vecOffset.y(), this.caster.getZ() + vecOffset.z());
    }

    private void updateWithEntity() {
        double radians = Math.toRadians(this.caster.yHeadRot + 90.0f);
        this.setYaw((float)radians);
        this.setPitch((float)((double)(-this.caster.getXRot()) * Math.PI / 180.0));
        double offsetX = Math.cos(radians) * 0.0;
        double offsetZ = Math.sin(radians) * 0.0;
        this.setPos(this.caster.getX() + offsetX, this.caster.getY(0.75), this.caster.getZ() + offsetZ);
    }
}

