/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.ChunkLoadTool;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MortarShellEntity
extends FastThrowableProjectile
implements GeoEntity,
ExplosiveProjectile {
    private float damage = 50.0f;
    private float explosionDamage = ((Integer)ExplosionConfig.MORTAR_SHELL_EXPLOSION_DAMAGE.get()).intValue();
    private int life = 600;
    private float radius = ((Integer)ExplosionConfig.MORTAR_SHELL_EXPLOSION_RADIUS.get()).intValue();
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public Set<Long> loadedChunks = new HashSet<Long>();
    private Potion potion = (Potion)Potions.WATER.value();
    private final Set<MobEffectInstance> effects = Sets.newHashSet();

    public MortarShellEntity(EntityType<? extends MortarShellEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    public MortarShellEntity(EntityType<? extends MortarShellEntity> type, double x, double y, double z, Level world) {
        super(type, x, y, z, world);
        this.noCulling = true;
    }

    public MortarShellEntity(LivingEntity entity, Level level) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MORTAR_SHELL.get()), entity, level);
    }

    public MortarShellEntity(LivingEntity entity, Level world, float explosionDamage) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MORTAR_SHELL.get()), entity, world);
        this.explosionDamage = explosionDamage;
    }

    public MortarShellEntity(LivingEntity entity, Level world, float explosionDamage, float radius) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MORTAR_SHELL.get()), entity, world);
        this.explosionDamage = explosionDamage;
        this.radius = radius;
    }

    public void setEffectsFromItem(ItemStack stack) {
        if (stack.is((Item)ModItems.POTION_MORTAR_SHELL.get())) {
            PotionContents potionContents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            this.potion = (Potion)potionContents.potion().orElse(Potions.WATER).value();
            for (MobEffectInstance mobeffectinstance : potionContents.getAllEffects()) {
                this.effects.add(new MobEffectInstance(mobeffectinstance));
            }
        } else if (stack.is((Item)ModItems.MORTAR_SHELL.get())) {
            this.potion = (Potion)Potions.WATER.value();
            this.effects.clear();
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putFloat("Damage", this.explosionDamage);
        pCompound.putInt("Life", this.life);
        pCompound.putFloat("Radius", this.radius);
        ListTag listTag = new ListTag();
        for (long chunkPos : this.loadedChunks) {
            CompoundTag tag = new CompoundTag();
            tag.putLong("Pos", chunkPos);
            listTag.add((Object)tag);
        }
        pCompound.put("Chunks", (Tag)listTag);
        if (this.potion != Potions.WATER.value()) {
            pCompound.putString("Potion", ((Comparable)((Object)Objects.requireNonNullElse(BuiltInRegistries.POTION.getKey((Object)this.potion), "empty"))).toString());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.save());
            }
            pCompound.put("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag pCompound) {
        int i;
        ListTag listTag;
        super.readAdditionalSaveData(pCompound);
        this.explosionDamage = pCompound.contains("Damage") ? pCompound.getFloat("Damage") : (float)((Integer)ExplosionConfig.MORTAR_SHELL_EXPLOSION_DAMAGE.get()).intValue();
        this.life = pCompound.contains("Life") ? pCompound.getInt("Life") : 600;
        this.radius = pCompound.contains("Radius") ? pCompound.getFloat("Radius") : (float)((Integer)ExplosionConfig.MORTAR_SHELL_EXPLOSION_RADIUS.get()).intValue();
        if (pCompound.contains("Chunks")) {
            listTag = pCompound.getList("Chunks", 10);
            for (i = 0; i < listTag.size(); ++i) {
                CompoundTag tag = listTag.getCompound(i);
                this.loadedChunks.add(tag.getLong("Pos"));
            }
        }
        if (pCompound.contains("Potion", 8)) {
            String tagName = pCompound.getString("Potion");
            this.potion = (Potion)BuiltInRegistries.POTION.get(ResourceLocation.tryParse((String)tagName));
        }
        listTag = pCompound.getList("CustomPotionEffects", 10);
        for (i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundtag = listTag.getCompound(i);
            MobEffectInstance instance = MobEffectInstance.load((CompoundTag)compoundtag);
            if (instance == null) continue;
            this.effects.add(instance);
        }
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.MORTAR_SHELL.get();
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    public void onHitEntity(@NotNull EntityHitResult entityHitResult) {
        if (this.tickCount > 1) {
            Entity entity = entityHitResult.getEntity();
            entity.hurt(ModDamageTypes.causeCannonFireDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), 50.0f);
            if (this.level() instanceof ServerLevel) {
                this.causeExplode(entityHitResult.getLocation());
                this.createAreaCloud(this.level());
            }
            this.discard();
        }
    }

    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        BlockPos resultPos = blockHitResult.getBlockPos();
        BlockState state = this.level().getBlockState(resultPos);
        Block block = state.getBlock();
        if (block instanceof BellBlock) {
            BellBlock bell = (BellBlock)block;
            bell.attemptToRing(this.level(), resultPos, blockHitResult.getDirection());
        }
        if (!this.level().isClientSide() && this.level() instanceof ServerLevel && this.tickCount > 1) {
            this.causeExplode(blockHitResult.getLocation());
            this.createAreaCloud(this.level());
        }
        this.discard();
    }

    @Override
    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.xo, this.yo, this.zo, 1, 0.0, 0.0, 0.0, 0.001, true);
            ChunkLoadTool.updateLoadedChunks(serverLevel, (Entity)this, this.loadedChunks);
        }
        if (this.tickCount > this.life || this.isInWater()) {
            if (this.level() instanceof ServerLevel) {
                this.causeExplode(this.position());
                this.createAreaCloud(this.level());
            }
            this.discard();
        }
    }

    private void causeExplode(Vec3 vec3) {
        CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), (Entity)this, this.getOwner()), this.explosionDamage, vec3.x, vec3.y, vec3.z, this.radius, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.25f);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnMediumExplosionParticles(this.level(), vec3);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected double getDefaultGravity() {
        return 0.146f;
    }

    public void onRemovedFromLevel() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkLoadTool.unloadAllChunks(serverLevel, (Entity)this, this.loadedChunks);
        }
        super.onRemovedFromLevel();
    }

    private void createAreaCloud(Level level) {
        if (this.potion == Potions.WATER.value()) {
            return;
        }
        AreaEffectCloud cloud = new AreaEffectCloud(level, this.getX() + 0.75 * this.getDeltaMovement().x, this.getY() + 0.5 * (double)this.getBbHeight() + 0.75 * this.getDeltaMovement().y, this.getZ() + 0.75 * this.getDeltaMovement().z);
        for (MobEffectInstance effect : this.effects) {
            cloud.addEffect(effect);
        }
        cloud.setDuration((int)this.explosionDamage);
        cloud.setRadius(this.radius);
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            cloud.setOwner(living);
        }
        level.addFreshEntity((Entity)cloud);
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.06f;
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.radius = radius;
    }
}

