/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.Agm65Entity;
import com.atsuishio.superbwarfare.entity.projectile.HeliRocketEntity;
import com.atsuishio.superbwarfare.entity.projectile.Mk82Entity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AircraftEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.Agm65Weapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.HeliRocketWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.Mk82Weapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class A10Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
WeaponVehicleEntity,
AircraftEntity {
    public static Consumer<MobileVehicleEntity> fireSound = vehicle -> {};
    public static final EntityDataAccessor<Integer> LOADED_ROCKET = SynchedEntityData.defineId(A10Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> LOADED_BOMB = SynchedEntityData.defineId(A10Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.defineId(A10Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> FIRE_TIME = SynchedEntityData.defineId(A10Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(A10Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int fireIndex;
    public int reloadCoolDownBomb;
    public int reloadCoolDownMissile;
    public String lockingTargetO = "none";
    public String lockingTarget = "none";
    public float destroyRot;
    public int lockTime;
    public boolean locked;
    private boolean wasFiring = false;
    public float delta_xo;
    public float delta_yo;
    public float delta_x;
    public float delta_y;

    public A10Entity(EntityType<A10Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage(((Integer)VehicleConfig.A_10_CANNON_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.A_10_CANNON_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.A_10_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_CANNON.get()).icon(Mod.loc("textures/screens/vehicle_weapon/cannon_30mm.png")), new HeliRocketWeapon().damage(((Integer)VehicleConfig.A_10_ROCKET_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.A_10_ROCKET_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.A_10_ROCKET_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get()), new Mk82Weapon().sound((SoundEvent)ModSounds.INTO_MISSILE.get()), new Agm65Weapon().sound((SoundEvent)ModSounds.INTO_MISSILE.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(17.0, 3.0, 0.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOADED_ROCKET, (Object)0).define(LOADED_BOMB, (Object)0).define(LOADED_MISSILE, (Object)0).define(FIRE_TIME, (Object)0).define(TARGET_UUID, (Object)"none");
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("LoadedRocket", ((Integer)this.entityData.get(LOADED_ROCKET)).intValue());
        compound.putInt("LoadedBomb", ((Integer)this.entityData.get(LOADED_BOMB)).intValue());
        compound.putInt("LoadedMissile", ((Integer)this.entityData.get(LOADED_MISSILE)).intValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(LOADED_ROCKET, (Object)compound.getInt("LoadedRocket"));
        this.entityData.set(LOADED_BOMB, (Object)compound.getInt("LoadedBomb"));
        this.entityData.set(LOADED_MISSILE, (Object)compound.getInt("LoadedMissile"));
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.getDeltaMovement().length() * 0.2), this.random.nextFloat() * 0.1f + 1.0f);
    }

    @Override
    public boolean sendFireStarParticleOnHurt() {
        return false;
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.25f) * damage.floatValue() * (this.getHealth() > 0.1f ? 0.4f : 0.05f)));
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == ModItems.ROCKET_70.get() && (Integer)this.entityData.get(LOADED_ROCKET) < 28) {
            this.entityData.set(LOADED_ROCKET, (Object)((Integer)this.entityData.get(LOADED_ROCKET) + 1));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.getSoundSource(), 2.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (stack.getItem() == ModItems.MEDIUM_AERIAL_BOMB.get() && (Integer)this.entityData.get(LOADED_BOMB) < 3) {
            this.entityData.set(LOADED_BOMB, (Object)((Integer)this.entityData.get(LOADED_BOMB) + 1));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.BOMB_RELOAD.get(), this.getSoundSource(), 2.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (stack.getItem() == ModItems.AGM.get() && (Integer)this.entityData.get(LOADED_MISSILE) < 4) {
            this.entityData.set(LOADED_MISSILE, (Object)((Integer)this.entityData.get(LOADED_MISSILE) + 1));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.BOMB_RELOAD.get(), this.getSoundSource(), 2.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.interact(player, hand);
    }

    @Override
    public void baseTick() {
        Entity entity;
        if (!this.wasFiring && this.isFiring() && this.level().isClientSide()) {
            fireSound.accept(this);
        }
        this.wasFiring = this.isFiring();
        this.lockingTargetO = this.getTargetUuid();
        this.delta_xo = this.delta_x;
        this.delta_yo = this.delta_y;
        super.baseTick();
        float f = (float)Mth.clamp((double)(Math.max((double)((double)(this.onGround() ? 0.819f : 0.82f) - 0.0035 * this.getDeltaMovement().length()), (double)0.5) + (double)(0.001f * Mth.abs((float)(90.0f - (float)A10Entity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
        boolean forward = this.getDeltaMovement().dot(this.getViewVector(1.0f)) > 0.0;
        this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale((forward ? 0.227 : 0.1) * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, (double)f, (double)f));
        if (this.isInWater() && this.tickCount % 4 == 0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 0.6, 0.6));
            if (this.lastTickSpeed > 0.4) {
                this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, this.getFirstPassenger() == null ? this : this.getFirstPassenger()), (float)(20.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
            }
        }
        if (this.level() instanceof ServerLevel) {
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            if (this.reloadCoolDownBomb > 0) {
                --this.reloadCoolDownBomb;
            }
            if (this.reloadCoolDownMissile > 0) {
                --this.reloadCoolDownMissile;
            }
            this.handleAmmo();
        }
        if ((entity = this.getFirstPassenger()) instanceof Player) {
            Player player = (Player)entity;
            if (this.fireInputDown) {
                if (this.getWeaponIndex(0) == 0) {
                    if (((Integer)this.entityData.get(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox(player)) && !this.cannotFire) {
                        this.vehicleShoot(player, 0);
                    }
                } else if (this.getWeaponIndex(0) == 1 && (Integer)this.entityData.get(AMMO) > 0) {
                    this.vehicleShoot(player, 0);
                }
            }
        }
        if (this.onGround()) {
            this.terrainCompactA10();
        }
        if ((Integer)this.entityData.get(FIRE_TIME) > 0) {
            this.entityData.set(FIRE_TIME, (Object)((Integer)this.entityData.get(FIRE_TIME) - 1));
        }
        if (this.getWeaponIndex(0) == 3) {
            this.seekTarget();
        }
        this.lowHealthWarning();
        this.releaseDecoy();
        this.refreshDimensions();
    }

    @Override
    public void lowHealthWarning() {
        Vector4f position;
        ServerLevel serverLevel;
        ServerPlayer player;
        Object object;
        List<Entity> entities;
        Matrix4f transform = this.getVehicleTransform(1.0f);
        if ((double)this.getHealth() <= 0.4 * (double)this.getMaxHealth()) {
            entities = A10Entity.getPlayer(this.level());
            object = entities.iterator();
            while (object.hasNext()) {
                Level level;
                Entity e = (Entity)object.next();
                if (!(e instanceof ServerPlayer) || !((level = (player = (ServerPlayer)e).level()) instanceof ServerLevel)) continue;
                serverLevel = (ServerLevel)level;
                position = this.transformPosition(transform, -1.603125f, 0.875f, -5.0625f);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LARGE_SMOKE, position.x, position.y, position.z, 5, 0.25, 0.25, 0.25, 0.0, true);
            }
        }
        if ((object = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel2 = (ServerLevel)object;
            if ((double)this.getHealth() <= 0.25 * (double)this.getMaxHealth()) {
                this.playLowHealthParticle(serverLevel2);
            }
            if ((double)this.getHealth() <= 0.15 * (double)this.getMaxHealth()) {
                this.playLowHealthParticle(serverLevel2);
            }
        }
        if ((double)this.getHealth() <= 0.1 * (double)this.getMaxHealth()) {
            entities = A10Entity.getPlayer(this.level());
            for (Entity e : entities) {
                if (!(e instanceof ServerPlayer) || !((position = (player = (ServerPlayer)e).level()) instanceof ServerLevel)) continue;
                serverLevel = (ServerLevel)position;
                position = this.transformPosition(transform, -1.603125f, 0.875f, -5.0625f);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LARGE_SMOKE, position.x, position.y, position.z, 5, 0.25, 0.25, 0.25, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, position.x, position.y, position.z, 5, 0.25, 0.25, 0.25, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.FLAME, position.x, position.y, position.z, 5, 0.25, 0.25, 0.25, 0.0, true);
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), position.x, position.y, position.z, 5, 0.25, 0.25, 0.25, 0.0, true);
                Vector4f position2 = this.transformPosition(transform, 1.603125f, 0.875f, -5.0625f);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LARGE_SMOKE, position2.x, position2.y, position2.z, 5, 0.25, 0.25, 0.25, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, position2.x, position2.y, position2.z, 5, 0.25, 0.25, 0.25, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.FLAME, position2.x, position2.y, position2.z, 5, 0.25, 0.25, 0.25, 0.0, true);
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), position2.x, position2.y, position2.z, 5, 0.25, 0.25, 0.25, 0.0, true);
            }
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel3 = (ServerLevel)level;
                ParticleTool.sendParticle(serverLevel3, ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ(), 2, 0.35 * (double)this.getBbWidth(), 0.15 * (double)this.getBbHeight(), 0.35 * (double)this.getBbWidth(), 0.01, true);
                ParticleTool.sendParticle(serverLevel3, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ(), 2, 0.35 * (double)this.getBbWidth(), 0.15 * (double)this.getBbHeight(), 0.35 * (double)this.getBbWidth(), 0.01, true);
                ParticleTool.sendParticle(serverLevel3, ParticleTypes.FLAME, this.getX(), this.getY() + (double)(0.85f * this.getBbHeight()), this.getZ(), 4, 0.35 * (double)this.getBbWidth(), 0.12 * (double)this.getBbHeight(), 0.35 * (double)this.getBbWidth(), 0.05, true);
                ParticleTool.sendParticle(serverLevel3, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), this.getX(), this.getY() + (double)(0.85f * this.getBbHeight()), this.getZ(), 4, 0.1 * (double)this.getBbWidth(), 0.05 * (double)this.getBbHeight(), 0.1 * (double)this.getBbWidth(), 0.4, true);
            }
            if (this.tickCount % 15 == 0) {
                this.level().playSound(null, this.getOnPos(), SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (this.getHealth() < 0.1f * this.getMaxHealth() && this.tickCount % 13 == 0) {
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.NO_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (this.getHealth() >= 0.1f && this.getHealth() < 0.4f * this.getMaxHealth() && this.tickCount % 10 == 0) {
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.LOW_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void terrainCompactA10() {
        if (this.onGround()) {
            Matrix4f transform = this.getWheelsTransform(1.0f);
            Vector4f positionF = this.transformPosition(transform, 0.141675f, 0.0f, 4.6315126f);
            Vector4f positionLB = this.transformPosition(transform, 2.5752f, 0.0f, -0.7516125f);
            Vector4f positionRB = this.transformPosition(transform, -2.5752f, 0.0f, -0.7516125f);
            Vec3 p1 = new Vec3((double)positionF.x, (double)positionF.y, (double)positionF.z);
            Vec3 p2 = new Vec3((double)positionLB.x, (double)positionLB.y, (double)positionLB.z);
            Vec3 p3 = new Vec3((double)positionRB.x, (double)positionRB.y, (double)positionRB.z);
            float p1y = (float)this.traceBlockY(p1, 3.0);
            float p2y = (float)this.traceBlockY(p2, 3.0);
            float p3y = (float)this.traceBlockY(p3, 3.0);
            p1 = new Vec3((double)positionF.x, (double)p1y, (double)positionF.z);
            p2 = new Vec3((double)positionLB.x, (double)p2y, (double)positionLB.z);
            p3 = new Vec3((double)positionRB.x, (double)p3y, (double)positionRB.z);
            Vec3 p4 = p2.add(p3).scale(0.5);
            Vec3 v1 = p2.vectorTo(p3);
            Vec3 v2 = p4.vectorTo(p1);
            double x = A10Entity.getXRotFromVector(v2);
            double z = A10Entity.getXRotFromVector(v1);
            float diffX = Math.clamp((float)-5.0f, (float)5.0f, (float)Mth.wrapDegrees((float)((float)(-2.0 * x) - this.getXRot())));
            this.setXRot(Mth.clamp((float)(this.getXRot() + 0.05f * diffX), (float)-45.0f, (float)45.0f));
            float diffZ = Math.clamp((float)-5.0f, (float)5.0f, (float)Mth.wrapDegrees((float)((float)(-2.0 * z) - this.getRoll())));
            this.setZRot(Mth.clamp((float)(this.getRoll() + 0.05f * diffZ), (float)-45.0f, (float)45.0f));
        } else if (this.isInWater()) {
            this.setXRot(this.getXRot() * 0.9f);
            this.setZRot(this.getRoll() * 0.9f);
        }
    }

    private void handleAmmo() {
        Player player;
        Entity entity = this.getFirstPassenger();
        boolean hasCreativeAmmoBox = entity instanceof Player && InventoryTool.hasCreativeAmmoBox(player = (Player)entity);
        int ammoCount = this.countItem((Item)ModItems.SMALL_SHELL.get());
        if ((this.hasItem((Item)ModItems.ROCKET_70.get()) || hasCreativeAmmoBox) && this.reloadCoolDown == 0 && (Integer)this.getEntityData().get(LOADED_ROCKET) < 28) {
            this.entityData.set(LOADED_ROCKET, (Object)((Integer)this.getEntityData().get(LOADED_ROCKET) + 1));
            this.reloadCoolDown = 15;
            if (!hasCreativeAmmoBox) {
                this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.ROCKET_70.get())).findFirst().ifPresent(stack -> stack.shrink(1));
            }
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.getSoundSource(), 2.0f, 1.0f);
        }
        if ((this.hasItem((Item)ModItems.MEDIUM_AERIAL_BOMB.get()) || hasCreativeAmmoBox) && this.reloadCoolDownBomb == 0 && (Integer)this.getEntityData().get(LOADED_BOMB) < 3) {
            this.entityData.set(LOADED_BOMB, (Object)((Integer)this.getEntityData().get(LOADED_BOMB) + 1));
            this.reloadCoolDownBomb = 300;
            if (!hasCreativeAmmoBox) {
                this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.MEDIUM_AERIAL_BOMB.get())).findFirst().ifPresent(stack -> stack.shrink(1));
            }
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.BOMB_RELOAD.get(), this.getSoundSource(), 2.0f, 1.0f);
        }
        if ((this.hasItem((Item)ModItems.AGM.get()) || hasCreativeAmmoBox) && this.reloadCoolDownMissile == 0 && (Integer)this.getEntityData().get(LOADED_MISSILE) < 4) {
            this.entityData.set(LOADED_MISSILE, (Object)((Integer)this.getEntityData().get(LOADED_MISSILE) + 1));
            this.reloadCoolDownMissile = 400;
            if (!hasCreativeAmmoBox) {
                this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.AGM.get())).findFirst().ifPresent(stack -> stack.shrink(1));
            }
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.BOMB_RELOAD.get(), this.getSoundSource(), 2.0f, 1.0f);
        }
        if (this.getWeaponIndex(0) == 0) {
            this.entityData.set(AMMO, (Object)ammoCount);
        } else if (this.getWeaponIndex(0) == 1) {
            this.entityData.set(AMMO, (Object)((Integer)this.getEntityData().get(LOADED_ROCKET)));
        } else if (this.getWeaponIndex(0) == 2) {
            this.entityData.set(AMMO, (Object)((Integer)this.getEntityData().get(LOADED_BOMB)));
        } else if (this.getWeaponIndex(0) == 3) {
            this.entityData.set(AMMO, (Object)((Integer)this.getEntityData().get(LOADED_MISSILE)));
        }
    }

    public void seekTarget() {
        ServerPlayer serverPlayer;
        Entity entity = this.getFirstPassenger();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.getTargetUuid().equals(this.lockingTargetO) && !this.getTargetUuid().equals("none")) {
            ++this.lockTime;
        } else {
            this.resetSeek(player);
        }
        Entity entity2 = SeekTool.seekCustomSizeEntity(this, this.level(), 384.0, 18.0, 0.9, true);
        if (entity2 != null) {
            if (this.lockTime == 0) {
                this.setTargetUuid(String.valueOf(entity2.getUUID()));
            }
            if (!String.valueOf(entity2.getUUID()).equals(this.getTargetUuid())) {
                this.resetSeek(player);
                this.setTargetUuid(String.valueOf(entity2.getUUID()));
            }
        } else {
            this.setTargetUuid("none");
        }
        if (this.lockTime == 1 && player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.JET_LOCK.get(), 2.0f, 1.0f);
        }
        if (this.lockTime > 10) {
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.JET_LOCKON.get(), 2.0f, 1.0f);
            }
            this.locked = true;
        }
    }

    public void resetSeek(Player player) {
        this.lockTime = 0;
        this.locked = false;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(Mod.loc("jet_lock"), SoundSource.PLAYERS);
            serverPlayer.connection.send((Packet)clientboundstopsoundpacket);
        }
    }

    public void setTargetUuid(String uuid) {
        this.lockingTarget = uuid;
    }

    public String getTargetUuid() {
        return this.lockingTarget;
    }

    @Override
    public void travel() {
        Entity passenger = this.getFirstPassenger();
        if (this.getHealth() > 0.1f * this.getMaxHealth()) {
            if (passenger == null || this.isInWater()) {
                this.leftInputDown = false;
                this.rightInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
                this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.95f));
                if (this.onGround()) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.94, 1.0, 0.94));
                } else {
                    this.setXRot(Mth.clamp((float)(this.getXRot() + 0.1f), (float)-89.0f, (float)89.0f));
                }
            } else if (passenger instanceof Player) {
                if (this.getEnergy() > 0) {
                    if (this.forwardInputDown) {
                        this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 0.004f), (float)(this.sprintInputDown ? 1.0f : 0.0575f))));
                    }
                    if (this.backInputDown) {
                        this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - 0.002f), (float)-0.2f)));
                    }
                }
                if (!this.onGround()) {
                    if (this.rightInputDown) {
                        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 1.2f));
                    } else if (this.leftInputDown) {
                        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 1.2f));
                    }
                }
                if (this.downInputDown) {
                    if (this.onGround()) {
                        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.8f));
                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.97, 1.0, 0.97));
                    } else {
                        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.97f));
                        this.setDeltaMovement(this.getDeltaMovement().multiply(0.994, 1.0, 0.994));
                    }
                    this.entityData.set(PLANE_BREAK, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(PLANE_BREAK)).floatValue() + 10.0f), (float)60.0f)));
                }
            }
            if (this.getEnergy() > 0 && !this.level().isClientSide) {
                this.consumeEnergy((int)(Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()) * (float)((Integer)VehicleConfig.A_10_MAX_ENERGY_COST.get()).intValue()));
            }
            float rotSpeed = 1.5f + 2.0f * Mth.abs((float)VectorTool.calculateY(this.getRoll()));
            float addY = Mth.clamp((float)(Math.max((float)((this.onGround() ? 0.1f : 0.2f) * (float)this.getDeltaMovement().length()), (float)0.0f) * ((Float)this.entityData.get(MOUSE_SPEED_X)).floatValue()), (float)(-rotSpeed), (float)rotSpeed);
            float addX = Mth.clamp((float)(Math.min((float)((float)Math.max((double)(this.getDeltaMovement().dot(this.getViewVector(1.0f)) - 0.24), (double)0.03)), (float)0.4f) * ((Float)this.entityData.get(MOUSE_SPEED_Y)).floatValue()), (float)-3.5f, (float)3.5f);
            float addZ = ((Float)this.entityData.get(DELTA_ROT)).floatValue() - (this.onGround() ? 0.0f : 0.004f) * ((Float)this.entityData.get(MOUSE_SPEED_X)).floatValue() * (float)this.getDeltaMovement().dot(this.getViewVector(1.0f));
            float i = this.getXRot() / 80.0f;
            this.delta_x = addX;
            this.delta_y = addY - VectorTool.calculateY(this.getXRot()) * addZ;
            this.setYRot(this.getYRot() + this.delta_y);
            if (!this.onGround()) {
                this.setXRot(this.getXRot() + this.delta_x);
                this.setZRot(this.getRoll() - addZ * (1.0f - Mth.abs((float)i)));
            }
            if (!this.onGround()) {
                float speed = Mth.clamp((float)(Mth.abs((float)this.roll) / 90.0f), (float)0.0f, (float)1.0f);
                if (this.roll > 0.0f) {
                    this.setZRot(this.roll - Math.min((float)speed, (float)this.roll));
                } else if (this.roll < 0.0f) {
                    this.setZRot(this.roll + Math.min((float)speed, (float)(-this.roll)));
                }
            }
            this.setPropellerRot(this.getPropellerRot() + 30.0f * ((Float)this.entityData.get(POWER)).floatValue());
            if (this.upInputDown) {
                this.upInputDown = false;
                if ((Integer)this.entityData.get(GEAR_ROT) == 0 && !this.onGround()) {
                    this.entityData.set(GEAR_UP, (Object)true);
                } else if ((Integer)this.entityData.get(GEAR_ROT) == 85) {
                    this.entityData.set(GEAR_UP, (Object)false);
                }
            }
            if (this.onGround()) {
                this.entityData.set(GEAR_UP, (Object)false);
            }
            if (((Boolean)this.entityData.get(GEAR_UP)).booleanValue()) {
                this.entityData.set(GEAR_ROT, (Object)Math.min((int)((Integer)this.entityData.get(GEAR_ROT) + 5), (int)85));
            } else {
                this.entityData.set(GEAR_ROT, (Object)Math.max((int)((Integer)this.entityData.get(GEAR_ROT) - 5), (int)0));
            }
            float flapX = (1.0f - Mth.abs((float)this.getRoll()) / 90.0f) * Mth.clamp((float)((Float)this.entityData.get(MOUSE_SPEED_Y)).floatValue(), (float)-22.5f, (float)22.5f) - VectorTool.calculateY(this.getRoll()) * Mth.clamp((float)((Float)this.entityData.get(MOUSE_SPEED_X)).floatValue(), (float)-22.5f, (float)22.5f);
            this.setFlap1LRot(Mth.clamp((float)(-flapX - 4.0f * addZ - ((Float)this.entityData.get(PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            this.setFlap1RRot(Mth.clamp((float)(-flapX + 4.0f * addZ - ((Float)this.entityData.get(PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            this.setFlap1L2Rot(Mth.clamp((float)(-flapX - 4.0f * addZ + ((Float)this.entityData.get(PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            this.setFlap1R2Rot(Mth.clamp((float)(-flapX + 4.0f * addZ + ((Float)this.entityData.get(PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            this.setFlap2LRot(Mth.clamp((float)(flapX - 4.0f * addZ), (float)-22.5f, (float)22.5f));
            this.setFlap2RRot(Mth.clamp((float)(flapX + 4.0f * addZ), (float)-22.5f, (float)22.5f));
            float flapY = (1.0f - Mth.abs((float)this.getRoll()) / 90.0f) * Mth.clamp((float)((Float)this.entityData.get(MOUSE_SPEED_X)).floatValue(), (float)-22.5f, (float)22.5f) + VectorTool.calculateY(this.getRoll()) * Mth.clamp((float)((Float)this.entityData.get(MOUSE_SPEED_Y)).floatValue(), (float)-22.5f, (float)22.5f);
            this.setFlap3Rot(flapY * 5.0f);
        } else if (!this.onGround()) {
            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - 3.0E-4f), (float)0.02f)));
            this.destroyRot += 0.1f;
            float diffX = 90.0f - this.getXRot();
            this.setXRot(this.getXRot() + diffX * 0.001f * this.destroyRot);
            this.setZRot(this.getRoll() - this.destroyRot);
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-this.destroyRot) * 0.005, 0.0));
        }
        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.99f));
        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * 0.85f));
        this.entityData.set(PLANE_BREAK, (Object)Float.valueOf(((Float)this.entityData.get(PLANE_BREAK)).floatValue() * 0.8f));
        Matrix4f transform = this.getVehicleTransform(1.0f);
        double flapAngle = (this.getFlap1LRot() + this.getFlap1RRot() + this.getFlap1L2Rot() + this.getFlap1R2Rot()) / 4.0f;
        Vector4f force0 = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f force1 = this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        Vec3 force = new Vec3((double)force0.x, (double)force0.y, (double)force0.z).vectorTo(new Vec3((double)force1.x, (double)force1.y, (double)force1.z));
        this.setDeltaMovement(this.getDeltaMovement().add(force.scale(this.getDeltaMovement().dot(this.getViewVector(1.0f)) * 0.022 * (1.0 + Math.sin((double)((this.onGround() ? 25.0 : flapAngle + 25.0) * 0.01745329238474369))))));
        this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale(0.2 * (double)((Float)this.entityData.get(POWER)).floatValue())));
    }

    @Override
    public void move(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        if (!this.level().isClientSide()) {
            MobileVehicleEntity.IGNORE_ENTITY_GROUND_CHECK_STEPPING = true;
        }
        if (this.level() instanceof ServerLevel && this.canCollideBlockBeastly()) {
            this.collideBlockBeastly();
        }
        super.move(movementType, movement);
        if (this.level() instanceof ServerLevel) {
            if (this.horizontalCollision) {
                this.collideBlock();
                if (this.canCollideHardBlock()) {
                    this.collideHardBlock();
                }
            }
            if (this.lastTickSpeed < 0.3 || this.collisionCoolDown > 0) {
                return;
            }
            Entity driver = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_DRIVER_UUID));
            if (this.verticalCollision) {
                if ((Integer)this.entityData.get(GEAR_ROT) > 10 || Mth.abs((float)this.getRoll()) > 20.0f) {
                    this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)((double)(8.0f + Mth.abs((float)(this.getRoll() * 0.2f))) * (this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3)));
                    if (!this.level().isClientSide) {
                        this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
                    }
                    this.bounceVertical(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
                } else if ((double)Mth.abs((float)((float)this.lastTickVerticalSpeed)) > 0.4) {
                    this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)(96.0 * (((double)Mth.abs((float)((float)this.lastTickVerticalSpeed)) - 0.4) * (this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3))));
                    if (!this.level().isClientSide) {
                        this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
                    }
                    this.bounceVertical(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
                }
            }
            if (this.horizontalCollision) {
                this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)(126.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
                this.bounceHorizontal(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
                if (!this.level().isClientSide) {
                    this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
                }
                this.collisionCoolDown = 4;
                this.crash = true;
            }
        }
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.A_10_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return ((Float)this.entityData.get(POWER)).floatValue() * (this.sprintInputDown ? 5.5f : 3.0f);
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        float x = 0.0f;
        float y = -0.2f;
        float z = 3.95f;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public Vec3 driverPos(float ticks) {
        Matrix4f transform = this.getVehicleTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.35f, 4.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getVehicleTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.35f, 4.15f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public void copyEntityData(Entity entity) {
        entity.setYHeadRot(entity.getYHeadRot() + this.delta_y);
        entity.setYRot(entity.getYRot() + this.delta_y);
        entity.setYBodyRot(this.getYRot());
    }

    @Override
    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)(this.yo + 2.375), (double)(this.getY() + 2.375)), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot())));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    public void destroy() {
        if (this.crash) {
            this.crashPassengers();
        } else {
            this.explodePassengers();
        }
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this, this.getAttacker()), 300.0f, this.getX(), this.getY(), this.getZ(), 8.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnHugeExplosionParticles(this.level(), this.position());
        }
        super.destroy();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/a10_icon.png");
    }

    @Override
    public Vec3 shootPos(float tickDelta) {
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        Vector4f worldPosition = this.getWeaponIndex(0) == 0 ? this.transformPosition(transform, 0.1321625f, -0.56446874f, 7.852106f) : (this.getWeaponIndex(0) == 1 ? this.transformPosition(transform, 0.0f, -1.443f, 0.13f) : this.transformPosition(transform, 0.0f, -1.203125f, 0.0625f));
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 shootVec(float tickDelta) {
        Vector4f worldPosition2;
        Vector4f worldPosition;
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        if (this.getWeaponIndex(0) == 3) {
            worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
            worldPosition2 = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        } else {
            worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
            worldPosition2 = this.transformPosition(transform, 0.0f, -0.03f, 1.0f);
        }
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).vectorTo(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).normalize();
    }

    @Override
    public Float gearRot(float tickDelta) {
        return Float.valueOf(Mth.lerp((float)tickDelta, (float)this.gearRotO, (float)((Integer)this.entityData.get(GEAR_ROT)).intValue()));
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        if (this.getWeaponIndex(0) == 0) {
            Player pPlayer;
            if (this.cannotFire) {
                return;
            }
            Entity entity = this.getFirstPassenger();
            boolean hasCreativeAmmo = entity instanceof Player && InventoryTool.hasCreativeAmmoBox(pPlayer = (Player)entity);
            Vector4f worldPosition = this.transformPosition(transform, 0.1321625f, -0.56446874f, 7.852106f);
            Vector4f worldPosition2 = this.transformPosition(transform, 0.1421625f, -0.5944687f, 8.852106f);
            Vec3 shootVec = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).vectorTo(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).normalize();
            if ((Integer)this.entityData.get(AMMO) > 0 || hasCreativeAmmo) {
                this.entityData.set(FIRE_TIME, (Object)Math.min((int)((Integer)this.entityData.get(FIRE_TIME) + 6), (int)6));
                SmallCannonShellEntity entityToSpawn = ((SmallCannonShellWeapon)this.getWeapon(0)).create((LivingEntity)player);
                entityToSpawn.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
                entityToSpawn.shoot(shootVec.x, shootVec.y, shootVec.z, 30.0f, 0.5f);
                this.level().addFreshEntity((Entity)entityToSpawn);
                ParticleTool.sendParticle((ServerLevel)this.level(), ParticleTypes.LARGE_SMOKE, worldPosition.x, worldPosition.y, worldPosition.z, 1, 0.2, 0.2, 0.2, 0.001, true);
                ParticleTool.sendParticle((ServerLevel)this.level(), ParticleTypes.CLOUD, worldPosition.x, worldPosition.y, worldPosition.z, 2, 0.5, 0.5, 0.5, 0.005, true);
                if (!hasCreativeAmmo) {
                    this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.shrink(1));
                }
            }
            Level level = player.level();
            Vec3 center = new Vec3(this.getX(), this.getEyeY(), this.getZ());
            for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(5.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                if (!(target instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)target;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(6.0, 5.0, 12.0, this.getX(), this.getEyeY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.entityData.set(HEAT, (Object)((Integer)this.entityData.get(HEAT) + 2));
        } else if (this.getWeaponIndex(0) == 1 && (Integer)this.getEntityData().get(LOADED_ROCKET) > 0) {
            Vector4f worldPosition2;
            Vector4f worldPosition;
            HeliRocketEntity heliRocketEntity = ((HeliRocketWeapon)this.getWeapon(0)).create((LivingEntity)player);
            if (this.fireIndex == 0) {
                worldPosition = this.transformPosition(transform, -3.9321876f, -1.3868062f, 0.12965f);
                worldPosition2 = this.transformPosition(transform, -3.9171875f, -1.4168062f, 1.12965f);
                this.fireIndex = 1;
            } else if (this.fireIndex == 1) {
                worldPosition = this.transformPosition(transform, -1.56875f, -1.443f, 0.1272f);
                worldPosition2 = this.transformPosition(transform, -1.55375f, -1.4729999f, 1.1272f);
                this.fireIndex = 2;
            } else if (this.fireIndex == 2) {
                worldPosition = this.transformPosition(transform, 1.56875f, -1.443f, 0.1272f);
                worldPosition2 = this.transformPosition(transform, 1.57675f, -1.4729999f, 1.1272f);
                this.fireIndex = 3;
            } else {
                worldPosition = this.transformPosition(transform, 3.9321876f, -1.3868062f, 0.12965f);
                worldPosition2 = this.transformPosition(transform, 3.9401875f, -1.4168062f, 1.12965f);
                this.fireIndex = 0;
            }
            Vec3 shootVec = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).vectorTo(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).normalize();
            heliRocketEntity.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
            heliRocketEntity.shoot(shootVec.x, shootVec.y, shootVec.z, 8.0f, 0.5f);
            player.level().addFreshEntity((Entity)heliRocketEntity);
            BlockPos pos = BlockPos.containing((Position)new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
            this.level().playSound(null, pos, (SoundEvent)ModSounds.HELICOPTER_ROCKET_FIRE_3P.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
            this.entityData.set(LOADED_ROCKET, (Object)((Integer)this.getEntityData().get(LOADED_ROCKET) - 1));
            Level level = player.level();
            Vec3 center = new Vec3(this.getX(), this.getEyeY(), this.getZ());
            for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(5.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                if (!(target instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)target;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(6.0, 5.0, 12.0, this.getX(), this.getEyeY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.reloadCoolDown = 15;
        } else if (this.getWeaponIndex(0) == 2 && (Integer)this.getEntityData().get(LOADED_BOMB) > 0) {
            Mk82Entity Mk82Entity2 = ((Mk82Weapon)this.getWeapon(0)).create((LivingEntity)player);
            Vector4f worldPosition = (Integer)this.getEntityData().get(LOADED_BOMB) == 3 ? this.transformPosition(transform, 0.55625f, -1.203125f, 0.0625f) : ((Integer)this.getEntityData().get(LOADED_BOMB) == 2 ? this.transformPosition(transform, 0.0f, -1.203125f, 0.0625f) : this.transformPosition(transform, -0.55625f, -1.203125f, 0.0625f));
            Mk82Entity2.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
            Mk82Entity2.shoot(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, (float)this.getDeltaMovement().length(), 10.0f);
            player.level().addFreshEntity((Entity)Mk82Entity2);
            BlockPos pos = BlockPos.containing((Position)new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
            this.level().playSound(null, pos, (SoundEvent)ModSounds.BOMB_RELEASE.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
            if ((Integer)this.getEntityData().get(LOADED_BOMB) == 3) {
                this.reloadCoolDownBomb = 300;
            }
            this.entityData.set(LOADED_BOMB, (Object)((Integer)this.getEntityData().get(LOADED_BOMB) - 1));
        } else if (this.getWeaponIndex(0) == 3 && (Integer)this.getEntityData().get(LOADED_MISSILE) > 0) {
            Agm65Entity Agm65Entity2 = ((Agm65Weapon)this.getWeapon(0)).create((LivingEntity)player);
            Vector4f worldPosition = (Integer)this.getEntityData().get(LOADED_MISSILE) == 4 ? this.transformPosition(transform, 5.28f, -1.76f, 1.87f) : ((Integer)this.getEntityData().get(LOADED_MISSILE) == 3 ? this.transformPosition(transform, -5.28f, -1.76f, 1.87f) : ((Integer)this.getEntityData().get(LOADED_MISSILE) == 2 ? this.transformPosition(transform, 6.63f, -1.55f, 1.83f) : this.transformPosition(transform, -6.63f, -1.55f, 1.83f)));
            if (this.locked) {
                Agm65Entity2.setTargetUuid(this.getTargetUuid());
            }
            Agm65Entity2.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
            Agm65Entity2.shoot(this.shootVec((float)1.0f).x, this.shootVec((float)1.0f).y, this.shootVec((float)1.0f).z, (float)this.getDeltaMovement().length() + 1.0f, 1.0f);
            player.level().addFreshEntity((Entity)Agm65Entity2);
            BlockPos pos = BlockPos.containing((Position)new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z));
            this.level().playSound(null, pos, (SoundEvent)ModSounds.BOMB_RELEASE.get(), SoundSource.PLAYERS, 3.0f, 1.0f);
            if ((Integer)this.getEntityData().get(LOADED_MISSILE) == 3) {
                this.reloadCoolDownMissile = 400;
            }
            this.entityData.set(LOADED_MISSILE, (Object)((Integer)this.getEntityData().get(LOADED_MISSILE) - 1));
        }
    }

    public float shootingVolume() {
        return (float)((Integer)this.entityData.get(FIRE_TIME)).intValue() * 0.3f;
    }

    public float shootingPitch() {
        return 0.7f + (float)((Integer)this.entityData.get(FIRE_TIME)).intValue() * 0.05f;
    }

    @Override
    public int mainGunRpm(Player player) {
        if (this.getWeaponIndex(0) == 2) {
            return 600;
        }
        if (this.getWeaponIndex(0) == 3) {
            return 120;
        }
        return 0;
    }

    public boolean isFiring() {
        return (Integer)this.entityData.get(FIRE_TIME) > 0;
    }

    @Override
    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 2 || this.getWeaponIndex(0) == 3) {
            return (Integer)this.entityData.get(AMMO) > 0;
        }
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (Integer)this.entityData.get(AMMO);
    }

    @Override
    public boolean banHand(Player player) {
        return true;
    }

    @Override
    public boolean hidePassenger(Entity entity) {
        return false;
    }

    @Override
    public int zoomFov() {
        return 3;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return (Integer)this.entityData.get(HEAT);
    }

    @Override
    public float getRotX(float tickDelta) {
        return this.getPitch(tickDelta);
    }

    @Override
    public float getRotY(float tickDelta) {
        return this.getYaw(tickDelta);
    }

    @Override
    public float getRotZ(float tickDelta) {
        return this.getRoll(tickDelta);
    }

    @Override
    public float getPower() {
        return ((Float)this.entityData.get(POWER)).floatValue();
    }

    @Override
    public int getDecoy() {
        return (Integer)this.entityData.get(DECOY_COUNT);
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return 0.0;
    }

    @Override
    public double getMouseSensitivity() {
        return ClientEventHandler.zoomVehicle ? 0.03 : 0.07;
    }

    @Override
    public double getMouseSpeedX() {
        return 0.3;
    }

    @Override
    public double getMouseSpeedY() {
        return 0.3;
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return Pair.of((Object)Axis.XP.rotationDegrees(-this.getViewXRot(tickDelta)), (Object)Axis.ZP.rotationDegrees(-this.getRoll(tickDelta)));
    }

    public Matrix4f getClientVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)(this.yo + 2.375), (double)(this.getY() + 2.375)), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees((float)((double)(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())) + ClientMouseHandler.freeCameraYaw)));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees((float)((double)Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot()) + ClientMouseHandler.freeCameraPitch)));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            return new Vec2((float)((double)(this.getRotY(partialTicks) - 0.5f * Mth.lerp((float)partialTicks, (float)this.delta_yo, (float)this.delta_y)) - ClientMouseHandler.freeCameraYaw), (float)((double)(this.getRotX(partialTicks) - 0.5f * Mth.lerp((float)partialTicks, (float)this.delta_xo, (float)this.delta_x)) + ClientMouseHandler.freeCameraPitch));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            Matrix4f transform = this.getClientVehicleTransform(partialTicks);
            Vector4f maxCameraPosition = this.transformPosition(transform, 0.0f, 4.0f, -14.0f - (float)ClientMouseHandler.custom3pDistanceLerp);
            Vec3 finalPos = CameraTool.getMaxZoom(transform, maxCameraPosition);
            if (isFirstPerson) {
                return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()));
            }
            return finalPos;
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/aircraft.png");
    }
}

