/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimable;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Hpj11Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
CannonEntity,
OwnableEntity,
AutoAimable {
    public static Consumer<MobileVehicleEntity> fireSound = vehicle -> {};
    public static final EntityDataAccessor<Integer> ANIM_TIME = SynchedEntityData.defineId(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> GUN_ROTATE = SynchedEntityData.defineId(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Integer> FIRE_TIME = SynchedEntityData.defineId(Hpj11Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean wasFiring = false;
    public int changeTargetTimer = 60;
    public float gunRot;
    public float gunRotO;

    public Hpj11Entity(EntityType<Hpj11Entity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANIM_TIME, (Object)0).define(GUN_ROTATE, (Object)Float.valueOf(0.0f)).define(TARGET_UUID, (Object)"none").define(OWNER_UUID, Optional.empty()).define(ACTIVE, (Object)false).define(FIRE_TIME, (Object)0);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage(((Double)VehicleConfig.HPJ11_DAMAGE.get()).floatValue()).explosionDamage(((Double)VehicleConfig.HPJ11_EXPLOSION_DAMAGE.get()).floatValue()).explosionRadius(((Double)VehicleConfig.HPJ11_EXPLOSION_RADIUS.get()).floatValue()).aa(true).icon(Mod.loc("textures/screens/vehicle_weapon/cannon_30mm.png"))}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(2.0 + 0.75 * ClientMouseHandler.custom3pDistanceLerp, 0.75, 0.0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("AnimTime", ((Integer)this.entityData.get(ANIM_TIME)).intValue());
        compound.putBoolean("Active", ((Boolean)this.entityData.get(ACTIVE)).booleanValue());
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        this.entityData.set(ANIM_TIME, (Object)compound.getInt("AnimTime"));
        this.entityData.set(ACTIVE, (Object)compound.getBoolean("Active"));
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            assert (this.getServer() != null);
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (player.isCrouching()) {
            if (stack.is((Item)ModItems.CROWBAR.get()) && (this.getOwner() == null || player == this.getOwner())) {
                ItemStack container = ContainerBlockItem.createInstance(this);
                if (!player.addItem(container)) {
                    player.drop(container, false);
                }
                this.remove(Entity.RemovalReason.DISCARDED);
                this.discard();
                return InteractionResult.SUCCESS;
            }
            if (this.getOwnerUUID() == null) {
                this.setOwnerUUID(player.getUUID());
            }
            if (this.getOwner() == player) {
                this.entityData.set(ACTIVE, (Object)((Boolean)this.entityData.get(ACTIVE) == false ? 1 : 0));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            return InteractionResult.PASS;
        }
        this.entityData.set(TARGET_UUID, (Object)"none");
        return super.interact(player, hand);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 1.0f) * damage.floatValue()));
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        return new Vec3(0.0, Math.min((double)super.getDeltaMovement().y, (double)0.0), 0.0);
    }

    @Override
    public void baseTick() {
        if (!this.wasFiring && this.isFiring() && this.level().isClientSide()) {
            fireSound.accept(this);
        }
        this.wasFiring = this.isFiring();
        this.gunRotO = this.getGunRot();
        super.baseTick();
        if ((Integer)this.entityData.get(ANIM_TIME) > 0) {
            this.entityData.set(ANIM_TIME, (Object)((Integer)this.entityData.get(ANIM_TIME) - 1));
        }
        if (this.level() instanceof ServerLevel) {
            this.handleAmmo();
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround()) {
            this.setDeltaMovement(Vec3.ZERO);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        Entity entity = this.getFirstPassenger();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.fireInputDown && ((Integer)this.entityData.get(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox(player)) && !this.cannotFire) {
                this.vehicleShoot(player, 0);
            }
        }
        this.entityData.set(GUN_ROTATE, (Object)Float.valueOf(((Float)this.entityData.get(GUN_ROTATE)).floatValue() * 0.8f));
        this.setGunRot(this.getGunRot() + ((Float)this.entityData.get(GUN_ROTATE)).floatValue());
        this.autoAim();
        if ((Integer)this.entityData.get(FIRE_TIME) > 0) {
            this.entityData.set(FIRE_TIME, (Object)((Integer)this.entityData.get(FIRE_TIME) - 1));
        }
        this.lowHealthWarning();
    }

    private void handleAmmo() {
        if (this.hasItem((Item)ModItems.CREATIVE_AMMO_BOX.get())) {
            this.entityData.set(AMMO, (Object)9999);
        } else {
            this.entityData.set(AMMO, (Object)this.countItem((Item)ModItems.SMALL_SHELL.get()));
        }
    }

    public boolean isFiring() {
        return (Integer)this.entityData.get(FIRE_TIME) > 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void autoAim() {
        block15: {
            block14: {
                LivingEntity living;
                Player player1;
                LivingEntity livingEntity;
                Entity target;
                Entity naerestEntity;
                if (this.getFirstPassenger() != null || !((Boolean)this.entityData.get(ACTIVE)).booleanValue()) {
                    return;
                }
                if (this.getEnergy() <= (Integer)VehicleConfig.HPJ11_SEEK_COST.get()) {
                    return;
                }
                Matrix4f transform = this.getBarrelTransform(1.0f);
                Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.4f, 0.0f);
                Vec3 barrelRootPos = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
                if (((String)this.entityData.get(TARGET_UUID)).equals("none") && this.tickCount % 2 == 0 && (naerestEntity = this.seekNearLivingEntity(this, barrelRootPos, -32.5, 90.0, 3.0, 160.0, 0.3)) != null) {
                    this.entityData.set(TARGET_UUID, (Object)naerestEntity.getStringUUID());
                    this.consumeEnergy((Integer)VehicleConfig.HPJ11_SEEK_COST.get());
                }
                if ((target = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(TARGET_UUID))) == null || !((livingEntity = this.getOwner()) instanceof Player)) break block14;
                Player player = (Player)livingEntity;
                if (!SeekTool.smokeFilter(target)) break block14;
                if (target instanceof Player && ((player1 = (Player)target).isSpectator() || player1.isCreative())) {
                    this.entityData.set(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target.distanceTo((Entity)this) > 160.0f) {
                    this.entityData.set(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target instanceof LivingEntity && (living = (LivingEntity)target).getHealth() <= 0.0f) {
                    this.entityData.set(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target == this || target instanceof TargetEntity) {
                    this.entityData.set(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target instanceof Projectile && (VectorTool.calculateAngle(target.getDeltaMovement().normalize(), target.position().vectorTo(this.position()).normalize()) > 60.0 || target.onGround())) {
                    this.entityData.set(TARGET_UUID, (Object)"none");
                    return;
                }
                if (target.getVehicle() != null) {
                    this.entityData.set(TARGET_UUID, (Object)target.getVehicle().getStringUUID());
                }
                Vec3 targetPos = new Vec3(target.getX(), target.getY() + (double)(target.getBbHeight() / 4.0f), target.getZ()).add(target.getDeltaMovement().scale(1.0 + 0.04 * (double)target.distanceTo((Entity)this)));
                Vec3 targetVec = barrelRootPos.vectorTo(targetPos).normalize();
                double d0 = targetVec.x;
                double d1 = targetVec.y;
                double d2 = targetVec.z;
                double d3 = Math.sqrt((double)(d0 * d0 + d2 * d2));
                this.setXRot(Mth.clamp((float)Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875)))), (float)-90.0f, (float)40.0f));
                float targetY = Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
                float diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.wrapDegrees((float)(targetY - this.getYRot())));
                this.turretTurnSound(0.0f, diffY, 1.1f);
                this.setYRot(this.getYRot() + Mth.clamp((float)(0.9f * diffY), (float)-20.0f, (float)20.0f));
                if (target.distanceTo((Entity)this) <= 144.0f && VectorTool.calculateAngle(this.getViewVector(1.0f), targetVec) < 10.0) {
                    if (this.checkNoClip(this, target, barrelRootPos) && (Integer)this.entityData.get(AMMO) > 0) {
                        this.vehicleShoot(player, 0);
                        this.findEntityOnPath(barrelRootPos, targetVec, 0.3);
                    } else {
                        ++this.changeTargetTimer;
                    }
                    if (!target.isAlive()) {
                        this.entityData.set(TARGET_UUID, (Object)"none");
                    }
                }
                break block15;
            }
            this.entityData.set(TARGET_UUID, (Object)"none");
        }
        if (this.changeTargetTimer > 60) {
            this.entityData.set(TARGET_UUID, (Object)"none");
            this.changeTargetTimer = 0;
        }
    }

    @Override
    public boolean basicEnemyFilter(Entity pEntity) {
        if (pEntity instanceof Projectile) {
            return false;
        }
        if (this.getOwner() == null) {
            return false;
        }
        if (pEntity.getTeam() == null) {
            return false;
        }
        return !pEntity.isAlliedTo((Entity)this.getOwner()) || pEntity.getTeam() != null && pEntity.getTeam().getName().equals("TDM");
    }

    @Override
    public boolean basicEnemyProjectileFilter(Projectile projectile) {
        if (this.getOwner() == null) {
            return false;
        }
        if (projectile.getOwner() == null) {
            return false;
        }
        if (projectile.getOwner() == this.getOwner()) {
            return false;
        }
        return !projectile.getOwner().isAlliedTo((Entity)this.getOwner()) || projectile.getOwner().getTeam() != null && projectile.getOwner().getTeam().getName().equals("TDM");
    }

    public void findEntityOnPath(Vec3 pos, Vec3 toVec, double size) {
        for (Entity target : this.level().getEntitiesOfClass(Entity.class, new AABB(pos, pos).inflate(0.125).expandTowards(toVec.scale(30.0)), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(pos))).toList()) {
            boolean condition = target instanceof Projectile && this.isThreateningEntity(this, target, size, pos) && SeekTool.smokeFilter(target);
            if (!condition) continue;
            this.causeAirExplode(target.position());
            target.discard();
        }
    }

    private void causeAirExplode(Vec3 vec3) {
        CustomExplosion explosion = new CustomExplosion(this.level(), this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), this, (Entity)this.getOwner()), ((Double)VehicleConfig.HPJ11_EXPLOSION_DAMAGE.get()).floatValue(), vec3.x, vec3.y, vec3.z, ((Double)VehicleConfig.HPJ11_EXPLOSION_RADIUS.get()).floatValue(), (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.25f);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnMediumExplosionParticles(this.level(), vec3);
    }

    public float getGunRot() {
        return this.gunRot;
    }

    public void setGunRot(float pGunRot) {
        this.gunRot = pGunRot;
    }

    @Override
    public void handleClientSync() {
        if (this.isControlledByLocalInstance()) {
            this.interpolationSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.wrapDegrees((double)(this.serverYRot - (double)this.getYRot()));
        this.setYRot(this.getYRot() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.setXRot(this.getXRot() + (float)(this.serverXRot - (double)this.getXRot()) / (float)this.interpolationSteps);
        this.setRot(this.getYRot(), this.getXRot());
    }

    @Override
    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.serverYRot = yRot;
        this.serverXRot = xRot;
        this.interpolationSteps = 10;
    }

    @Override
    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this.getAttacker(), this.getAttacker()), 100.0f, this.getX(), this.getY(), this.getZ(), 7.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
        }
        this.explodePassengers();
        super.destroy();
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        passenger.setPos(this.getX(), this.getY(), this.getZ());
        callback.accept(passenger, this.getX(), this.getY(), this.getZ());
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float g = Mth.clamp((float)f, (float)-90.0f, (float)90.0f);
        entity.yRotO += g - f;
        entity.setYRot(entity.getYRot() + g - f);
        entity.setYHeadRot(entity.getYRot());
        entity.setYBodyRot(this.getYRot());
    }

    public Vec3 driverPos(float ticks) {
        Matrix4f transform = this.getVehicleFlatTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, -1.0625f, 3.25f, -1.0625f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getBarrelTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        Player pPlayer;
        if (this.cannotFire) {
            return;
        }
        if (this.getEnergy() < (Integer)VehicleConfig.HPJ11_SHOOT_COST.get()) {
            return;
        }
        Entity entity = this.getFirstPassenger();
        boolean hasCreativeAmmo = entity instanceof Player && InventoryTool.hasCreativeAmmoBox(pPlayer = (Player)entity) || this.hasItem((Item)ModItems.CREATIVE_AMMO_BOX.get());
        this.entityData.set(FIRE_TIME, (Object)Math.min((int)((Integer)this.entityData.get(FIRE_TIME) + 3), (int)5));
        SmallCannonShellEntity entityToSpawn = ((SmallCannonShellWeapon)this.getWeapon(0)).create((LivingEntity)player);
        Matrix4f transform = this.getBarrelTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.4f, 2.6875f);
        entityToSpawn.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
        entityToSpawn.shoot(this.getLookAngle().x, this.getLookAngle().y + 0.001, this.getLookAngle().z, 30.0f, 0.75f);
        this.level().addFreshEntity((Entity)entityToSpawn);
        this.entityData.set(GUN_ROTATE, (Object)Float.valueOf(((Float)this.entityData.get(GUN_ROTATE)).floatValue() + 0.5f));
        this.entityData.set(HEAT, (Object)((Integer)this.entityData.get(HEAT) + 2));
        this.entityData.set(ANIM_TIME, (Object)1);
        this.consumeEnergy((Integer)VehicleConfig.HPJ11_SHOOT_COST.get());
        if (hasCreativeAmmo) {
            return;
        }
        this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.shrink(1));
    }

    public float shootingVolume() {
        return (float)((Integer)this.entityData.get(FIRE_TIME)).intValue() * 0.4f;
    }

    public float shootingPitch() {
        return 0.8f + (float)((Integer)this.entityData.get(FIRE_TIME)).intValue() * 0.1f;
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformV = this.getVehicleFlatTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.375f, 0.25f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot())));
        return transformV;
    }

    @Override
    public void travel() {
        if (this.getEnergy() <= 0) {
            return;
        }
        Entity passenger = this.getFirstPassenger();
        if (passenger != null) {
            float diffY = Mth.wrapDegrees((float)(passenger.getYHeadRot() - this.getYRot()));
            float diffX = Mth.wrapDegrees((float)(passenger.getXRot() - this.getXRot()));
            this.turretTurnSound(diffX, diffY, 0.95f);
            this.setYRot(this.getYRot() + Mth.clamp((float)(0.9f * diffY), (float)-20.0f, (float)20.0f));
            this.setXRot(Mth.clamp((float)(this.getXRot() + Mth.clamp((float)(0.9f * diffX), (float)-15.0f, (float)15.0f)), (float)-90.0f, (float)32.5f));
        }
    }

    protected void clampRotation(Entity entity) {
        float f = Mth.wrapDegrees((float)entity.getXRot());
        float f1 = Mth.clamp((float)f, (float)-90.0f, (float)32.5f);
        entity.xRotO += f1 - f;
        entity.setXRot(entity.getXRot() + f1 - f);
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        return 0;
    }

    @Override
    public boolean canShoot(Player player) {
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (Integer)this.entityData.get(AMMO);
    }

    @Override
    public boolean hidePassenger(Entity entity) {
        return true;
    }

    @Override
    public int zoomFov() {
        return 2;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return (Integer)this.entityData.get(HEAT);
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        if (this.getFirstPassenger() != null) {
            return this.getFirstPassenger().getViewVector(pPartialTicks);
        }
        return super.getBarrelVector(pPartialTicks);
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/hpj_11.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.25 : 0.3;
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            return new Vec2(Mth.lerp((float)partialTicks, (float)player.yRotO, (float)player.getYRot()), Mth.lerp((float)partialTicks, (float)player.xRotO, (float)player.getXRot()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (zoom) {
                return new Vec3(this.driverZoomPos((float)partialTicks).x, this.driverZoomPos((float)partialTicks).y, this.driverZoomPos((float)partialTicks).z);
            }
            return new Vec3(this.driverPos((float)partialTicks).x, this.driverPos((float)partialTicks).y, this.driverPos((float)partialTicks).z);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/defense.png");
    }
}

