/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.AutoAimable;
import com.atsuishio.superbwarfare.entity.vehicle.base.EnergyVehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.ContainerBlockItem;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class LaserTowerEntity
extends EnergyVehicleEntity
implements GeoEntity,
OwnableEntity,
AutoAimable {
    public static final EntityDataAccessor<Integer> COOL_DOWN = SynchedEntityData.defineId(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.defineId(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public static final EntityDataAccessor<Float> LASER_LENGTH = SynchedEntityData.defineId(LaserTowerEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int changeTargetTimer = 60;

    public LaserTowerEntity(EntityType<LaserTowerEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    public LaserTowerEntity(LivingEntity owner, Level level) {
        super((EntityType)ModEntities.LASER_TOWER.get(), level);
        if (owner != null) {
            this.setOwnerUUID(owner.getUUID());
        }
    }

    public boolean isOwnedBy(LivingEntity pEntity) {
        return pEntity == this.getOwner();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_UUID, (Object)"none").define(OWNER_UUID, Optional.empty()).define(COOL_DOWN, (Object)0).define(LASER_LENGTH, (Object)Float.valueOf(0.0f)).define(ACTIVE, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("CoolDown", ((Integer)this.entityData.get(COOL_DOWN)).intValue());
        compound.putBoolean("Active", ((Boolean)this.entityData.get(ACTIVE)).booleanValue());
        if (this.getOwnerUUID() != null) {
            compound.putUUID("Owner", this.getOwnerUUID());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        this.entityData.set(COOL_DOWN, (Object)compound.getInt("CoolDown"));
        this.entityData.set(ACTIVE, (Object)compound.getBoolean("Active"));
        if (compound.hasUUID("Owner")) {
            uuid = compound.getUUID("Owner");
        } else {
            String s = compound.getString("Owner");
            assert (this.getServer() != null);
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setOwnerUUID(@Nullable UUID pUuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (player.isCrouching()) {
            if (stack.is((Item)ModItems.CROWBAR.get()) && (this.getOwner() == null || player == this.getOwner())) {
                ItemStack container = ContainerBlockItem.createInstance(this);
                if (!player.addItem(container)) {
                    player.drop(container, false);
                }
                this.remove(Entity.RemovalReason.DISCARDED);
                this.discard();
                return InteractionResult.SUCCESS;
            }
            if (this.getOwnerUUID() == null) {
                this.setOwnerUUID(player.getUUID());
            }
            if (this.getOwner() == player) {
                this.entityData.set(ACTIVE, (Object)((Boolean)this.entityData.get(ACTIVE) == false ? 1 : 0));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        return new Vec3(0.0, Math.min((double)super.getDeltaMovement().y, (double)0.0), 0.0);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if ((Integer)this.entityData.get(COOL_DOWN) > 0) {
            this.entityData.set(COOL_DOWN, (Object)((Integer)this.entityData.get(COOL_DOWN) - 1));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround()) {
            this.setDeltaMovement(Vec3.ZERO);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.autoAim();
    }

    @Override
    public void handleClientSync() {
        if (this.isControlledByLocalInstance()) {
            this.interpolationSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.wrapDegrees((double)(this.serverYRot - (double)this.getYRot()));
        this.setYRot(this.getYRot() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.setXRot(this.getXRot() + (float)(this.serverXRot - (double)this.getXRot()) / (float)this.interpolationSteps);
        this.setRot(this.getYRot(), this.getXRot());
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    @Override
    public void destroy() {
        Entity attacker = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_ATTACKER_UUID));
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), attacker, attacker), 10.0f, this.getX(), this.getY(), this.getZ(), 3.0f, Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
        }
        super.destroy();
    }

    public void autoAim() {
        Entity target;
        Entity naerestEntity;
        if (this.getEnergy() <= 0 || !((Boolean)this.entityData.get(ACTIVE)).booleanValue()) {
            return;
        }
        Vec3 barrelRootPos = new Vec3(this.getX(), this.getY() + 1.390625, this.getZ());
        if (((String)this.entityData.get(TARGET_UUID)).equals("none") && this.tickCount % 10 == 0 && (Integer)this.entityData.get(COOL_DOWN) == 0 && (naerestEntity = this.seekNearLivingEntity(this, barrelRootPos, -40.0, 90.0, 1.0, 72.0, 0.01)) != null) {
            this.entityData.set(TARGET_UUID, (Object)naerestEntity.getStringUUID());
        }
        if ((target = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(TARGET_UUID))) != null && SeekTool.smokeFilter(target)) {
            LivingEntity living;
            Player player1;
            if (target instanceof Player && ((player1 = (Player)target).isSpectator() || player1.isCreative())) {
                this.entityData.set(TARGET_UUID, (Object)"none");
                return;
            }
            if (target.distanceTo((Entity)this) > 72.0f) {
                this.entityData.set(TARGET_UUID, (Object)"none");
                return;
            }
            if (target instanceof LivingEntity && (living = (LivingEntity)target).getHealth() <= 0.0f) {
                this.entityData.set(TARGET_UUID, (Object)"none");
                return;
            }
            if (target == this || target instanceof TargetEntity) {
                this.entityData.set(TARGET_UUID, (Object)"none");
                return;
            }
            if (target instanceof Projectile && (VectorTool.calculateAngle(target.getDeltaMovement().normalize(), target.position().vectorTo(this.position()).normalize()) > 60.0 || target.onGround())) {
                this.entityData.set(TARGET_UUID, (Object)"none");
                return;
            }
            Vec3 targetVec = barrelRootPos.vectorTo(target.getEyePosition()).normalize();
            double d0 = targetVec.x;
            double d1 = targetVec.y;
            double d2 = targetVec.z;
            double d3 = Math.sqrt((double)(d0 * d0 + d2 * d2));
            this.setXRot(Mth.clamp((float)Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875)))), (float)-90.0f, (float)40.0f));
            float targetY = Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
            float diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.wrapDegrees((float)(targetY - this.getYRot())));
            this.turretTurnSound(0.0f, diffY, 1.1f);
            this.setYRot(this.getYRot() + Mth.clamp((float)(0.5f * diffY), (float)-60.0f, (float)60.0f));
            this.setRot(this.getYRot(), this.getXRot());
            if ((Integer)this.entityData.get(COOL_DOWN) == 0 && VectorTool.calculateAngle(this.getViewVector(1.0f), targetVec) < 1.0) {
                ++this.changeTargetTimer;
            }
            if ((Integer)this.entityData.get(COOL_DOWN) == 0 && VectorTool.calculateAngle(this.getViewVector(1.0f), targetVec) < 1.0 && this.checkNoClip(this, target, barrelRootPos)) {
                this.entityData.set(COOL_DOWN, (Object)((Integer)VehicleConfig.LASER_TOWER_COOLDOWN.get()));
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.level().playSound((Entity)this, this.getOnPos(), (SoundEvent)ModSounds.LASER_TOWER_SHOOT.get(), SoundSource.PLAYERS, 2.0f, this.random.nextFloat() * 0.1f + 1.0f);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, target.getX(), target.getEyeY(), target.getZ(), 12, 0.0, 0.0, 0.0, 0.05, true);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, target.getX(), target.getEyeY(), target.getZ(), 4, 0.0, 0.0, 0.0, 0.15, true);
                }
                target.hurt(ModDamageTypes.causeLaserStaticDamage(this.level().registryAccess(), this, (Entity)this.getOwner()), (float)((Integer)VehicleConfig.LASER_TOWER_DAMAGE.get()).intValue());
                target.invulnerableTime = 0;
                this.entityData.set(LASER_LENGTH, (Object)Float.valueOf(this.distanceTo(target)));
                if (Math.random() < 0.25 && target instanceof LivingEntity) {
                    LivingEntity living2 = (LivingEntity)target;
                    living2.setRemainingFireTicks(2);
                }
                if (target instanceof Projectile) {
                    this.causeAirExplode(target.position());
                    target.discard();
                }
                if (!target.isAlive()) {
                    this.entityData.set(TARGET_UUID, (Object)"none");
                }
                this.consumeEnergy((Integer)VehicleConfig.LASER_TOWER_SHOOT_COST.get());
            }
        } else {
            this.entityData.set(TARGET_UUID, (Object)"none");
        }
        if (this.changeTargetTimer > 60) {
            this.entityData.set(TARGET_UUID, (Object)"none");
            this.changeTargetTimer = 0;
        }
    }

    @Override
    public boolean basicEnemyFilter(Entity pEntity) {
        if (pEntity instanceof Projectile) {
            return false;
        }
        if (this.getOwner() == null) {
            return false;
        }
        if (pEntity.getTeam() == null) {
            return false;
        }
        return !pEntity.isAlliedTo((Entity)this.getOwner()) || pEntity.getTeam() != null && pEntity.getTeam().getName().equals("TDM");
    }

    @Override
    public boolean basicEnemyProjectileFilter(Projectile projectile) {
        if (this.getOwner() == null) {
            return false;
        }
        if (projectile.getOwner() == null) {
            return false;
        }
        if (projectile.getOwner() == this.getOwner()) {
            return false;
        }
        return !projectile.getOwner().isAlliedTo((Entity)this.getOwner()) || projectile.getOwner().getTeam() != null && projectile.getOwner().getTeam().getName().equals("TDM");
    }

    private void causeAirExplode(Vec3 vec3) {
        CustomExplosion explosion = new CustomExplosion(this.level(), this, ModDamageTypes.causeProjectileBoomDamage(this.level().registryAccess(), this, (Entity)this.getOwner()), 5.0f, vec3.x, vec3.y, vec3.z, 1.0f, Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
        explosion.explode();
        EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
        explosion.finalizeExplosion(false);
        ParticleTool.spawnMediumExplosionParticles(this.level(), vec3);
    }

    private PlayState movementPredicate(AnimationState<LaserTowerEntity> event) {
        if ((Integer)this.entityData.get(COOL_DOWN) > 10) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.lt.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.lt.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/defense.png");
    }
}

