/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.CannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.CannonEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.CannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.item.common.ammo.CannonShellItem;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Mle1934Entity
extends VehicleEntity
implements GeoEntity,
CannonEntity {
    public static final EntityDataAccessor<Integer> COOL_DOWN = SynchedEntityData.defineId(Mle1934Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.defineId(Mle1934Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> PITCH = SynchedEntityData.defineId(Mle1934Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> YAW = SynchedEntityData.defineId(Mle1934Entity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final float shellGravity = 0.1f;

    public Mle1934Entity(EntityType<Mle1934Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.MLE1934_AP_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.MLE1934_AP_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Integer)VehicleConfig.MLE1934_AP_EXPLOSION_RADIUS.get()).floatValue()).durability(70).gravity(0.1f).sound((SoundEvent)ModSounds.CANNON_RELOAD.get()).icon(Mod.loc("textures/screens/vehicle_weapon/ap_shell.png")), new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.MLE1934_HE_DAMAGE.get()).intValue()).explosionDamage(((Integer)VehicleConfig.MLE1934_HE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Integer)VehicleConfig.MLE1934_HE_EXPLOSION_RADIUS.get()).floatValue()).durability(0).fireProbability(0.24f).fireTime(5).gravity(0.1f).sound((SoundEvent)ModSounds.CANNON_RELOAD.get()).icon(Mod.loc("textures/screens/vehicle_weapon/he_shell.png"))}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(10.0 + 1.25 * ClientMouseHandler.custom3pDistanceLerp, 1.3, 0.0);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COOL_DOWN, (Object)0).define(TYPE, (Object)0).define(PITCH, (Object)Float.valueOf(0.0f)).define(YAW, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("CoolDown", ((Integer)this.entityData.get(COOL_DOWN)).intValue());
        compound.putInt("Type", ((Integer)this.entityData.get(TYPE)).intValue());
        compound.putFloat("Pitch", ((Float)this.entityData.get(PITCH)).floatValue());
        compound.putFloat("Yaw", ((Float)this.entityData.get(YAW)).floatValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(COOL_DOWN, (Object)compound.getInt("CoolDown"));
        this.entityData.set(TYPE, (Object)compound.getInt("Type"));
        this.entityData.set(PITCH, (Object)Float.valueOf(compound.getFloat("Pitch")));
        this.entityData.set(YAW, (Object)Float.valueOf(compound.getFloat("Yaw")));
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (player.getMainHandItem().getItem() == ModItems.FIRING_PARAMETERS.get() && player.isCrouching()) {
            this.setTarget(player.getMainHandItem());
            return InteractionResult.SUCCESS;
        }
        if (player.getOffhandItem().getItem() == ModItems.FIRING_PARAMETERS.get() && player.isCrouching()) {
            this.setTarget(player.getOffhandItem());
            return InteractionResult.SUCCESS;
        }
        if (stack.getItem() instanceof CannonShellItem) {
            if ((Integer)this.entityData.get(COOL_DOWN) == 0) {
                int weaponType = stack.is((Item)ModItems.AP_5_INCHES.get()) ? 0 : 1;
                this.setWeaponIndex(0, weaponType);
                this.vehicleShoot(player, 0);
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public void setTarget(ItemStack stack) {
        FiringParameters.Parameters parameters = (FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS);
        if (parameters == null) {
            return;
        }
        BlockPos pos = parameters.pos();
        int targetX = pos.getX();
        int targetY = pos.getY();
        int targetZ = pos.getZ();
        boolean isDepressed = parameters.isDepressed();
        this.look(new Vec3((double)targetX, (double)targetY, (double)targetZ));
        Matrix4f transform = this.getVehicleFlatTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.4992625f, 1.52065f);
        Vec3 shootPos = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        if (!RangeTool.canReach(15.0, 0.1f, shootPos, new Vec3((double)targetX, (double)targetY, (double)targetZ), -2.7, 30.0, isDepressed)) {
            return;
        }
        this.look(new Vec3((double)targetX, (double)targetY, (double)targetZ));
        this.entityData.set(PITCH, (Object)Float.valueOf((float)(-RangeTool.calculateAngle(15.0, 0.1f, shootPos, new Vec3((double)targetX, (double)targetY, (double)targetZ), isDepressed))));
    }

    private void look(Vec3 pTarget) {
        Matrix4f transform = this.getVehicleFlatTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.4992625f, 1.52065f);
        Vec3 shootPos = new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        double d0 = pTarget.x - shootPos.x;
        double d2 = pTarget.z - shootPos.z;
        this.entityData.set(YAW, (Object)Float.valueOf(Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f))));
    }

    public double getEyeY() {
        return 2.16f;
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleFlatTransform(1.0f);
        float x = 0.0f;
        float y = 2.0f;
        float z = 0.5f;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 1.0f) * damage.floatValue()));
    }

    @NotNull
    public Vec3 getDeltaMovement() {
        return new Vec3(0.0, Math.min((double)super.getDeltaMovement().y, (double)0.0), 0.0);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if ((Integer)this.entityData.get(COOL_DOWN) > 0) {
            this.entityData.set(COOL_DOWN, (Object)((Integer)this.entityData.get(COOL_DOWN) - 1));
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        if (this.onGround()) {
            this.setDeltaMovement(Vec3.ZERO);
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.lowHealthWarning();
    }

    @Override
    public void handleClientSync() {
        if (this.isControlledByLocalInstance()) {
            this.interpolationSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedYaw = Mth.wrapDegrees((double)(this.serverYRot - (double)this.getYRot()));
        this.setYRot(this.getYRot() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.setXRot(this.getXRot() + (float)(this.serverXRot - (double)this.getXRot()) / (float)this.interpolationSteps);
        this.setRot(this.getYRot(), this.getXRot());
    }

    @Override
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int interpolationSteps) {
        this.serverYRot = yaw;
        this.serverXRot = pitch;
        this.interpolationSteps = 10;
    }

    @Override
    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this.getAttacker(), this.getAttacker()), 120.0f, this.getX(), this.getY(), this.getZ(), 6.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
        }
        this.explodePassengers();
        super.destroy();
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getVehicleFlatTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.8992624f, 1.52065f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        if ((Integer)this.entityData.get(COOL_DOWN) > 0) {
            return;
        }
        Level level = player.level();
        if (level instanceof ServerLevel) {
            int consumed;
            ServerLevel server = (ServerLevel)level;
            if (InventoryTool.hasCreativeAmmoBox(player)) {
                consumed = 2;
            } else {
                Item ammo = this.getWeaponIndex(0) == 0 ? (Item)ModItems.AP_5_INCHES.get() : (Item)ModItems.HE_5_INCHES.get();
                int ammoCount = InventoryTool.countItem((NonNullList<ItemStack>)player.getInventory().items, ammo);
                if (ammoCount <= 0) {
                    return;
                }
                consumed = InventoryTool.consumeItem((NonNullList<ItemStack>)player.getInventory().items, ammo, 2);
            }
            boolean salvoShoot = consumed == 2;
            Matrix4f transform = this.getVehicleFlatTransform(1.0f);
            Vector4f worldPositionL = this.transformPosition(transform, 0.486775f, 1.4992625f, 1.52065f);
            Vector4f worldPositionR = this.transformPosition(transform, -0.486775f, 1.4992625f, 1.52065f);
            CannonShellEntity entityToSpawnLeft = ((CannonShellWeapon)this.getWeapon(0)).create(player);
            entityToSpawnLeft.setPos(worldPositionL.x, worldPositionL.y, worldPositionL.z);
            entityToSpawnLeft.shoot(this.getLookAngle().x, this.getLookAngle().y, this.getLookAngle().z, 15.0f, 0.05f);
            level.addFreshEntity((Entity)entityToSpawnLeft);
            server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX() + 5.0 * this.getLookAngle().x, this.getY(), this.getZ() + 5.0 * this.getLookAngle().z, 100, 7.0, 0.02, 7.0, 0.005);
            double x = (double)worldPositionL.x + 9.0 * this.getLookAngle().x;
            double y = (double)worldPositionL.y + 9.0 * this.getLookAngle().y;
            double z = (double)worldPositionL.z + 9.0 * this.getLookAngle().z;
            server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
            server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
            int count = 6;
            for (float i = 9.5f; i < 16.0f; i += 0.5f) {
                server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)worldPositionL.x + (double)i * this.getLookAngle().x, (double)worldPositionL.y + (double)i * this.getLookAngle().y, (double)worldPositionL.z + (double)i * this.getLookAngle().z, Mth.clamp((int)count--, (int)1, (int)5), 0.15, 0.15, 0.15, 0.0025);
            }
            if (salvoShoot) {
                CannonShellEntity entityToSpawnRight = ((CannonShellWeapon)this.getWeapon(0)).create(player);
                entityToSpawnRight.setPos(worldPositionR.x, worldPositionR.y, worldPositionR.z);
                entityToSpawnRight.shoot(this.getLookAngle().x, this.getLookAngle().y, this.getLookAngle().z, 15.0f, 0.05f);
                level.addFreshEntity((Entity)entityToSpawnRight);
                server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX() + 5.0 * this.getLookAngle().x, this.getY(), this.getZ() + 5.0 * this.getLookAngle().z, 100, 7.0, 0.02, 7.0, 0.005);
                double xR = (double)worldPositionR.x + 9.0 * this.getLookAngle().x;
                double yR = (double)worldPositionR.y + 9.0 * this.getLookAngle().y;
                double zR = (double)worldPositionR.z + 9.0 * this.getLookAngle().z;
                server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, xR, yR, zR, 10, 0.4, 0.4, 0.4, 0.0075);
                server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, xR, yR, zR, 10, 0.4, 0.4, 0.4, 0.0075);
                int countR = 6;
                for (float i = 9.5f; i < 16.0f; i += 0.5f) {
                    server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)worldPositionR.x + (double)i * this.getLookAngle().x, (double)worldPositionR.y + (double)i * this.getLookAngle().y, (double)worldPositionR.z + (double)i * this.getLookAngle().z, Mth.clamp((int)countR--, (int)1, (int)5), 0.15, 0.15, 0.15, 0.0025);
                }
                this.entityData.set(TYPE, (Object)1);
            } else {
                this.entityData.set(TYPE, (Object)-1);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.MK_42_FIRE_1P.get(), 2.0f, 1.0f);
                Mod.queueServerWork(44, () -> SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.CANNON_RELOAD.get(), 2.0f, 1.0f));
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.MK_42_FIRE_3P.get(), SoundSource.PLAYERS, 6.0f, 1.0f);
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.MK_42_FAR.get(), SoundSource.PLAYERS, 16.0f, 1.0f);
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.MK_42_VERYFAR.get(), SoundSource.PLAYERS, 32.0f, 1.0f);
            }
            this.entityData.set(COOL_DOWN, (Object)74);
            server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX() + 5.0 * this.getLookAngle().x, this.getY(), this.getZ() + 5.0 * this.getLookAngle().z, 100, 7.0, 0.02, 7.0, 0.005);
            Vec3 center = new Vec3(this.getX(), this.getEyeY(), this.getZ());
            for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(20.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                if (!(target instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)target;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(15.0, 15.0, 45.0, this.getX(), this.getEyeY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.getFirstPassenger();
        if (passenger != null) {
            this.entityData.set(YAW, (Object)Float.valueOf(passenger.getYHeadRot()));
            this.entityData.set(PITCH, (Object)Float.valueOf(passenger.getXRot() - 2.0f));
        }
        float diffY = Mth.wrapDegrees((float)(((Float)this.entityData.get(YAW)).floatValue() - this.getYRot()));
        float diffX = Mth.wrapDegrees((float)(((Float)this.entityData.get(PITCH)).floatValue() - this.getXRot()));
        this.turretTurnSound(diffX, diffY, 0.95f);
        this.setYRot(this.getYRot() + Mth.clamp((float)(0.5f * diffY), (float)-1.25f, (float)1.25f));
        this.setXRot(Mth.clamp((float)(this.getXRot() + Mth.clamp((float)(0.5f * diffX), (float)-2.0f, (float)2.0f)), (float)-30.0f, (float)5.0f));
    }

    protected void clampRotation(Entity entity) {
        float f = Mth.wrapDegrees((float)entity.getXRot());
        float f1 = Mth.clamp((float)f, (float)-30.0f, (float)7.0f);
        entity.xRotO += f1 - f;
        entity.setXRot(entity.getXRot() + f1 - f);
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState movementPredicate(AnimationState<Mle1934Entity> event) {
        if ((Integer)this.entityData.get(COOL_DOWN) > 64) {
            if ((Integer)this.entityData.get(TYPE) == 1) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mle1934.salvo_fire"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.mle1934.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.mle1934.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        return 0;
    }

    @Override
    public boolean canShoot(Player player) {
        return true;
    }

    @Override
    public int getAmmoCount(Player player) {
        Item ammo = this.getWeaponIndex(0) == 0 ? (Item)ModItems.AP_5_INCHES.get() : (Item)ModItems.HE_5_INCHES.get();
        return InventoryTool.countItem((NonNullList<ItemStack>)player.getInventory().items, ammo);
    }

    @Override
    public boolean banHand(Player player) {
        return true;
    }

    @Override
    public boolean hidePassenger(Entity entity) {
        return true;
    }

    @Override
    public int zoomFov() {
        return 5;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return 0;
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        if (this.getFirstPassenger() != null) {
            return this.getFirstPassenger().getViewVector(pPartialTicks);
        }
        return super.getBarrelVector(pPartialTicks);
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/mle1934_icon.png");
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.15 : 0.3;
    }

    @Override
    public boolean isEnclosed(int index) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            return new Vec2(Mth.lerp((float)partialTicks, (float)player.yRotO, (float)player.getYRot()), Mth.lerp((float)partialTicks, (float)player.xRotO, (float)player.getXRot()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (zoom) {
                return new Vec3(this.driverZoomPos((float)partialTicks).x, this.driverZoomPos((float)partialTicks).y, this.driverZoomPos((float)partialTicks).z);
            }
            return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()));
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return true;
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/defense.png");
    }
}

