/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.AerialBombEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.Comparator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SpeedboatEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
ArmedVehicleEntity,
WeaponVehicleEntity,
LandArmorEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SpeedboatEntity(EntityType<SpeedboatEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new ProjectileWeapon().damage(((Integer)VehicleConfig.HEAVY_MACHINE_GUN_DAMAGE.get()).intValue()).headShot(2.0f).zoom(false).icon(Mod.loc("textures/screens/vehicle_weapon/gun_12_7mm.png")).sound1p((SoundEvent)ModSounds.M_2_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M_2_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M_2_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M_2_VERYFAR.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(3.0 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
    }

    @NotNull
    public Vec3 getPassengerRidingPosition(@NotNull Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, -0.8, 0.0);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> {
            if (source.getDirectEntity() instanceof AerialBombEntity) {
                return Float.valueOf(2.0f * damage.floatValue());
            }
            return damage;
        });
    }

    @Override
    public void baseTick() {
        super.baseTick();
        double fluidFloat = 0.12 * this.getSubmergedHeight(this);
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, fluidFloat, 0.0));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.2, 0.99, 0.2));
        } else if (this.isInWater()) {
            float f = (float)(0.75 - (double)0.04f * Math.min(this.getSubmergedHeight(this), (double)this.getBbHeight()) + (double)(0.09f * Mth.abs((float)(90.0f - (float)SpeedboatEntity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f));
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).normalize().scale(0.04 * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.85, (double)f));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isInWater() && this.getDeltaMovement().length() > 0.1) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, this.getX() + 0.5 * this.getDeltaMovement().x, this.getY() + this.getSubmergedHeight(this) - 0.2, this.getZ() + 0.5 * this.getDeltaMovement().z, (int)(2.0 + 4.0 * this.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, this.getX() + 0.5 * this.getDeltaMovement().x, this.getY() + this.getSubmergedHeight(this) - 0.2, this.getZ() + 0.5 * this.getDeltaMovement().z, (int)(2.0 + 10.0 * this.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, this.getX() - 4.5 * this.getLookAngle().x, this.getY() - 0.25, this.getZ() - 4.5 * this.getLookAngle().z, (int)(40.0f * Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue())), 0.15, 0.15, 0.15, 0.02, true);
            }
        }
        if (this.level() instanceof ServerLevel) {
            this.handleAmmo();
        }
        this.turretAngle(40.0f, 40.0f);
        this.lowHealthWarning();
        this.inertiaRotate(2.0f);
        this.terrainCompact(2.0f, 3.0f);
        this.refreshDimensions();
    }

    @Override
    public boolean canCollideHardBlock() {
        return this.getDeltaMovement().horizontalDistance() > 0.15;
    }

    private void handleAmmo() {
        if (!(this.getFirstPassenger() instanceof Player)) {
            return;
        }
        int ammoCount = this.getItemStacks().stream().filter(stack -> {
            if (stack.is((Item)ModItems.AMMO_BOX.get())) {
                return Ammo.HEAVY.get((ItemStack)stack) > 0;
            }
            return false;
        }).mapToInt(Ammo.HEAVY::get).sum() + this.countItem((Item)ModItems.HEAVY_AMMO.get());
        this.entityData.set(AMMO, (Object)ammoCount);
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        float pitch;
        if (this.cannotFire) {
            return;
        }
        Matrix4f transform = this.getBarrelTransform(1.0f);
        float x = 0.0f;
        float y = 0.00106875f;
        float z = 1.9117f;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        ProjectileEntity projectile = ((ProjectileWeapon)this.getWeapon(0)).create((LivingEntity)player).setGunItemId(this.getType().getDescriptionId());
        projectile.bypassArmorRate(0.4f);
        projectile.setPos((double)worldPosition.x + 0.5 * this.getDeltaMovement().x, worldPosition.y, (double)worldPosition.z + 0.5 * this.getDeltaMovement().z);
        projectile.shoot(player, this.getBarrelVector((float)1.0f).x, this.getBarrelVector((float)1.0f).y + (double)0.005f, this.getBarrelVector((float)1.0f).z, 20.0f, 0.4f);
        this.level().addFreshEntity((Entity)projectile);
        float f = pitch = (Integer)this.entityData.get(HEAT) <= 60 ? 1.0f : (float)(1.0 - 0.011 * (double)org.joml.Math.abs((int)(60 - (Integer)this.entityData.get(HEAT))));
        if (!player.level().isClientSide) {
            this.playShootSound3p(player, 0, 4, 12, 24);
        }
        Level level = player.level();
        Vec3 center = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(4.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
            if (!(target instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)target;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(6.0, 5.0, 5.0, this.getX(), this.getEyeY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.entityData.set(CANNON_RECOIL_TIME, (Object)30);
        this.entityData.set(YAW, (Object)Float.valueOf(this.getTurretYRot()));
        this.entityData.set(HEAT, (Object)((Integer)this.entityData.get(HEAT) + 4));
        this.entityData.set(FIRE_ANIM, (Object)3);
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox(pPlayer = (Player)entity)) continue;
            hasCreativeAmmo = true;
        }
        if (!hasCreativeAmmo) {
            ItemStack ammoBox = this.getItemStacks().stream().filter(stack -> {
                if (stack.is((Item)ModItems.AMMO_BOX.get())) {
                    return Ammo.HEAVY.get((ItemStack)stack) > 0;
                }
                return false;
            }).findFirst().orElse(ItemStack.EMPTY);
            if (!ammoBox.isEmpty()) {
                Ammo.HEAVY.add(ammoBox, -1);
            } else {
                this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.HEAVY_AMMO.get())).findFirst().ifPresent(stack -> stack.shrink(1));
            }
        }
    }

    @Override
    public void travel() {
        Entity passenger0 = this.getFirstPassenger();
        if (this.getEnergy() > 0) {
            if (passenger0 == null) {
                this.leftInputDown = false;
                this.rightInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
            }
            if (this.forwardInputDown) {
                this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() + 0.005f));
            }
            if (this.backInputDown) {
                this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() - 0.005f));
                if (this.rightInputDown) {
                    this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.1f));
                } else if (this.leftInputDown) {
                    this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.1f));
                }
            } else if (this.rightInputDown) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.1f));
            } else if (this.leftInputDown) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.1f));
            }
            if (this.forwardInputDown || this.backInputDown) {
                this.consumeEnergy((Integer)VehicleConfig.SPEEDBOAT_ENERGY_COST.get());
            }
            this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.96f));
            this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * 0.8f));
            this.setRotorRot(this.getRotorRot() + 30.0f * ((Float)this.entityData.get(POWER)).floatValue());
            this.setRudderRot(Mth.clamp((float)(this.getRudderRot() - ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)-1.25f, (float)1.25f) * 0.7f * (float)(((Float)this.entityData.get(POWER)).floatValue() > 0.0f ? 1 : -1));
            if (this.isInWater() || this.isUnderWater()) {
                this.setXRot(this.getXRot() * 0.85f);
                float direct = (90.0f - (float)SpeedboatEntity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f))) / 90.0f;
                this.setXRot((float)((double)this.getXRot() - (double)(direct * (float)(!this.onGround() ? 1 : 0) * 1.1f) * this.getDeltaMovement().horizontalDistance()));
                this.setYRot((float)((double)this.getYRot() - org.joml.Math.max((double)(12.0 * this.getDeltaMovement().length()), (double)0.8) * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()));
                this.setZRot((float)((double)this.getRoll() - (double)(direct * ((Float)this.entityData.get(DELTA_ROT)).floatValue() * (float)(!this.onGround() ? 1 : 0) * 10.0f) * this.getDeltaMovement().horizontalDistance()));
                this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale((double)(((Float)this.entityData.get(POWER)).floatValue() * 1.75f))));
            } else {
                this.setXRot(this.getXRot() * 0.99f);
            }
        }
        this.setZRot(this.roll * 0.85f);
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.BOAT_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return (Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()) - 0.01f) * 2.0f;
    }

    @ParametersAreNonnullByDefault
    protected void positionRider(Entity passenger, Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        int i = this.getOrderedPassengers().indexOf(passenger);
        float y = -0.65f;
        if (i == 0) {
            Vector4f worldPosition = this.transformPosition(transform, 0.0f, y + 0.25f, -0.2f);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 1) {
            Vector4f worldPosition = this.transformPosition(transform, -0.8f, y, -1.2f);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 2) {
            Vector4f worldPosition = this.transformPosition(transform, 0.8f, y, -1.2f);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 3) {
            Vector4f worldPosition = this.transformPosition(transform, -0.8f, y, -2.2f);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        } else if (i == 4) {
            Vector4f worldPosition = this.transformPosition(transform, 0.8f, y, -2.2f);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        }
        if (passenger != this.getFirstPassenger()) {
            passenger.setXRot(passenger.getXRot() + (this.getXRot() - this.xRotO));
        }
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float g = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entity.yRotO += g - f;
        entity.setYRot(entity.getYRot() + g - f);
        entity.setYHeadRot(entity.getYRot());
        entity.setYBodyRot(this.getYRot());
    }

    @Override
    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this.getAttacker(), this.getAttacker()), 80.0f, this.getX(), this.getY(), this.getZ(), 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
        }
        this.explodePassengers();
        super.destroy();
    }

    protected void clampRotation(Entity entity) {
        float a = this.getTurretYaw(1.0f);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -40.0f - r * this.getXRot() - r2 * this.getRoll();
        float max = 20.0f - r * this.getXRot() - r2 * this.getRoll();
        float f = Mth.wrapDegrees((float)entity.getXRot());
        float f1 = Mth.clamp((float)f, (float)min, (float)max);
        entity.xRotO += f1 - f;
        entity.setXRot(entity.getXRot() + f1 - f);
        float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float f3 = Mth.clamp((float)f2, (float)-105.0f, (float)105.0f);
        entity.yRotO += f3 - f2;
        entity.setYRot(entity.getYRot() + f3 - f2);
        entity.setYBodyRot(this.getYRot());
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getBarrelTransform(ticks);
        float x = 0.0f;
        float y = 0.5f;
        float z = -0.25f;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).vectorTo(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.5088375f, 0.04173125f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.lerp((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot());
        float z = Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.XP.rotationDegrees(x + r * xV + r2 * z));
        return transformT;
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.5616626f, -0.565625f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    @Override
    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)(this.yo + (double)0.9f), (double)(this.getY() + (double)0.9f)), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot())));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    private PlayState firePredicate(AnimationState<SpeedboatEntity> event) {
        if ((Integer)this.entityData.get(FIRE_ANIM) > 1) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.speedboat.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.speedboat.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::firePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int getMaxPassengers() {
        return 5;
    }

    @Override
    public int mainGunRpm(Player player) {
        return 500;
    }

    @Override
    public boolean canShoot(Player player) {
        return ((Integer)this.entityData.get(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox(player)) && !this.cannotFire;
    }

    @Override
    public int getAmmoCount(Player player) {
        return (Integer)this.entityData.get(AMMO);
    }

    @Override
    public boolean hidePassenger(Entity entity) {
        return false;
    }

    @Override
    public int zoomFov() {
        return 1;
    }

    @Override
    public int getWeaponHeat(Player player) {
        return (Integer)this.entityData.get(HEAT);
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/speedboat_icon.png");
    }

    @Override
    public Vec3 getGunVec(float ticks) {
        return this.getBarrelVector(ticks);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0 && zoom) {
            return new Vec2((float)(-SpeedboatEntity.getYRotFromVector(this.getBarrelVec(partialTicks))), (float)(-SpeedboatEntity.getXRotFromVector(this.getBarrelVec(partialTicks))));
        }
        return super.getCameraRotation(partialTicks, player, zoom, isFirstPerson);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0 && zoom) {
            return new Vec3(this.driverZoomPos((float)partialTicks).x, this.driverZoomPos((float)partialTicks).y, this.driverZoomPos((float)partialTicks).z);
        }
        return super.getCameraPosition(partialTicks, player, zoom, isFirstPerson);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return this.getSeatIndex(entity) == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return Pair.of((Object)Axis.XP.rotationDegrees(-this.getViewXRot(tickDelta)), (Object)Axis.ZP.rotationDegrees(-this.getRoll(tickDelta)));
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/water.png");
    }
}

