/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModCriteriaTriggers;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WheelChairEntity
extends MobileVehicleEntity
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int jumpCoolDown;
    public int handBusyTime;

    public WheelChairEntity(EntityType<WheelChairEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public void playerTouch(Player pPlayer) {
        if (this.position().distanceTo(pPlayer.position()) > 1.4 || pPlayer == this.getFirstPassenger()) {
            return;
        }
        if (!this.level().isClientSide) {
            double entitySize = pPlayer.getBbWidth() * pPlayer.getBbHeight();
            double thisSize = this.getBbWidth() * this.getBbHeight();
            double f = Math.min((double)(entitySize / thisSize), (double)2.0);
            this.setDeltaMovement(this.getDeltaMovement().add(new Vec3(pPlayer.position().vectorTo(this.position()).toVector3f()).scale(0.5 * f * pPlayer.getDeltaMovement().length())));
            this.setYRot(pPlayer.getYHeadRot());
        }
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(0.5 * ClientMouseHandler.custom3pDistanceLerp, 0.0, 0.0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.getDeltaMovement().length() * 0.3), this.random.nextFloat() * 0.15f + 1.0f);
    }

    @Override
    public boolean sendFireStarParticleOnHurt() {
        return false;
    }

    @Override
    public void baseTick() {
        if (this.jumpCoolDown > 0 && this.onGround()) {
            --this.jumpCoolDown;
        }
        if (this.handBusyTime > 0) {
            --this.handBusyTime;
        }
        super.baseTick();
        if (this.onGround()) {
            float f = (float)Mth.clamp((double)(0.85f + 0.05f * Mth.abs((float)(90.0f - (float)WheelChairEntity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f), (double)0.01, (double)0.99);
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.99, (double)f));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        this.setSprinting(this.getDeltaMovement().horizontalDistance() > 0.15);
        this.attractEntity();
        this.terrainCompact(0.9f, 1.2f);
        this.inertiaRotate(10.0f);
        this.refreshDimensions();
    }

    public boolean hasEnoughSpaceFor(Entity pEntity) {
        return pEntity.getBbWidth() < this.getBbWidth();
    }

    public void attractEntity() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, (double)-0.01f, (double)0.2f));
        if (!list.isEmpty()) {
            boolean flag = !this.level().isClientSide && !(this.getControllingPassenger() instanceof Player);
            for (Entity entity : list) {
                if (entity.hasPassenger((Entity)this) || !flag || entity.isPassenger() || !this.hasEnoughSpaceFor(entity) || !(entity instanceof LivingEntity) && !(entity instanceof MortarEntity) || entity instanceof WaterAnimal || entity instanceof Player) continue;
                entity.startRiding((Entity)this);
            }
        }
    }

    @Override
    protected void addPassenger(@NotNull Entity newPassenger) {
        ServerPlayer player;
        super.addPassenger(newPassenger);
        if (newPassenger instanceof ServerPlayer && ((player = (ServerPlayer)newPassenger).getMainHandItem().getItem() == ModItems.ELECTRIC_BATON.get() || player.getOffhandItem().getItem() == ModItems.ELECTRIC_BATON.get())) {
            ModCriteriaTriggers.OTTO_SPRINT.get().trigger(player);
        }
    }

    @Override
    public void travel() {
        Entity passenger = this.getFirstPassenger();
        float diffY = 0.0f;
        if (passenger == null) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
        } else if (passenger instanceof Player) {
            diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.wrapDegrees((float)(passenger.getYHeadRot() - this.getYRot())));
            this.setYRot(this.getYRot() + Mth.clamp((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
            float direct = (90.0f - (float)WheelChairEntity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f))) / 90.0f;
            this.setZRot((float)((double)this.getRoll() + (double)(direct * diffY) * 0.2 * this.getDeltaMovement().length()));
        }
        if (this.forwardInputDown) {
            this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() + (this.sprintInputDown ? 0.02f : 0.01f)));
            if (this.getEnergy() <= 0 && passenger instanceof Player) {
                Player player = (Player)passenger;
                this.moveWithOutPower(player, true);
            }
        }
        if (this.backInputDown) {
            this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() - 0.01f));
            if (this.getEnergy() <= 0 && passenger instanceof Player) {
                Player player = (Player)passenger;
                this.moveWithOutPower(player, false);
            }
        }
        if (this.upInputDown && this.onGround() && this.getEnergy() > 400 && this.jumpCoolDown == 0) {
            if (passenger instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)passenger;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.WHEEL_CHAIR_JUMP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            this.consumeEnergy((Integer)VehicleConfig.WHEELCHAIR_JUMP_ENERGY_COST.get());
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.6, 0.0));
            this.jumpCoolDown = 3;
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy((Integer)VehicleConfig.WHEELCHAIR_MOVE_ENERGY_COST.get());
        }
        if (passenger instanceof Player) {
            LocalPlayer localPlayer;
            Player player = (Player)passenger;
            if (player.level().isClientSide && this.handBusyTime > 0 && (localPlayer = Minecraft.getInstance().player) != null && player.getUUID().equals(localPlayer.getUUID())) {
                localPlayer.handsBusy = true;
            }
        }
        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * 0.87f));
        double s0 = this.getDeltaMovement().dot(this.getViewVector(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.25 * s0) - 0.015f * Mth.clamp((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.25 * s0) + 0.015f * Mth.clamp((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
        float power = ((Float)this.entityData.get(POWER)).floatValue() * Mth.clamp((float)(1.0f + (float)(s0 > 0.0 ? 1 : -1) * this.getXRot() / 35.0f), (float)0.0f, (float)2.0f);
        this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale((this.onGround() ? 1.0 : 0.1) * (double)power)));
    }

    public void moveWithOutPower(Player player, boolean forward) {
        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() + (forward ? 0.015f : -0.015f)));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.BOAT_PADDLE_LAND, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        player.causeFoodExhaustion(0.03f);
        this.handBusyTime = 4;
        this.forwardInputDown = false;
        this.backInputDown = false;
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.WHEEL_CHAIR_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return this.getEnergy() > 0 ? ((Float)this.entityData.get(POWER)).floatValue() : 0.0f;
    }

    protected void clampRotation(Entity entity) {
        entity.setYBodyRot(this.getYRot());
        float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float f3 = Mth.clamp((float)f2, (float)-90.0f, (float)90.0f);
        entity.yRotO += f3 - f2;
        entity.setYRot(entity.getYRot() + f3 - f2);
        entity.setYBodyRot(this.getYRot());
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        int i = this.getSeatIndex(passenger);
        if (i == 0) {
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        }
        if (passenger != this.getFirstPassenger()) {
            passenger.setXRot(passenger.getXRot() + (this.getXRot() - this.xRotO));
        }
    }

    @Override
    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)(this.yo + (double)0.4f), (double)(this.getY() + (double)0.4f)), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot())));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @Override
    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this.getAttacker(), this.getAttacker()), 10.0f, this.getX(), this.getY(), this.getZ(), 2.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnSmallExplosionParticles(this.level(), this.position());
        }
        super.destroy();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/wheel_chair_icon.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return Pair.of((Object)Axis.XP.rotationDegrees(-this.getViewXRot(tickDelta)), (Object)Axis.ZP.rotationDegrees(-this.getRoll(tickDelta)));
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/otto.png");
    }
}

