/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.projectile.AerialBombEntity;
import com.atsuishio.superbwarfare.entity.projectile.CannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SwarmDroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.CannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SwarmDroneWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Yx100Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity {
    public static final EntityDataAccessor<Integer> MG_AMMO = SynchedEntityData.defineId(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> LOADED_AP = SynchedEntityData.defineId(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> LOADED_HE = SynchedEntityData.defineId(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> LOADED_AMMO_TYPE = SynchedEntityData.defineId(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> GUN_FIRE_TIME = SynchedEntityData.defineId(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> LOADED_DRONE = SynchedEntityData.defineId(Yx100Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int droneReloadCoolDown;

    public Yx100Entity(EntityType<Yx100Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.YX_100_AP_CANNON_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.YX_100_AP_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage(((Integer)VehicleConfig.YX_100_AP_CANNON_EXPLOSION_DAMAGE.get()).intValue()).fireProbability(0.0f).fireTime(0).durability(100).velocity(40.0f).gravity(0.1f).sound((SoundEvent)ModSounds.INTO_MISSILE.get()).ammo((Item)ModItems.AP_5_INCHES.get()).icon(Mod.loc("textures/screens/vehicle_weapon/ap_shell.png")).sound1p((SoundEvent)ModSounds.YX_100_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.YX_100_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.YX_100_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.YX_100_VERYFAR.get()), new CannonShellWeapon().hitDamage(((Integer)VehicleConfig.YX_100_HE_CANNON_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.YX_100_HE_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage(((Integer)VehicleConfig.YX_100_HE_CANNON_EXPLOSION_DAMAGE.get()).intValue()).fireProbability(0.18f).fireTime(2).durability(0).velocity(25.0f).gravity(0.1f).sound((SoundEvent)ModSounds.INTO_CANNON.get()).ammo((Item)ModItems.HE_5_INCHES.get()).icon(Mod.loc("textures/screens/vehicle_weapon/he_shell.png")).sound1p((SoundEvent)ModSounds.YX_100_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.YX_100_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.YX_100_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.YX_100_VERYFAR.get()), new ProjectileWeapon().damage(((Integer)VehicleConfig.HEAVY_MACHINE_GUN_DAMAGE.get()).intValue()).headShot(2.0f).zoom(false).bypassArmorRate(0.4f).ammo((Item)ModItems.HEAVY_AMMO.get()).sound((SoundEvent)ModSounds.INTO_CANNON.get()).icon(Mod.loc("textures/screens/vehicle_weapon/gun_12_7mm.png")).sound1p((SoundEvent)ModSounds.M_2_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M_2_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M_2_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M_2_VERYFAR.get())}, {new ProjectileWeapon().damage(((Integer)VehicleConfig.HEAVY_MACHINE_GUN_DAMAGE.get()).intValue()).headShot(2.0f).zoom(false).bypassArmorRate(0.4f).ammo((Item)ModItems.HEAVY_AMMO.get()).icon(Mod.loc("textures/screens/vehicle_weapon/gun_12_7mm.png")).sound1p((SoundEvent)ModSounds.M_2_FIRE_1P.get()).sound3p((SoundEvent)ModSounds.M_2_FIRE_3P.get()).sound3pFar((SoundEvent)ModSounds.M_2_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M_2_VERYFAR.get())}, {new SwarmDroneWeapon().explosionDamage(((Integer)VehicleConfig.YX_100_SWARM_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfig.YX_100_SWARM_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)ModSounds.INTO_MISSILE.get())}};
    }

    @Override
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return switch (index) {
            case 0 -> new ThirdPersonCameraPosition(5.0 + ClientMouseHandler.custom3pDistanceLerp, 1.5, -0.8669625);
            case 1 -> new ThirdPersonCameraPosition(-1.0 + 0.5 * ClientMouseHandler.custom3pDistanceLerp, 0.5, 0.0);
            default -> null;
        };
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MG_AMMO, (Object)0).define(LOADED_AP, (Object)0).define(LOADED_HE, (Object)0).define(LOADED_DRONE, (Object)0).define(LOADED_AMMO_TYPE, (Object)0).define(GUN_FIRE_TIME, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("LoadedAP", ((Integer)this.entityData.get(LOADED_AP)).intValue());
        compound.putInt("LoadedHE", ((Integer)this.entityData.get(LOADED_HE)).intValue());
        compound.putInt("LoadedDrone", ((Integer)this.entityData.get(LOADED_DRONE)).intValue());
        compound.putInt("LoadedAmmoType", ((Integer)this.entityData.get(LOADED_AMMO_TYPE)).intValue());
        compound.putInt("WeaponType", this.getWeaponIndex(0));
        compound.putInt("PassengerWeaponType", this.getWeaponIndex(1));
        compound.putInt("ThirdPassengerWeaponType", this.getWeaponIndex(2));
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(LOADED_AP, (Object)compound.getInt("LoadedAP"));
        this.entityData.set(LOADED_HE, (Object)compound.getInt("LoadedHE"));
        this.entityData.set(LOADED_DRONE, (Object)compound.getInt("LoadedDrone"));
        this.entityData.set(LOADED_AMMO_TYPE, (Object)compound.getInt("LoadedAmmoType"));
        this.setWeaponIndex(0, compound.getInt("WeaponType"));
        this.setWeaponIndex(1, compound.getInt("PassengerWeaponType"));
        this.setWeaponIndex(2, compound.getInt("ThirdPassengerWeaponType"));
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.5f) * damage.floatValue())).custom((source, damage) -> {
            if (source.getDirectEntity() instanceof AerialBombEntity) {
                return Float.valueOf(3.0f * damage.floatValue());
            }
            return damage;
        });
    }

    protected void playStepSound(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.playSound((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.getDeltaMovement().length() * 0.15), this.random.nextFloat() * 0.15f + 1.05f);
    }

    @Override
    public void baseTick() {
        Entity entity;
        super.baseTick();
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(80.0f);
        }
        if (this.getLeftTrack() > 80.0f) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(80.0f);
        }
        if (this.getRightTrack() > 80.0f) {
            this.setRightTrack(0.0f);
        }
        if ((Integer)this.entityData.get(GUN_FIRE_TIME) > 0) {
            this.entityData.set(GUN_FIRE_TIME, (Object)((Integer)this.entityData.get(GUN_FIRE_TIME) - 1));
        }
        if (this.reloadCoolDown == 70 && (entity = this.getFirstPassenger()) instanceof Player) {
            Player player = (Player)entity;
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.YX_100_RELOAD.get());
        }
        if (this.level() instanceof ServerLevel) {
            boolean hasCreativeAmmo = false;
            for (int i = 0; i < this.getMaxPassengers(); ++i) {
                Player pPlayer;
                Entity entity2 = this.getNthEntity(i);
                if (!(entity2 instanceof Player) || !InventoryTool.hasCreativeAmmoBox(pPlayer = (Player)entity2)) continue;
                hasCreativeAmmo = true;
            }
            if (this.reloadCoolDown > 0 && ((Integer)this.entityData.get(LOADED_AMMO_TYPE) == 0 && (hasCreativeAmmo || this.countItem((Item)ModItems.AP_5_INCHES.get()) > 0) || (Integer)this.entityData.get(LOADED_AMMO_TYPE) == 1 && (hasCreativeAmmo || this.countItem((Item)ModItems.HE_5_INCHES.get()) > 0))) {
                --this.reloadCoolDown;
            }
            if (this.droneReloadCoolDown > 0) {
                --this.droneReloadCoolDown;
            }
            if ((this.hasItem((Item)ModItems.SWARM_DRONE.get()) || hasCreativeAmmo) && this.droneReloadCoolDown == 0 && (Integer)this.getEntityData().get(LOADED_DRONE) < 14) {
                this.entityData.set(LOADED_DRONE, (Object)((Integer)this.getEntityData().get(LOADED_DRONE) + 1));
                this.droneReloadCoolDown = 20;
                if (!hasCreativeAmmo) {
                    this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.SWARM_DRONE.get())).findFirst().ifPresent(stack -> stack.shrink(1));
                }
                this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.MISSILE_RELOAD.get(), this.getSoundSource(), 1.0f, 1.0f);
            }
            this.handleAmmo();
        }
        if (this.onGround()) {
            float f0 = 0.54f + 0.25f * Mth.abs((float)(90.0f - (float)Yx100Entity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f;
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).normalize().scale(0.05 * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f0, 0.99, (double)f0));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        if (this.isInWater()) {
            float f1 = (float)((double)0.7f - (double)0.04f * Math.min((double)this.getSubmergedHeight(this), (double)this.getBbHeight()) + (double)(0.08f * Mth.abs((float)(90.0f - (float)Yx100Entity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f)))) / 90.0f));
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).normalize().scale(0.04 * this.getDeltaMovement().dot(this.getViewVector(1.0f)))));
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f1, 0.85, (double)f1));
        }
        if ((entity = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            if (this.isInWater() && this.getDeltaMovement().length() > 0.1) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, this.getX() + 0.5 * this.getDeltaMovement().x, this.getY() + this.getSubmergedHeight(this) - 0.2, this.getZ() + 0.5 * this.getDeltaMovement().z, (int)(2.0 + 4.0 * this.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, this.getX() + 0.5 * this.getDeltaMovement().x, this.getY() + this.getSubmergedHeight(this) - 0.2, this.getZ() + 0.5 * this.getDeltaMovement().z, (int)(2.0 + 10.0 * this.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
            }
        }
        this.collideBlock();
        if (this.getDeltaMovement().length() > 0.075) {
            this.collideHardBlock();
        }
        this.turretAngle(5.0f, 5.0f);
        this.gunnerAngle(15.0f, 15.0f);
        this.lowHealthWarning();
        this.terrainCompact(4.375f, 6.3125f);
        this.inertiaRotate(1.2f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.refreshDimensions();
    }

    @Override
    public void terrainCompact(float w, float l) {
        if (this.onGround()) {
            float x1 = this.terrainCompactTrackValue(w, l)[0];
            float x2 = this.terrainCompactTrackValue(w, l - 1.0f)[0];
            float x3 = this.terrainCompactTrackValue(w, l - 2.0f)[0];
            float x4 = this.terrainCompactTrackValue(w, l - 3.0f)[0];
            float x5 = this.terrainCompactTrackValue(w, l - 4.0f)[0];
            float x6 = this.terrainCompactTrackValue(w, l - 5.0f)[0];
            float x7 = this.terrainCompactTrackValue(w, l - 6.0f)[0];
            List<Float> numbersX = Arrays.asList(Float.valueOf(x1), Float.valueOf(x2), Float.valueOf(x3), Float.valueOf(x4), Float.valueOf(x5), Float.valueOf(x6), Float.valueOf(x7));
            float maxX = Collections.max(numbersX).floatValue();
            float minX = Collections.min(numbersX).floatValue();
            float z1 = this.terrainCompactTrackValue(w, l)[1];
            float z2 = this.terrainCompactTrackValue(w, l - 1.0f)[1];
            float z3 = this.terrainCompactTrackValue(w, l - 2.0f)[1];
            float z4 = this.terrainCompactTrackValue(w, l - 3.0f)[1];
            float z5 = this.terrainCompactTrackValue(w, l - 4.0f)[1];
            float z6 = this.terrainCompactTrackValue(w, l - 5.0f)[1];
            float z7 = this.terrainCompactTrackValue(w, l - 6.0f)[1];
            List<Float> numbersZ = Arrays.asList(Float.valueOf(z1), Float.valueOf(z2), Float.valueOf(z3), Float.valueOf(z4), Float.valueOf(z5), Float.valueOf(z6), Float.valueOf(z7));
            float maxZ = Collections.max(numbersZ).floatValue();
            float minZ = Collections.min(numbersZ).floatValue();
            float diffX = Math.clamp((float)-15.0f, (float)15.0f, (float)((minX + maxX) / 2.0f));
            this.setXRot(Mth.clamp((float)(this.getXRot() + 0.15f * diffX), (float)-45.0f, (float)45.0f));
            float diffZ = Math.clamp((float)-15.0f, (float)15.0f, (float)(minZ + maxZ));
            this.setZRot(Mth.clamp((float)(this.getRoll() + 0.15f * diffZ), (float)-45.0f, (float)45.0f));
        } else if (this.isInWater()) {
            this.setXRot(this.getXRot() * 0.9f);
            this.setZRot(this.getRoll() * 0.9f);
        }
    }

    @Override
    public boolean canCollideHardBlock() {
        return this.getDeltaMovement().horizontalDistance() > 0.05 || (double)Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()) > 0.1;
    }

    @Override
    public boolean canCollideBlockBeastly() {
        return this.getDeltaMovement().horizontalDistance() > 0.3;
    }

    private void handleAmmo() {
        if (this.getWeaponIndex(0) == 0 || this.getWeaponIndex(0) == 1) {
            this.entityData.set(LOADED_AMMO_TYPE, (Object)this.getWeaponIndex(0));
        }
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox(pPlayer = (Player)entity)) continue;
            hasCreativeAmmo = true;
        }
        if (hasCreativeAmmo) {
            this.entityData.set(AMMO, (Object)9999);
            this.entityData.set(MG_AMMO, (Object)9999);
        } else {
            this.entityData.set(AMMO, (Object)this.countItem(this.getWeapon((int)0).ammo));
            this.entityData.set(MG_AMMO, (Object)this.countItem(this.getWeapon((int)1).ammo));
        }
        if (((Integer)this.getEntityData().get(LOADED_AP) == 0 || (Integer)this.getEntityData().get(LOADED_HE) == 0) && this.reloadCoolDown <= 0 && (hasCreativeAmmo || this.hasItem(this.getWeapon((int)0).ammo))) {
            if ((Integer)this.entityData.get(LOADED_AMMO_TYPE) == 0 && (Integer)this.entityData.get(LOADED_AP) == 0) {
                this.entityData.set(LOADED_AP, (Object)1);
                if (!hasCreativeAmmo) {
                    this.consumeItem((Item)ModItems.AP_5_INCHES.get(), 1);
                }
            }
            if ((Integer)this.entityData.get(LOADED_AMMO_TYPE) == 1 && (Integer)this.entityData.get(LOADED_HE) == 0) {
                this.entityData.set(LOADED_HE, (Object)1);
                if (!hasCreativeAmmo) {
                    this.consumeItem((Item)ModItems.HE_5_INCHES.get(), 1);
                }
            }
        }
    }

    @Override
    public void move(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.move(movementType, movement);
        if (this.isInWater() && this.horizontalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.07, 0.0));
        }
    }

    @Override
    public void vehicleShoot(Player player, int type) {
        ServerPlayer serverPlayer;
        Vec3 center;
        Level level;
        Vector4f worldPosition;
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox(pPlayer = (Player)entity)) continue;
            hasCreativeAmmo = true;
        }
        if (type == 0) {
            if (this.reloadCoolDown == 0 && (this.getWeaponIndex(0) == 0 || this.getWeaponIndex(0) == 1)) {
                if (!this.canConsume((Integer)VehicleConfig.YX_100_SHOOT_COST.get())) {
                    player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.annihilator.energy_not_enough").withStyle(ChatFormatting.RED), true);
                    return;
                }
                Matrix4f transform = this.getBarrelTransform(1.0f);
                worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
                CannonShellWeapon cannonShell = (CannonShellWeapon)this.getWeapon(0);
                CannonShellEntity entityToSpawn = cannonShell.create(player);
                entityToSpawn.setPos((double)worldPosition.x - 1.1 * this.getDeltaMovement().x, worldPosition.y, (double)worldPosition.z - 1.1 * this.getDeltaMovement().z);
                entityToSpawn.shoot(this.getBarrelVector((float)1.0f).x, this.getBarrelVector((float)1.0f).y + (double)0.005f, this.getBarrelVector((float)1.0f).z, cannonShell.velocity, 0.02f);
                this.level().addFreshEntity((Entity)entityToSpawn);
                if (!player.level().isClientSide) {
                    this.playShootSound3p(player, 0, 8, 16, 32);
                }
                this.entityData.set(CANNON_RECOIL_TIME, (Object)40);
                if (this.getWeaponIndex(0) == 0) {
                    this.entityData.set(LOADED_AP, (Object)0);
                } else if (this.getWeaponIndex(0) == 1) {
                    this.entityData.set(LOADED_HE, (Object)0);
                }
                this.consumeEnergy(10000);
                this.entityData.set(YAW, (Object)Float.valueOf(this.getTurretYRot()));
                this.reloadCoolDown = 80;
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level2;
                    server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX() + 5.0 * this.getBarrelVector((float)1.0f).x, this.getY() + 0.1, this.getZ() + 5.0 * this.getBarrelVector((float)1.0f).z, 300, 6.0, 0.02, 6.0, 0.005);
                    double x = (double)worldPosition.x + 9.0 * this.getBarrelVector((float)1.0f).x;
                    double y = (double)worldPosition.y + 9.0 * this.getBarrelVector((float)1.0f).y;
                    double z = (double)worldPosition.z + 9.0 * this.getBarrelVector((float)1.0f).z;
                    server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
                    server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 10, 0.4, 0.4, 0.4, 0.0075);
                    int count = 6;
                    for (float i = 9.5f; i < 23.0f; i += 0.5f) {
                        server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)worldPosition.x + (double)i * this.getBarrelVector((float)1.0f).x, (double)worldPosition.y + (double)i * this.getBarrelVector((float)1.0f).y, (double)worldPosition.z + (double)i * this.getBarrelVector((float)1.0f).z, Mth.clamp((int)count--, (int)1, (int)5), 0.15, 0.15, 0.15, 0.0025);
                    }
                    Vector4f worldPositionL = this.transformPosition(transform, -0.35f, 0.0f, 0.0f);
                    Vector4f worldPositionR = this.transformPosition(transform, 0.35f, 0.0f, 0.0f);
                    for (float i = 3.0f; i < 6.0f; i += 0.5f) {
                        server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)worldPositionL.x + (double)i * this.getBarrelVector((float)1.0f).x, (double)worldPositionL.y + (double)i * this.getBarrelVector((float)1.0f).y, (double)worldPositionL.z + (double)i * this.getBarrelVector((float)1.0f).z, 1, 0.025, 0.025, 0.025, 0.0015);
                        server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)worldPositionR.x + (double)i * this.getBarrelVector((float)1.0f).x, (double)worldPositionR.y + (double)i * this.getBarrelVector((float)1.0f).y, (double)worldPositionR.z + (double)i * this.getBarrelVector((float)1.0f).z, 1, 0.025, 0.025, 0.025, 0.0015);
                    }
                }
                level = player.level();
                center = new Vec3(this.getX(), this.getEyeY(), this.getZ());
                for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(8.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                    if (!(target instanceof ServerPlayer)) continue;
                    serverPlayer = (ServerPlayer)target;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(10.0, 8.0, 60.0, this.getX(), this.getEyeY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else if (this.getWeaponIndex(0) == 2) {
                if (this.cannotFireCoax) {
                    return;
                }
                Matrix4f transform = this.getBarrelTransform(1.0f);
                worldPosition = this.transformPosition(transform, -0.12f, 0.15f, 2.0f);
                if ((Integer)this.entityData.get(MG_AMMO) > 0 || hasCreativeAmmo) {
                    ProjectileEntity projectileRight = ((ProjectileWeapon)this.getWeapon(0)).create((LivingEntity)player).setGunItemId(this.getType().getDescriptionId() + ".1");
                    projectileRight.setPos((double)worldPosition.x - 1.1 * this.getDeltaMovement().x, worldPosition.y, (double)worldPosition.z - 1.1 * this.getDeltaMovement().z);
                    projectileRight.shoot(player, this.getBarrelVector((float)1.0f).x, this.getBarrelVector((float)1.0f).y + (double)0.005f, this.getBarrelVector((float)1.0f).z, 36.0f, 0.25f);
                    this.level().addFreshEntity((Entity)projectileRight);
                    if (!hasCreativeAmmo) {
                        ItemStack ammoBox = this.getItemStacks().stream().filter(stack -> {
                            if (stack.is((Item)ModItems.AMMO_BOX.get())) {
                                return Ammo.HEAVY.get((ItemStack)stack) > 0;
                            }
                            return false;
                        }).findFirst().orElse(ItemStack.EMPTY);
                        if (!ammoBox.isEmpty()) {
                            Ammo.HEAVY.add(ammoBox, -1);
                        } else {
                            this.getItemStacks().stream().filter(stack -> stack.is((Item)ModItems.HEAVY_AMMO.get())).findFirst().ifPresent(stack -> stack.shrink(1));
                        }
                    }
                }
                this.entityData.set(COAX_HEAT, (Object)((Integer)this.entityData.get(COAX_HEAT) + 4));
                this.entityData.set(FIRE_ANIM, (Object)2);
                if (!player.level().isClientSide) {
                    this.playShootSound3p(player, 0, 4, 12, 24);
                }
            }
        }
        if (type == 1) {
            if (this.cannotFire) {
                return;
            }
            Matrix4f transform = this.getGunTransform(1.0f);
            worldPosition = this.transformPosition(transform, 0.0f, -0.25f, 0.0f);
            ProjectileWeapon projectile = (ProjectileWeapon)this.getWeapon(1);
            ProjectileEntity projectileEntity = projectile.create((LivingEntity)player).setGunItemId(this.getType().getDescriptionId() + ".2");
            projectileEntity.setPos((double)worldPosition.x - 1.1 * this.getDeltaMovement().x, worldPosition.y, (double)worldPosition.z - 1.1 * this.getDeltaMovement().z);
            projectileEntity.shoot(this.getGunnerVector((float)1.0f).x, this.getGunnerVector((float)1.0f).y + (double)0.01f, this.getGunnerVector((float)1.0f).z, 20.0f, 0.3f);
            this.level().addFreshEntity((Entity)projectileEntity);
            if (!player.level().isClientSide) {
                this.playShootSound3p(player, 1, 4, 12, 24);
            }
            this.entityData.set(GUN_FIRE_TIME, (Object)2);
            this.entityData.set(HEAT, (Object)((Integer)this.entityData.get(HEAT) + 4));
            level = player.level();
            center = new Vec3(this.getX(), this.getEyeY(), this.getZ());
            for (Entity target : level.getEntitiesOfClass(Entity.class, new AABB(center, center).inflate(4.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(center))).toList()) {
                if (!(target instanceof ServerPlayer)) continue;
                serverPlayer = (ServerPlayer)target;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(6.0, 4.0, 6.0, this.getX(), this.getEyeY(), this.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (hasCreativeAmmo) {
                return;
            }
            ItemStack ammoBox = this.getItemStacks().stream().filter(stack -> {
                if (stack.is((Item)ModItems.AMMO_BOX.get())) {
                    return Ammo.HEAVY.get((ItemStack)stack) > 0;
                }
                return false;
            }).findFirst().orElse(ItemStack.EMPTY);
            if (!ammoBox.isEmpty()) {
                Ammo.HEAVY.add(ammoBox, -1);
            } else {
                this.consumeItem(this.getWeapon((int)1).ammo, 1);
            }
        }
        if (type == 2) {
            SwarmDroneEntity swarmDrone;
            Matrix4f transformT = this.getTurretTransform(1.0f);
            worldPosition = new Vector4f();
            int ammo = (Integer)this.getEntityData().get(LOADED_DRONE);
            if (ammo == 1) {
                worldPosition = this.transformPosition(transformT, -1.6290874f, 0.75536877f, -1.7661687f);
            }
            if (ammo == 2) {
                worldPosition = this.transformPosition(transformT, 1.6290874f, 0.75536877f, -1.7661687f);
            }
            if (ammo == 3) {
                worldPosition = this.transformPosition(transformT, -1.7822125f, 0.75536877f, -1.9193f);
            }
            if (ammo == 4) {
                worldPosition = this.transformPosition(transformT, 1.7822125f, 0.75536877f, -1.9193f);
            }
            if (ammo == 5) {
                worldPosition = this.transformPosition(transformT, -1.6290874f, 0.75536877f, -2.0724187f);
            }
            if (ammo == 6) {
                worldPosition = this.transformPosition(transformT, 1.6290874f, 0.75536877f, -2.0724187f);
            }
            if (ammo == 7) {
                worldPosition = this.transformPosition(transformT, -1.7822125f, 0.75536877f, -2.22555f);
            }
            if (ammo == 8) {
                worldPosition = this.transformPosition(transformT, 1.7822125f, 0.75536877f, -2.22555f);
            }
            if (ammo == 9) {
                worldPosition = this.transformPosition(transformT, -1.6290874f, 0.75536877f, -2.3786688f);
            }
            if (ammo == 10) {
                worldPosition = this.transformPosition(transformT, 1.6290874f, 0.75536877f, -2.3786688f);
            }
            if (ammo == 11) {
                worldPosition = this.transformPosition(transformT, -1.7822125f, 0.75536877f, -2.5318f);
            }
            if (ammo == 12) {
                worldPosition = this.transformPosition(transformT, 1.7822125f, 0.75536877f, -2.5318f);
            }
            if (ammo == 13) {
                worldPosition = this.transformPosition(transformT, -1.6290874f, 0.75536877f, -2.6849186f);
            }
            if (ammo == 14) {
                worldPosition = this.transformPosition(transformT, 1.6290874f, 0.75536877f, -2.6849186f);
            }
            Vec3 lookVec = player.getViewVector(1.0f);
            Entity lookingEntity = SeekTool.seekLivingEntity((Entity)player, this.level(), 384.0, 6.0);
            SwarmDroneEntity swarmDroneEntity = ((SwarmDroneWeapon)this.getWeapon(2)).create((LivingEntity)player);
            Vector4f shootPosition1 = this.transformPosition(transformT, 0.0f, 0.0f, 0.0f);
            Vector4f shootPosition2 = this.transformPosition(transformT, 0.0f, 1.0f, 0.0f);
            Vec3 direct = new Vec3((double)shootPosition1.x, (double)shootPosition1.y, (double)shootPosition1.z).vectorTo(new Vec3((double)shootPosition2.x, (double)shootPosition2.y, (double)shootPosition2.z));
            swarmDroneEntity.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
            swarmDroneEntity.shoot(direct.x, direct.y, direct.z, 1.2f, 10.0f);
            if (!(lookingEntity == null || lookingEntity instanceof SwarmDroneEntity && (swarmDrone = (SwarmDroneEntity)lookingEntity).getOwner() == player)) {
                swarmDroneEntity.setGuideType(0);
                swarmDroneEntity.setTargetUuid(lookingEntity.getStringUUID());
                swarmDroneEntity.setTargetVec(lookingEntity.getEyePosition());
            } else {
                swarmDroneEntity.setGuideType(1);
                BlockHitResult result = this.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(lookVec.scale(384.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
                Vec3 hitPos = result.getLocation();
                swarmDroneEntity.setTargetVec(hitPos);
            }
            player.level().addFreshEntity((Entity)swarmDroneEntity);
            this.level().playSound(null, BlockPos.containing((Position)new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z)), (SoundEvent)ModSounds.DECOY_FIRE.get(), SoundSource.PLAYERS, 1.0f, this.random.nextFloat() * 0.05f + 1.0f);
            this.entityData.set(LOADED_DRONE, (Object)((Integer)this.getEntityData().get(LOADED_DRONE) - 1));
            this.droneReloadCoolDown = 100;
        }
    }

    @Override
    public void travel() {
        Entity passenger0 = this.getFirstPassenger();
        if (this.getEnergy() <= 0) {
            return;
        }
        if (!(passenger0 instanceof Player)) {
            this.leftInputDown = false;
            this.rightInputDown = false;
            this.forwardInputDown = false;
            this.backInputDown = false;
            this.entityData.set(POWER, (Object)Float.valueOf(0.0f));
        }
        if (this.forwardInputDown) {
            this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + (((Float)this.entityData.get(POWER)).floatValue() < 0.0f ? 0.004f : 0.0024f)), (float)0.21f)));
        }
        if (this.backInputDown) {
            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - (((Float)this.entityData.get(POWER)).floatValue() > 0.0f ? 0.004f : 0.0024f)), (float)-0.16f)));
            if (this.rightInputDown) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.1f));
            } else if (this.leftInputDown) {
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.1f));
            }
        } else if (this.rightInputDown) {
            this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.1f));
        } else if (this.leftInputDown) {
            this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.1f));
        }
        if (this.forwardInputDown || this.backInputDown) {
            this.consumeEnergy((Integer)VehicleConfig.YX_100_ENERGY_COST.get());
        }
        this.entityData.set(POWER, (Object)Float.valueOf(((Float)this.entityData.get(POWER)).floatValue() * (this.upInputDown ? 0.5f : (this.rightInputDown || this.leftInputDown ? 0.947f : 0.96f))));
        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.76f - (double)0.1f * this.getDeltaMovement().horizontalDistance()), (double)0.3)));
        double s0 = this.getDeltaMovement().dot(this.getViewVector(1.0f));
        this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.25 * s0 + (double)Mth.clamp((float)(0.75f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.25 * s0 - (double)Mth.clamp((float)(0.75f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
        this.setLeftTrack((float)((double)this.getLeftTrack() - 4.71238898038469 * s0 + Mth.clamp((double)(1.2566370801612687 * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setRightTrack((float)((double)this.getRightTrack() - 4.71238898038469 * s0 - Mth.clamp((double)(1.2566370801612687 * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        this.setYRot((float)((double)this.getYRot() - (this.isInWater() && !this.onGround() ? 2.5 : 6.0) * (double)((Float)this.entityData.get(DELTA_ROT)).floatValue()));
        if (this.isInWater() || this.onGround()) {
            float power = ((Float)this.entityData.get(POWER)).floatValue() * Mth.clamp((float)(1.0f + (float)(s0 > 0.0 ? 1 : -1) * this.getXRot() / 35.0f), (float)0.0f, (float)2.0f);
            this.setDeltaMovement(this.getDeltaMovement().add(this.getViewVector(1.0f).scale((double)((!this.isInWater() && !this.onGround() ? 0.13f : (this.isInWater() && !this.onGround() ? 2.0f : 2.4f)) * power))));
        }
    }

    @Override
    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.YX_100_ENGINE.get();
    }

    @Override
    public float getEngineSoundVolume() {
        return Math.max((float)Mth.abs((float)((Float)this.entityData.get(POWER)).floatValue()), (float)Mth.abs((float)(0.1f * ((Float)this.entityData.get(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void positionRider(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.hasPassenger(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        int i = this.getOrderedPassengers().indexOf(passenger);
        Vector4f worldPosition = switch (i) {
            case 0 -> this.transformPosition(transform, 0.6669625f, 0.07f, 0.4776875f);
            case 1 -> this.transformPosition(transform, -0.7580562f, 0.3f, -0.57275623f);
            case 2 -> this.transformPosition(transform, 0.86219376f, 0.07f, -0.5696875f);
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
        passenger.setPos((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.accept(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.setYBodyRot(this.getBarrelYRot(1.0f));
        }
    }

    @Override
    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.0f, 0.6076875f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    @Override
    public int getMaxPassengers() {
        return 3;
    }

    @Override
    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).vectorTo(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).vectorTo(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getGunnerVector(float pPartialTicks) {
        Matrix4f transform = this.getGunnerBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).vectorTo(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.56345f, 0.6477125f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.lerp((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot());
        float z = Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.XP.rotationDegrees(x + r * xV + r2 * z));
        return transformT;
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 2.1059375f, -0.43125f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    public Matrix4f getGunTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, -0.7580562f, 1.1446375f, -0.57275623f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformT.rotate((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)ticks, (float)this.gunYRotO, (float)this.getGunYRot()) - Mth.lerp((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformT;
    }

    public Matrix4f getGunnerBarrelTransform(float ticks) {
        Matrix4f transformG = this.getGunTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.35984376f, 0.0551625f);
        transformG.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.lerp((float)ticks, (float)this.gunXRotO, (float)this.getGunXRot());
        float xV = Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot());
        float z = Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformG.rotate((Quaternionfc)Axis.XP.rotationDegrees(x + r * xV + r2 * z));
        return transformG;
    }

    @Override
    public void destroy() {
        if (this.level() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.level(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this.getAttacker(), this.getAttacker()), 80.0f, this.getX(), this.getY(), this.getZ(), 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.0f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)this.level(), (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnMediumExplosionParticles(this.level(), this.position());
        }
        this.explodePassengers();
        super.destroy();
    }

    protected void clampRotation(Entity entity) {
        Minecraft mc = Minecraft.getInstance();
        if (entity.level().isClientSide && entity == this.getFirstPassenger()) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -30.0f - r * this.getXRot() - r2 * this.getRoll();
            float max = 10.0f - r * this.getXRot() - r2 * this.getRoll();
            float f = Mth.wrapDegrees((float)entity.getXRot());
            float f1 = Mth.clamp((float)f, (float)min, (float)max);
            entity.xRotO += f1 - f;
            entity.setXRot(entity.getXRot() + f1 - f);
            if (mc.options.getCameraType() == CameraType.FIRST_PERSON) {
                float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getBarrelYRot(1.0f)));
                float f3 = Mth.clamp((float)f2, (float)-20.0f, (float)20.0f);
                entity.yRotO += f3 - f2;
                entity.setYRot(entity.getYRot() + f3 - f2);
                entity.setYBodyRot(this.getBarrelYRot(1.0f));
            }
        } else if (entity == this.getNthEntity(1)) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -60.0f - r * this.getXRot() - r2 * this.getRoll();
            float max = 10.0f - r * this.getXRot() - r2 * this.getRoll();
            float f = Mth.wrapDegrees((float)entity.getXRot());
            float f1 = Mth.clamp((float)f, (float)min, (float)max);
            entity.xRotO += f1 - f;
            entity.setXRot(entity.getXRot() + f1 - f);
            if (mc.options.getCameraType() == CameraType.FIRST_PERSON) {
                float f2 = Mth.wrapDegrees((float)(entity.getYRot() - this.getGunYRot(1.0f)));
                float f3 = Mth.clamp((float)f2, (float)-150.0f, (float)150.0f);
                entity.yRotO += f3 - f2;
                entity.setYRot(entity.getYRot() + f3 - f2);
                entity.setYBodyRot(entity.getYRot());
            }
        } else if (entity == this.getNthEntity(2)) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -90.0f - r * this.getXRot() - r2 * this.getRoll();
            float max = 22.5f - r * this.getXRot() - r2 * this.getRoll();
            float f = Mth.wrapDegrees((float)entity.getXRot());
            float f1 = Mth.clamp((float)f, (float)min, (float)max);
            entity.xRotO += f1 - f;
            entity.setXRot(entity.getXRot() + f1 - f);
        }
    }

    public void onPassengerTurned(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState cannonShootPredicate(AnimationState<Yx100Entity> event) {
        if ((Integer)this.entityData.get(CANNON_RECOIL_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle"));
    }

    private PlayState coaxShootPredicate(AnimationState<Yx100Entity> event) {
        if ((Integer)this.entityData.get(FIRE_ANIM) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire_coax"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle_coax"));
    }

    private PlayState gunShootPredicate(AnimationState<Yx100Entity> event) {
        if ((Integer)this.entityData.get(GUN_FIRE_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire2"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle2"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "cannon", 0, this::cannonShootPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "coax", 0, this::coaxShootPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "gun", 0, this::gunShootPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public int mainGunRpm(Player player) {
        if (player == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0 || this.getWeaponIndex(0) == 1) {
                return 15;
            }
            if (this.getWeaponIndex(0) == 2) {
                return 500;
            }
        }
        if (player == this.getNthEntity(1)) {
            return 500;
        }
        if (player == this.getNthEntity(2)) {
            return 600;
        }
        return 15;
    }

    @Override
    public boolean canShoot(Player player) {
        if (player == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0) {
                return (Integer)this.entityData.get(LOADED_AP) > 0 && this.getEnergy() > (Integer)VehicleConfig.YX_100_SHOOT_COST.get();
            }
            if (this.getWeaponIndex(0) == 1) {
                return (Integer)this.entityData.get(LOADED_HE) > 0 && this.getEnergy() > (Integer)VehicleConfig.YX_100_SHOOT_COST.get();
            }
            if (this.getWeaponIndex(0) == 2) {
                return ((Integer)this.entityData.get(MG_AMMO) > 0 || InventoryTool.hasCreativeAmmoBox(player)) && !this.cannotFireCoax;
            }
        }
        if (player == this.getNthEntity(1)) {
            return ((Integer)this.entityData.get(MG_AMMO) > 0 || InventoryTool.hasCreativeAmmoBox(player)) && !this.cannotFire;
        }
        if (player == this.getNthEntity(2)) {
            return (Integer)this.entityData.get(LOADED_DRONE) > 0;
        }
        return false;
    }

    @Override
    public int getAmmoCount(Player player) {
        if (player == this.getNthEntity(0)) {
            if (this.getWeaponIndex(0) == 0) {
                return (Integer)this.entityData.get(LOADED_AP);
            }
            if (this.getWeaponIndex(0) == 1) {
                return (Integer)this.entityData.get(LOADED_HE);
            }
            if (this.getWeaponIndex(0) == 2) {
                return (Integer)this.entityData.get(MG_AMMO);
            }
        }
        if (player == this.getNthEntity(1)) {
            return (Integer)this.entityData.get(MG_AMMO);
        }
        if (player == this.getNthEntity(2)) {
            return (Integer)this.entityData.get(LOADED_DRONE);
        }
        return 0;
    }

    @Override
    public boolean banHand(Player player) {
        if (player == this.getNthEntity(0) || player == this.getNthEntity(1)) {
            return true;
        }
        return player == this.getNthEntity(2) && !player.isShiftKeyDown();
    }

    @Override
    public boolean hidePassenger(Entity entity) {
        return entity == this.getNthEntity(0) || entity == this.getNthEntity(1);
    }

    @Override
    public int zoomFov() {
        return 3;
    }

    @Override
    public boolean hasTracks() {
        return true;
    }

    @Override
    public int getWeaponHeat(Player player) {
        if (player == this.getNthEntity(0)) {
            return (Integer)this.entityData.get(COAX_HEAT);
        }
        if (player == this.getNthEntity(1)) {
            return (Integer)this.entityData.get(HEAT);
        }
        return 0;
    }

    @Override
    public void changeWeapon(int index, int value, boolean isScroll) {
        int typeIndex;
        if (index != 0) {
            return;
        }
        List weapons = this.getAvailableWeapons(index);
        if (weapons.isEmpty()) {
            return;
        }
        int count = weapons.size();
        int n = typeIndex = isScroll ? (value + this.getWeaponIndex(index) + count) % count : value;
        if (typeIndex == 0 || typeIndex == 1) {
            Player player;
            Entity entity;
            if ((Integer)this.entityData.get(LOADED_AP) > 0 && typeIndex == 1) {
                entity = this.getFirstPassenger();
                if (entity instanceof Player && !InventoryTool.hasCreativeAmmoBox(player = (Player)entity)) {
                    this.insertItem((Item)ModItems.AP_5_INCHES.get(), 1);
                }
                this.entityData.set(LOADED_AP, (Object)0);
            }
            if ((Integer)this.entityData.get(LOADED_HE) > 0 && typeIndex == 0) {
                entity = this.getFirstPassenger();
                if (entity instanceof Player && !InventoryTool.hasCreativeAmmoBox(player = (Player)entity)) {
                    this.insertItem((Item)ModItems.HE_5_INCHES.get(), 1);
                }
                this.entityData.set(LOADED_HE, (Object)0);
            }
            if (typeIndex != (Integer)this.entityData.get(LOADED_AMMO_TYPE)) {
                this.reloadCoolDown = 80;
            }
            if ((entity = this.getFirstPassenger()) instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(((SoundEvent)ModSounds.YX_100_RELOAD.get()).getLocation(), SoundSource.PLAYERS);
                player.connection.send((Packet)clientboundstopsoundpacket);
            }
        }
        WeaponVehicleEntity.super.changeWeapon(index, value, isScroll);
    }

    @Override
    public Vec3 getGunVec(float ticks) {
        return this.getGunnerVector(ticks);
    }

    @Override
    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/vehicle_icon/yx_100_icon.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.floor((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getWeaponIndex(0) == 0) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/tank_cannon_cross_ap.png"), centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH);
        } else if (this.getWeaponIndex(0) == 1) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/tank_cannon_cross_he.png"), centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH);
        } else if (this.getWeaponIndex(0) == 2) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/lav_gun_cross.png"), centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH);
        } else if (this.getWeaponIndex(0) == 3) {
            RenderHelper.preciseBlit(guiGraphics, Mod.loc("textures/screens/land/lav_missile_cross.png"), centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH);
        }
        if (this.getWeaponIndex(0) == 0) {
            guiGraphics.drawString(font, (Component)Component.literal((String)("AP SHELL  " + this.getAmmoCount(player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : (Serializable)this.getEntityData().get(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, 0x66FF00, false);
        } else if (this.getWeaponIndex(0) == 1) {
            guiGraphics.drawString(font, (Component)Component.literal((String)("HE SHELL  " + this.getAmmoCount(player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : (Serializable)this.getEntityData().get(AMMO)))), screenWidth / 2 - 33, screenHeight - 65, 0x66FF00, false);
        } else if (this.getWeaponIndex(0) == 2) {
            double heat = 1.0f - (float)((Integer)this.getEntityData().get(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.drawString(font, (Component)Component.literal((String)(" 12.7MM HMG " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.hsvToRgb((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        if (this.getWeaponIndex(0) == 0) {
            guiGraphics.drawString(font, (Component)Component.literal((String)("AP SHELL " + this.getAmmoCount(player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : (Serializable)this.getEntityData().get(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 1) {
            guiGraphics.drawString(font, (Component)Component.literal((String)("HE SHELL " + this.getAmmoCount(player) + " " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : (Serializable)this.getEntityData().get(AMMO)))), 30, -9, -1, false);
        } else if (this.getWeaponIndex(0) == 2) {
            double heat2 = (float)((Integer)this.getEntityData().get(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.drawString(font, (Component)Component.literal((String)("12.7MM HMG " + String.valueOf(InventoryTool.hasCreativeAmmoBox(player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.hsvToRgb((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        }
    }

    @Override
    public boolean hasDecoy() {
        return true;
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        if (seatIndex == 0) {
            return zoom ? 0.17 : 0.22;
        }
        if (seatIndex == 1) {
            return zoom ? 0.25 : 0.35;
        }
        return original;
    }

    @Override
    public boolean isEnclosed(int index) {
        return index != 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-Yx100Entity.getYRotFromVector(this.getBarrelVec(partialTicks))), (float)(-Yx100Entity.getXRotFromVector(this.getBarrelVec(partialTicks))));
            }
            if (this.getSeatIndex((Entity)player) == 1) {
                return new Vec2((float)(-Yx100Entity.getYRotFromVector(this.getGunnerVector(partialTicks))), (float)(-Yx100Entity.getXRotFromVector(this.getGunnerVector(partialTicks))));
            }
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).x, this.driverZoomPos((float)partialTicks).y, this.driverZoomPos((float)partialTicks).z);
                }
                return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()));
            }
            if (this.getSeatIndex((Entity)player) == 1) {
                return new Vec3(Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()), Mth.lerp((double)partialTicks, (double)(player.yo + (double)player.getEyeHeight()), (double)player.getEyeY()), Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()));
            }
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Override
    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc("textures/gui/vehicle/type/land.png");
    }
}

