/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.Comparator;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface AutoAimable {
    default public Entity seekNearLivingEntity(Entity attacker, Vec3 pos, double minAngle, double maxAngle, double minRange, double seekRange, double size) {
        for (Entity target : attacker.level().getEntitiesOfClass(Entity.class, new AABB(pos, pos).inflate(seekRange), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(pos))).toList()) {
            LivingEntity living;
            Player player;
            boolean condition = target.distanceToSqr(attacker) > minRange * minRange && target.distanceToSqr(attacker) <= seekRange * seekRange && AutoAimable.canAim(pos, target, minAngle, maxAngle) && (!(target instanceof Player) || !(player = (Player)target).isSpectator() && !player.isCreative()) && (target instanceof LivingEntity && (living = (LivingEntity)target) instanceof Enemy && living.getHealth() > 0.0f || this.isThreateningEntity(attacker, target, size, pos) || this.basicEnemyFilter(target)) && SeekTool.smokeFilter(target);
            if (!condition) continue;
            return target;
        }
        return null;
    }

    default public boolean isThreateningEntity(Entity attacker, Entity target, double size, Vec3 pos) {
        if (target instanceof SmallCannonShellEntity) {
            return false;
        }
        if (!target.onGround() && target instanceof Projectile) {
            Projectile projectile = (Projectile)target;
            if (((double)target.getBbWidth() >= size || (double)target.getBbHeight() >= size) && VectorTool.calculateAngle(target.getDeltaMovement().normalize(), target.position().vectorTo(attacker.position()).normalize()) < 30.0) {
                return this.checkNoClip(attacker, target, pos) && this.basicEnemyProjectileFilter(projectile);
            }
        }
        return false;
    }

    default public boolean checkNoClip(Entity attacker, Entity target, Vec3 pos) {
        return attacker.level().clip(new ClipContext(pos, target.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, attacker)).getType() != HitResult.Type.BLOCK;
    }

    public boolean basicEnemyFilter(Entity var1);

    public boolean basicEnemyProjectileFilter(Projectile var1);

    public static boolean canAim(Vec3 pos, Entity target, double minAngle, double maxAngle) {
        Vec3 targetPos = new Vec3(target.getX(), target.getY() + (double)(target.getBbHeight() / 2.0f), target.getZ());
        Vec3 toVec = pos.vectorTo(targetPos).normalize();
        double targetAngle = VehicleEntity.getXRotFromVector(toVec);
        return minAngle < targetAngle && targetAngle < maxAngle;
    }
}

