/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.menu.VehicleMenu;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;

public abstract class ContainerMobileVehicleEntity
extends MobileVehicleEntity
implements HasCustomInventoryScreen,
ContainerEntity {
    public static final int CONTAINER_SIZE = 102;
    private final NonNullList<ItemStack> items = NonNullList.withSize((int)102, (Object)ItemStack.EMPTY);

    public ContainerMobileVehicleEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ContainerHelper.saveAllItems((CompoundTag)compound, this.getItemStacks(), (HolderLookup.Provider)this.level().registryAccess());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        ContainerHelper.loadAllItems((CompoundTag)compound, this.getItemStacks(), (HolderLookup.Provider)this.level().registryAccess());
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        if (player.getVehicle() == this) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getMainHandItem();
        if (player.isShiftKeyDown() && !stack.is((Item)ModItems.CROWBAR.get())) {
            player.openMenu((MenuProvider)this);
            return !player.level().isClientSide ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public void remove(@NotNull Entity.RemovalReason pReason) {
        if (!this.level().isClientSide && pReason != Entity.RemovalReason.DISCARDED) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(pReason);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        for (ItemStack stack : this.getItemStacks()) {
            int stored;
            int neededEnergy = this.getMaxEnergy() - this.getEnergy();
            if (neededEnergy <= 0) break;
            IEnergyStorage energyCap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyCap == null || (stored = energyCap.getEnergyStored()) <= 0) continue;
            int energyToExtract = Math.min((int)stored, (int)neededEnergy);
            energyCap.extractEnergy(energyToExtract, false);
            this.setEnergy(this.getEnergy() + energyToExtract);
        }
        this.refreshDimensions();
    }

    public void openCustomInventoryScreen(Player pPlayer) {
        pPlayer.openMenu((MenuProvider)this);
        if (!pPlayer.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)pPlayer);
        }
    }

    public ResourceKey<LootTable> getLootTable() {
        return null;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTable) {
    }

    public long getLootTableSeed() {
        return 0L;
    }

    public void setLootTableSeed(long pLootTableSeed) {
    }

    @NotNull
    public NonNullList<ItemStack> getItemStacks() {
        return this.items;
    }

    public int countItem(@Nullable Item item) {
        if (item == null) {
            return 0;
        }
        return InventoryTool.countItem(this.getItemStacks(), item);
    }

    public boolean hasItem(Item item) {
        return this.countItem(item) > 0;
    }

    public int consumeItem(Item item, int count) {
        return InventoryTool.consumeItem(this.getItemStacks(), item, count);
    }

    public void insertItem(Item item, int count) {
        int rest = InventoryTool.insertItem(this.getItemStacks(), item, count);
        if (rest > 0) {
            ItemStack stackToDrop = new ItemStack((ItemLike)item, rest);
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stackToDrop));
        }
    }

    public void clearItemStacks() {
        this.items.clear();
    }

    public int getContainerSize() {
        return 102;
    }

    @NotNull
    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    @NotNull
    public ItemStack removeItem(int pSlot, int pAmount) {
        return ContainerHelper.removeItem(this.items, (int)pSlot, (int)pAmount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int pSlot) {
        ItemStack itemstack = (ItemStack)this.getItemStacks().get(pSlot);
        if (itemstack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.getItemStacks().set(pSlot, (Object)ItemStack.EMPTY);
        return itemstack;
    }

    public void setItem(int pSlot, @NotNull ItemStack pStack) {
        this.getItemStacks().set(pSlot, (Object)pStack);
        if (!pStack.isEmpty() && pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return !this.isRemoved() && this.position().closerThan((Position)pPlayer.position(), 8.0);
    }

    public void clearContent() {
        this.getItemStacks().clear();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, Player pPlayer) {
        if (pPlayer.isSpectator()) {
            return null;
        }
        return new VehicleMenu(pContainerId, pPlayerInventory, (Container)this);
    }

    public void stopOpen(@NotNull Player pPlayer) {
        this.level().gameEvent((Holder)GameEvent.CONTAINER_CLOSE, this.position(), GameEvent.Context.of((Entity)pPlayer));
    }
}

