/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.projectile.FlareDecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ControllableVehicle;
import com.atsuishio.superbwarfare.entity.vehicle.base.EnergyVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.HelicopterEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class MobileVehicleEntity
extends EnergyVehicleEntity
implements ControllableVehicle {
    public static Consumer<MobileVehicleEntity> trackSound = vehicle -> {};
    public static Consumer<MobileVehicleEntity> engineSound = vehicle -> {};
    public static Consumer<MobileVehicleEntity> swimSound = vehicle -> {};
    public static final EntityDataAccessor<Integer> CANNON_RECOIL_TIME = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Float> POWER = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> YAW = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Integer> FIRE_ANIM = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> COAX_HEAT = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> AMMO = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DECOY_COUNT = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> GEAR_ROT = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Boolean> GEAR_UP = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> PLANE_BREAK = SynchedEntityData.defineId(MobileVehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private Vec3 previousVelocity = Vec3.ZERO;
    public double acceleration;
    public int decoyReloadCoolDown;
    public static boolean IGNORE_ENTITY_GROUND_CHECK_STEPPING = false;
    public boolean leftInputDown;
    public boolean rightInputDown;
    public boolean forwardInputDown;
    public boolean backInputDown;
    public boolean upInputDown;
    public boolean downInputDown;
    public boolean decoyInputDown;
    public boolean fireInputDown;
    public boolean sprintInputDown;
    public double lastTickSpeed;
    public double lastTickVerticalSpeed;
    public int collisionCoolDown;
    private boolean wasEngineRunning = false;
    public float rudderRot;
    public float rudderRotO;
    public float leftWheelRot;
    public float rightWheelRot;
    public float leftWheelRotO;
    public float rightWheelRotO;
    public float leftTrackO;
    public float rightTrackO;
    public float leftTrack;
    public float rightTrack;
    public float rotorRot;
    public float rotorRotO;
    public float propellerRot;
    public float propellerRotO;
    public double recoilShake;
    public double recoilShakeO;
    public boolean cannotFireCoax;
    public int reloadCoolDown;
    public double velocityO;
    public double velocity;
    public float flap1LRot;
    public float flap1LRotO;
    public float flap1RRot;
    public float flap1RRotO;
    public float flap1L2Rot;
    public float flap1L2RotO;
    public float flap1R2Rot;
    public float flap1R2RotO;
    public float flap2LRot;
    public float flap2LRotO;
    public float flap2RRot;
    public float flap2RRotO;
    public float flap3Rot;
    public float flap3RotO;
    public float gearRotO;

    public MobileVehicleEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void processInput(short keys) {
        this.leftInputDown = (keys & 1) > 0;
        this.rightInputDown = (keys & 2) > 0;
        this.forwardInputDown = (keys & 4) > 0;
        this.backInputDown = (keys & 8) > 0;
        this.upInputDown = (keys & 0x10) > 0;
        this.downInputDown = (keys & 0x20) > 0;
        this.decoyInputDown = (keys & 0x40) > 0;
        this.fireInputDown = (keys & 0x80) > 0;
        this.sprintInputDown = (keys & 0x100) > 0;
    }

    public void playerTouch(Player pPlayer) {
        if (pPlayer.isCrouching() && !this.level().isClientSide) {
            double entitySize = pPlayer.getBbWidth() * pPlayer.getBbHeight();
            double thisSize = this.getBbWidth() * this.getBbHeight();
            double f = org.joml.Math.min((double)(entitySize / thisSize), (double)2.0);
            double f1 = org.joml.Math.min((double)(thisSize / entitySize), (double)4.0);
            this.setDeltaMovement(this.getDeltaMovement().add(new Vec3(pPlayer.position().vectorTo(this.position()).toVector3f()).scale(0.15 * f * pPlayer.getDeltaMovement().length())));
            pPlayer.setDeltaMovement(pPlayer.getDeltaMovement().add(new Vec3(this.position().vectorTo(pPlayer.position()).toVector3f()).scale(0.1 * f1 * pPlayer.getDeltaMovement().length())));
        }
    }

    @Override
    public void baseTick() {
        if (!this.wasEngineRunning && this.engineRunning() && this.level().isClientSide()) {
            engineSound.accept(this);
            swimSound.accept(this);
            if (this.hasTracks()) {
                trackSound.accept(this);
            }
        }
        this.wasEngineRunning = this.engineRunning();
        this.turretYRotO = this.getTurretYRot();
        this.turretXRotO = this.getTurretXRot();
        this.gunYRotO = this.getGunYRot();
        this.gunXRotO = this.getGunXRot();
        this.leftWheelRotO = this.getLeftWheelRot();
        this.rightWheelRotO = this.getRightWheelRot();
        this.leftTrackO = this.getLeftTrack();
        this.rightTrackO = this.getRightTrack();
        this.rotorRotO = this.getRotorRot();
        this.rudderRotO = this.getRudderRot();
        this.propellerRotO = this.getPropellerRot();
        this.recoilShakeO = this.getRecoilShake();
        this.velocityO = this.getVelocity();
        this.lastTickSpeed = new Vec3(this.getDeltaMovement().x, this.getDeltaMovement().y + 0.06, this.getDeltaMovement().z).length();
        this.lastTickVerticalSpeed = this.getDeltaMovement().y + 0.06;
        if (this.collisionCoolDown > 0) {
            --this.collisionCoolDown;
        }
        this.flap1LRotO = this.getFlap1LRot();
        this.flap1RRotO = this.getFlap1RRot();
        this.flap1L2RotO = this.getFlap1L2Rot();
        this.flap1R2RotO = this.getFlap1R2Rot();
        this.flap2LRotO = this.getFlap2LRot();
        this.flap2RRotO = this.getFlap2RRot();
        this.flap3RotO = this.getFlap3Rot();
        this.gearRotO = ((Integer)this.entityData.get(GEAR_ROT)).intValue();
        super.baseTick();
        Vec3 currentVelocity = this.getDeltaMovement();
        Vec3 accelerationVec = currentVelocity.subtract(this.previousVelocity).scale(20.0);
        this.acceleration = accelerationVec.length() * 20.0;
        this.previousVelocity = currentVelocity;
        double direct = (90.0 - MobileVehicleEntity.calculateAngle(this.getDeltaMovement(), this.getViewVector(1.0f))) / 90.0;
        this.setVelocity(Mth.lerp((double)0.4, (double)this.getVelocity(), (double)(this.getDeltaMovement().horizontalDistance() * direct * 20.0)));
        float deltaT = Math.abs(this.getTurretYRot() - this.turretYRotO);
        while (this.getTurretYRot() > 180.0f) {
            this.setTurretYRot(this.getTurretYRot() - 360.0f);
            this.turretYRotO = this.getTurretYRot() - deltaT;
        }
        while (this.getTurretYRot() <= -180.0f) {
            this.setTurretYRot(this.getTurretYRot() + 360.0f);
            this.turretYRotO = deltaT + this.getTurretYRot();
        }
        if ((Integer)this.entityData.get(COAX_HEAT) > 0) {
            this.entityData.set(COAX_HEAT, (Object)((Integer)this.entityData.get(COAX_HEAT) - 1));
        }
        if ((Integer)this.entityData.get(FIRE_ANIM) > 0) {
            this.entityData.set(FIRE_ANIM, (Object)((Integer)this.entityData.get(FIRE_ANIM) - 1));
        }
        if ((Integer)this.entityData.get(COAX_HEAT) < 40) {
            this.cannotFireCoax = false;
        }
        if (this.decoyReloadCoolDown > 0) {
            --this.decoyReloadCoolDown;
        }
        if ((Integer)this.entityData.get(COAX_HEAT) > 100) {
            this.cannotFireCoax = true;
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.MINIGUN_OVERHEAT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if ((Integer)this.entityData.get(CANNON_RECOIL_TIME) > 0) {
            this.entityData.set(CANNON_RECOIL_TIME, (Object)((Integer)this.entityData.get(CANNON_RECOIL_TIME) - 1));
        }
        this.setRecoilShake(Math.pow(((Integer)this.entityData.get(CANNON_RECOIL_TIME)).intValue(), 4.0) * 7.0E-7 * Math.sin(0.6283185307179586 * ((double)((Integer)this.entityData.get(CANNON_RECOIL_TIME)).intValue() - 2.5)));
        this.preventStacking();
        this.crushEntities(this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.06, 0.0));
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.baseCollideBlock();
        this.refreshDimensions();
    }

    public void releaseSmokeDecoy(Vec3 vec3) {
        if (this.decoyInputDown) {
            if ((Integer)this.entityData.get(DECOY_COUNT) > 0 && this.level() instanceof ServerLevel) {
                for (int i = 0; i < 8; ++i) {
                    SmokeDecoyEntity smokeDecoyEntity = new SmokeDecoyEntity(this.level());
                    smokeDecoyEntity.setPos(this.getX(), this.getY() + (double)this.getBbHeight(), this.getZ());
                    smokeDecoyEntity.decoyShoot(this, vec3.yRot((-78.75f + 22.5f * (float)i) * ((float)Math.PI / 180)), 4.0f, 8.0f);
                    this.level().addFreshEntity((Entity)smokeDecoyEntity);
                }
                this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.DECOY_FIRE.get(), this.getSoundSource(), 1.0f, 1.0f);
                this.decoyReloadCoolDown = 500;
                this.getEntityData().set(DECOY_COUNT, (Object)((Integer)this.getEntityData().get(DECOY_COUNT) - 1));
            }
            this.decoyInputDown = false;
        }
        if ((Integer)this.entityData.get(DECOY_COUNT) < 1 && this.decoyReloadCoolDown == 0 && this.level() instanceof ServerLevel) {
            this.entityData.set(DECOY_COUNT, (Object)((Integer)this.entityData.get(DECOY_COUNT) + 1));
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.DECOY_RELOAD.get(), this.getSoundSource(), 1.0f, 1.0f);
            this.decoyReloadCoolDown = 500;
        }
    }

    public void releaseDecoy() {
        if (this.decoyInputDown) {
            if ((Integer)this.entityData.get(DECOY_COUNT) > 0 && this.level() instanceof ServerLevel) {
                for (int i = 0; i < 4; ++i) {
                    FlareDecoyEntity flareDecoyEntity = new FlareDecoyEntity(this.level());
                    flareDecoyEntity.setPos(this.getX() + this.getDeltaMovement().x, this.getY() + 0.5 + this.getDeltaMovement().y, this.getZ() + this.getDeltaMovement().z);
                    flareDecoyEntity.decoyShoot(this, this.getViewVector(1.0f).yRot((float)(45 + 90 * i) * ((float)Math.PI / 180)), 0.8f, 8.0f);
                    this.level().addFreshEntity((Entity)flareDecoyEntity);
                }
                this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.DECOY_FIRE.get(), this.getSoundSource(), 2.0f, 1.0f);
                if ((Integer)this.getEntityData().get(DECOY_COUNT) == 4) {
                    this.decoyReloadCoolDown = 300;
                }
                this.getEntityData().set(DECOY_COUNT, (Object)((Integer)this.getEntityData().get(DECOY_COUNT) - 1));
            }
            this.decoyInputDown = false;
        }
        if ((Integer)this.entityData.get(DECOY_COUNT) < 4 && this.decoyReloadCoolDown == 0 && this.level() instanceof ServerLevel) {
            this.entityData.set(DECOY_COUNT, (Object)((Integer)this.entityData.get(DECOY_COUNT) + 1));
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.DECOY_RELOAD.get(), this.getSoundSource(), 1.0f, 1.0f);
            this.decoyReloadCoolDown = 300;
        }
    }

    public void inertiaRotate(float multiple) {
        float angleX = 0.0f;
        float diffX = (float)(this.getAcceleration() * (double)multiple - (double)angleX);
        this.setXRot(this.getXRot() - 0.5f * diffX);
    }

    public static List<Entity> getPlayer(Level level) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> e instanceof Player).toList();
    }

    public void terrainCompact(float w, float l) {
        if (this.onGround()) {
            Matrix4f transform = this.getWheelsTransform(1.0f);
            Vector4f positionLF = this.transformPosition(transform, w / 2.0f, 0.0f, l / 2.0f);
            Vector4f positionRF = this.transformPosition(transform, -w / 2.0f, 0.0f, l / 2.0f);
            Vector4f positionLB = this.transformPosition(transform, w / 2.0f, 0.0f, -l / 2.0f);
            Vector4f positionRB = this.transformPosition(transform, -w / 2.0f, 0.0f, -l / 2.0f);
            Vec3 p1 = new Vec3((double)positionLF.x, (double)positionLF.y, (double)positionLF.z);
            Vec3 p2 = new Vec3((double)positionRF.x, (double)positionRF.y, (double)positionRF.z);
            Vec3 p3 = new Vec3((double)positionLB.x, (double)positionLB.y, (double)positionLB.z);
            Vec3 p4 = new Vec3((double)positionRB.x, (double)positionRB.y, (double)positionRB.z);
            float p1y = (float)this.traceBlockY(p1, 3.0);
            float p2y = (float)this.traceBlockY(p2, 3.0);
            float p3y = (float)this.traceBlockY(p3, 3.0);
            float p4y = (float)this.traceBlockY(p4, 3.0);
            p1 = new Vec3((double)positionLF.x, (double)p1y, (double)positionLF.z);
            p2 = new Vec3((double)positionRF.x, (double)p2y, (double)positionRF.z);
            p3 = new Vec3((double)positionLB.x, (double)p3y, (double)positionLB.z);
            p4 = new Vec3((double)positionRB.x, (double)p4y, (double)positionRB.z);
            Vec3 v0 = p3.vectorTo(p1);
            Vec3 v1 = p4.vectorTo(p2);
            Vec3 v2 = p1.vectorTo(p2);
            Vec3 v3 = p3.vectorTo(p4);
            double x1 = MobileVehicleEntity.getXRotFromVector(v0);
            double x2 = MobileVehicleEntity.getXRotFromVector(v1);
            double z1 = MobileVehicleEntity.getXRotFromVector(v2);
            double z2 = MobileVehicleEntity.getXRotFromVector(v3);
            float diffX = org.joml.Math.clamp((float)-15.0f, (float)15.0f, (float)Mth.wrapDegrees((float)((float)(-(x1 + x2)) - this.getXRot())));
            this.setXRot(Mth.clamp((float)(this.getXRot() + 0.15f * diffX), (float)-45.0f, (float)45.0f));
            float diffZ = org.joml.Math.clamp((float)-15.0f, (float)15.0f, (float)Mth.wrapDegrees((float)((float)(-(z1 + z2)) - this.getRoll())));
            this.setZRot(Mth.clamp((float)(this.getRoll() + 0.15f * diffZ), (float)-45.0f, (float)45.0f));
        } else if (this.isInWater()) {
            this.setXRot(this.getXRot() * 0.9f);
            this.setZRot(this.getRoll() * 0.9f);
        }
    }

    public float[] terrainCompactTrackValue(float w, float l) {
        Matrix4f transform = this.getWheelsTransform(1.0f);
        Vector4f positionLF = this.transformPosition(transform, w / 2.0f, 0.0f, l / 2.0f);
        Vector4f positionRF = this.transformPosition(transform, -w / 2.0f, 0.0f, l / 2.0f);
        Vector4f positionLB = this.transformPosition(transform, w / 2.0f, 0.0f, -l / 2.0f);
        Vector4f positionRB = this.transformPosition(transform, -w / 2.0f, 0.0f, -l / 2.0f);
        Vec3 p1 = new Vec3((double)positionLF.x, (double)positionLF.y, (double)positionLF.z);
        Vec3 p2 = new Vec3((double)positionRF.x, (double)positionRF.y, (double)positionRF.z);
        Vec3 p3 = new Vec3((double)positionLB.x, (double)positionLB.y, (double)positionLB.z);
        Vec3 p4 = new Vec3((double)positionRB.x, (double)positionRB.y, (double)positionRB.z);
        float p1y = (float)this.traceBlockY(p1, 3.0);
        float p2y = (float)this.traceBlockY(p2, 3.0);
        float p3y = (float)this.traceBlockY(p3, 3.0);
        float p4y = (float)this.traceBlockY(p4, 3.0);
        p1 = new Vec3((double)positionLF.x, (double)p1y, (double)positionLF.z);
        p2 = new Vec3((double)positionRF.x, (double)p2y, (double)positionRF.z);
        p3 = new Vec3((double)positionLB.x, (double)p3y, (double)positionLB.z);
        p4 = new Vec3((double)positionRB.x, (double)p4y, (double)positionRB.z);
        Vec3 v0 = p3.vectorTo(p1);
        Vec3 v1 = p4.vectorTo(p2);
        Vec3 v2 = p1.vectorTo(p2);
        Vec3 v3 = p3.vectorTo(p4);
        double x1 = MobileVehicleEntity.getXRotFromVector(v0);
        double x2 = MobileVehicleEntity.getXRotFromVector(v1);
        double z1 = MobileVehicleEntity.getXRotFromVector(v2);
        double z2 = MobileVehicleEntity.getXRotFromVector(v3);
        float x = org.joml.Math.clamp((float)-15.0f, (float)15.0f, (float)Mth.wrapDegrees((float)((float)(-(x1 + x2)) - this.getXRot())));
        float z = org.joml.Math.clamp((float)-15.0f, (float)15.0f, (float)Mth.wrapDegrees((float)((float)(-(z1 + z2)) - this.getRoll())));
        return new float[]{x, z};
    }

    public Matrix4f getWheelsTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)this.yo, (double)this.getY()), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())));
        return transform;
    }

    public double traceBlockY(Vec3 pos, double maxLength) {
        BlockHitResult res = this.level().clip(new ClipContext(pos, pos.add(0.0, -maxLength, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        BlockState state = this.level().getBlockState(BlockPos.containing((Position)pos));
        VoxelShape shape = state.getCollisionShape((BlockGetter)this.level(), BlockPos.containing((Position)pos));
        double targetY = !shape.isEmpty() ? pos.y + shape.max(Direction.Axis.Y) : (res.getType() == HitResult.Type.BLOCK && this.level().noCollision(new AABB(pos, pos)) ? res.getLocation().y : pos.y - maxLength);
        double diffY = targetY - pos.y;
        return pos.y + 0.5 * diffY;
    }

    public void baseCollideBlock() {
        if (this.level() instanceof ServerLevel) {
            AABB aabb = this.getBoundingBox().inflate(0.25, 1.0, 0.25).expandTowards(0.0, 0.5, 1.0).move(this.getDeltaMovement().scale(1.2));
            BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> {
                BlockState blockstate = this.level().getBlockState(pos);
                if (blockstate.is(Blocks.LILY_PAD) || blockstate.is(BlockTags.LEAVES) && blockstate.hasProperty((Property)LeavesBlock.PERSISTENT) && !((Boolean)blockstate.getValue((Property)LeavesBlock.PERSISTENT)).booleanValue() || blockstate.is(Blocks.COBWEB) || blockstate.is(Blocks.CACTUS)) {
                    this.level().destroyBlock(pos, true);
                }
            });
        }
    }

    public void collideBlock() {
        if (!((Boolean)VehicleConfig.COLLISION_DESTROY_BLOCKS.get()).booleanValue()) {
            return;
        }
        AABB aabb = this.getBoundingBox().inflate(0.25, 1.0, 0.25).expandTowards(0.0, 0.5, 1.0).move(this.getDeltaMovement().scale(1.2));
        BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> {
            BlockState blockstate = this.level().getBlockState(pos);
            if (blockstate.is(ModTags.Blocks.SOFT_COLLISION)) {
                this.level().destroyBlock(pos, true);
            }
        });
    }

    public void collideHardBlock() {
        if (!((Boolean)VehicleConfig.COLLISION_DESTROY_HARD_BLOCKS.get()).booleanValue()) {
            return;
        }
        AABB aabb = this.getBoundingBox().inflate(0.25, 1.0, 0.25).expandTowards(0.0, 0.5, 1.0).move(this.getDeltaMovement().scale(1.2));
        BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> {
            BlockState blockstate = this.level().getBlockState(pos);
            if (blockstate.is(ModTags.Blocks.HARD_COLLISION)) {
                this.level().destroyBlock(pos, true);
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95));
            }
        });
    }

    public void collideBlockBeastly() {
        if (!((Boolean)VehicleConfig.COLLISION_DESTROY_BLOCKS_BEASTLY.get()).booleanValue()) {
            return;
        }
        AABB aabb = this.getBoundingBox().inflate(0.25, 1.0, 0.25).expandTowards(0.0, 0.52, 1.0).move(this.getDeltaMovement().scale(1.2));
        BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> {
            BlockState blockstate = this.level().getBlockState(pos);
            float hardness = blockstate.getBlock().defaultDestroyTime();
            if (hardness > 0.0f && hardness <= 4.0f) {
                this.level().destroyBlock(pos, true);
            }
        });
    }

    public boolean canCollideHardBlock() {
        return false;
    }

    public boolean canCollideBlockBeastly() {
        return false;
    }

    public void move(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        if (!this.level().isClientSide()) {
            IGNORE_ENTITY_GROUND_CHECK_STEPPING = true;
        }
        if (this.level() instanceof ServerLevel && this.canCollideBlockBeastly()) {
            this.collideBlockBeastly();
        }
        super.move(movementType, movement);
        if (this.level() instanceof ServerLevel) {
            if (this.horizontalCollision) {
                this.collideBlock();
                if (this.canCollideHardBlock()) {
                    this.collideHardBlock();
                }
            }
            if (this.lastTickSpeed < 0.3 || this.collisionCoolDown > 0 || this instanceof DroneEntity) {
                return;
            }
            Entity driver = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_DRIVER_UUID));
            if (this.verticalCollision) {
                if (this instanceof HelicopterEntity) {
                    this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)(60.0 * ((this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3))));
                    this.bounceVertical(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
                } else if ((double)Mth.abs((float)((float)this.lastTickVerticalSpeed)) > 0.4) {
                    this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)(96.0 * (((double)Mth.abs((float)((float)this.lastTickVerticalSpeed)) - 0.4) * (this.lastTickSpeed - 0.3) * (this.lastTickSpeed - 0.3))));
                    if (!this.level().isClientSide) {
                        this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
                    }
                    this.bounceVertical(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
                }
            }
            if (this.horizontalCollision) {
                this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, driver == null ? this : driver), (float)(126.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
                this.bounceHorizontal(Direction.getNearest((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().y(), (double)this.getDeltaMovement().z()).getOpposite());
                if (!this.level().isClientSide) {
                    this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
                }
                this.collisionCoolDown = 4;
                this.crash = true;
                this.entityData.set(POWER, (Object)Float.valueOf(0.8f * ((Float)this.entityData.get(POWER)).floatValue()));
            }
        }
    }

    public void bounceHorizontal(Direction direction) {
        this.collideBlock();
        this.collideHardBlock();
        switch (direction.getAxis()) {
            case X: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.8, 0.99, 0.99));
                break;
            }
            case Z: {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.99, 0.99, 0.8));
            }
        }
    }

    public void bounceVertical(Direction direction) {
        if (!this.level().isClientSide) {
            this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
        this.collisionCoolDown = 4;
        this.crash = true;
        if (direction.getAxis() == Direction.Axis.Y) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.9, -0.8, 0.9));
        }
    }

    public void preventStacking() {
        AABB Box = this.getBoundingBox();
        List<Entity> entities = this.level().getEntities(EntityTypeTest.forClass(Entity.class), Box, entity -> entity != this && entity != this.getFirstPassenger() && entity.getVehicle() == null).stream().filter(entity -> entity instanceof VehicleEntity).toList();
        for (Entity entity2 : entities) {
            Vec3 toVec = this.position().add(new Vec3(1.0, 1.0, 1.0).scale((double)(this.random.nextFloat() * 0.01f + 1.0f))).vectorTo(entity2.position());
            Vec3 velAdd = toVec.normalize().scale(org.joml.Math.max((double)((double)(this.getBbWidth() + 2.0f) - this.position().distanceTo(entity2.position())), (double)0.0) * 0.002);
            double entitySize = entity2.getBbWidth() * entity2.getBbHeight();
            double thisSize = this.getBbWidth() * this.getBbHeight();
            double f = org.joml.Math.min((double)(entitySize / thisSize), (double)2.0);
            double f1 = org.joml.Math.min((double)(thisSize / entitySize), (double)2.0);
            this.pushNew(-f * velAdd.x, -f * velAdd.y, -f * velAdd.z);
            entity2.push(f1 * velAdd.x, f1 * velAdd.y, f1 * velAdd.z);
        }
    }

    public void pushNew(double pX, double pY, double pZ) {
        this.setDeltaMovement(this.getDeltaMovement().add(pX, pY, pZ));
    }

    public void crushEntities(Vec3 velocity) {
        if (this.level() instanceof ServerLevel) {
            if (!this.canCrushEntities()) {
                return;
            }
            if (velocity.horizontalDistance() < 0.25) {
                return;
            }
            if (this.isRemoved()) {
                return;
            }
            AABB frontBox = this.getBoundingBox().move(velocity);
            List<Entity> entities = this.level().getEntities(EntityTypeTest.forClass(Entity.class), frontBox, entity -> entity != this && entity != this.getFirstPassenger() && entity.getVehicle() == null).stream().filter(entity -> {
                if (entity.isAlive()) {
                    Player player;
                    LivingEntity living;
                    ResourceLocation type = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
                    return entity instanceof VehicleEntity || entity instanceof Boat || entity instanceof Minecart || entity instanceof LivingEntity && (!((living = (LivingEntity)entity) instanceof Player) || !(player = (Player)living).isSpectator()) || ((List)VehicleConfig.COLLISION_ENTITY_WHITELIST.get()).contains(type.toString());
                }
                return false;
            }).toList();
            for (Entity entity2 : entities) {
                double f1;
                double f;
                double entitySize = entity2.getBoundingBox().getSize();
                double thisSize = this.getBoundingBox().getSize();
                if (entity2 instanceof VehicleEntity) {
                    VehicleEntity vehicle = (VehicleEntity)entity2;
                    f = Mth.clamp((double)(vehicle.getMass() / this.getMass()), (double)0.25, (double)4.0);
                    f1 = Mth.clamp((double)(this.getMass() / vehicle.getMass()), (double)0.25, (double)4.0);
                } else {
                    f = Mth.clamp((double)(entitySize / thisSize), (double)0.25, (double)4.0);
                    f1 = Mth.clamp((double)(thisSize / entitySize), (double)0.25, (double)4.0);
                }
                float v = (float)velocity.dot(this.position().vectorTo(entity2.position()));
                Vec3 velAdd = this.position().vectorTo(entity2.position()).normalize().scale(0.1 * (double)v);
                if ((double)Mth.abs((float)v) > 0.3) {
                    if (!this.level().isClientSide) {
                        this.level().playSound(null, (Entity)this, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), this.getSoundSource(), 1.0f, 1.0f);
                    }
                    if (entity2 instanceof LivingEntity) {
                        entity2.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, this.getFirstPassenger() == null ? this : this.getFirstPassenger()), (float)(f1 * 5.0 * ((double)Mth.abs((float)v) - 0.3) * ((double)Mth.abs((float)v) - 0.3)));
                    } else {
                        entity2.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, this.getFirstPassenger() == null ? this : this.getFirstPassenger()), (float)(f1 * 2.0 * ((double)Mth.abs((float)v) - 0.3) * ((double)Mth.abs((float)v) - 0.3)));
                    }
                    if (entity2 instanceof VehicleEntity) {
                        this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), entity2, entity2.getFirstPassenger() == null ? entity2 : entity2.getFirstPassenger()), (float)(f * ((double)Mth.abs((float)v) - 0.3) * ((double)Mth.abs((float)v) - 0.3)));
                    }
                    if (!(entity2 instanceof TargetEntity)) {
                        this.pushNew((double)-0.3f * f * velAdd.x, (double)-0.3f * f * velAdd.y, (double)-0.3f * f * velAdd.z);
                    }
                    if (entity2 instanceof MobileVehicleEntity) {
                        MobileVehicleEntity mobileVehicle = (MobileVehicleEntity)entity2;
                        mobileVehicle.pushNew(f1 * velAdd.x, f1 * velAdd.y, f1 * velAdd.z);
                        continue;
                    }
                    entity2.push(f1 * velAdd.x, f1 * velAdd.y, f1 * velAdd.z);
                    continue;
                }
                entity2.push(0.3 * f1 * velAdd.x, 0.3 * f1 * velAdd.y, 0.3 * f1 * velAdd.z);
            }
        }
    }

    public Vector3f getForwardDirection() {
        return new Vector3f(Mth.sin((float)(-this.getYRot() * ((float)Math.PI / 180))), 0.0f, Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))).normalize();
    }

    public Vector3f getRightDirection() {
        return new Vector3f(Mth.cos((float)(-this.getYRot() * ((float)Math.PI / 180))), 0.0f, Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180)))).normalize();
    }

    public SoundEvent getEngineSound() {
        return SoundEvents.EMPTY;
    }

    public float getEngineSoundVolume() {
        return (float)Mth.lerp((double)Mth.clamp((double)this.getDeltaMovement().length(), (double)0.0, (double)0.5), (double)0.0, (double)0.7f);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double pV) {
        this.velocity = pV;
    }

    public double getAcceleration() {
        return this.getVelocity() - this.velocityO;
    }

    public float getRudderRot() {
        return this.rudderRot;
    }

    public void setRudderRot(float pRudderRot) {
        this.rudderRot = pRudderRot;
    }

    public float getLeftWheelRot() {
        return this.leftWheelRot;
    }

    public void setLeftWheelRot(float pLeftWheelRot) {
        this.leftWheelRot = pLeftWheelRot;
    }

    public float getRightWheelRot() {
        return this.rightWheelRot;
    }

    public void setRightWheelRot(float pRightWheelRot) {
        this.rightWheelRot = pRightWheelRot;
    }

    public float getLeftTrack() {
        return this.leftTrack;
    }

    public void setLeftTrack(float pLeftTrack) {
        this.leftTrack = pLeftTrack;
    }

    public float getRightTrack() {
        return this.rightTrack;
    }

    public void setRightTrack(float pRightTrack) {
        this.rightTrack = pRightTrack;
    }

    public float getRotorRot() {
        return this.rotorRot;
    }

    public void setRotorRot(float pRotorRot) {
        this.rotorRot = pRotorRot;
    }

    public float getPropellerRot() {
        return this.propellerRot;
    }

    public void setPropellerRot(float pPropellerRot) {
        this.propellerRot = pPropellerRot;
    }

    public double getRecoilShake() {
        return this.recoilShake;
    }

    public void setRecoilShake(double pRecoilShake) {
        this.recoilShake = pRecoilShake;
    }

    public float getFlap1LRot() {
        return this.flap1LRot;
    }

    public void setFlap1L2Rot(float pFlap1L2Rot) {
        this.flap1L2Rot = pFlap1L2Rot;
    }

    public float getFlap1R2Rot() {
        return this.flap1R2Rot;
    }

    public void setFlap1R2Rot(float pFlap1R2Rot) {
        this.flap1R2Rot = pFlap1R2Rot;
    }

    public float getFlap1L2Rot() {
        return this.flap1L2Rot;
    }

    public void setFlap1LRot(float pFlap1LRot) {
        this.flap1LRot = pFlap1LRot;
    }

    public float getFlap1RRot() {
        return this.flap1RRot;
    }

    public void setFlap1RRot(float pFlap1RRot) {
        this.flap1RRot = pFlap1RRot;
    }

    public float getFlap2LRot() {
        return this.flap2LRot;
    }

    public void setFlap2LRot(float pFlap2LRot) {
        this.flap2LRot = pFlap2LRot;
    }

    public float getFlap2RRot() {
        return this.flap2RRot;
    }

    public void setFlap2RRot(float pFlap2RRot) {
        this.flap2RRot = pFlap2RRot;
    }

    public float getFlap3Rot() {
        return this.flap3Rot;
    }

    public void setFlap3Rot(float pFlap3Rot) {
        this.flap3Rot = pFlap3Rot;
    }

    public boolean hasDecoy() {
        return false;
    }

    public boolean engineRunning() {
        return org.joml.Math.abs((float)((Float)this.entityData.get(POWER)).floatValue()) > 0.0f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CANNON_RECOIL_TIME, (Object)0).define(POWER, (Object)Float.valueOf(0.0f)).define(YAW, (Object)Float.valueOf(0.0f)).define(AMMO, (Object)0).define(FIRE_ANIM, (Object)0).define(COAX_HEAT, (Object)0).define(DECOY_COUNT, (Object)0).define(GEAR_ROT, (Object)0).define(GEAR_UP, (Object)false).define(PLANE_BREAK, (Object)Float.valueOf(0.0f));
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(POWER, (Object)Float.valueOf(compound.getFloat("Power")));
        this.entityData.set(DECOY_COUNT, (Object)compound.getInt("DecoyCount"));
        this.entityData.set(GEAR_ROT, (Object)compound.getInt("GearRot"));
        this.entityData.set(GEAR_UP, (Object)compound.getBoolean("GearUp"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Power", ((Float)this.entityData.get(POWER)).floatValue());
        compound.putInt("DecoyCount", ((Integer)this.entityData.get(DECOY_COUNT)).intValue());
        compound.putInt("GearRot", ((Integer)this.entityData.get(GEAR_ROT)).intValue());
        compound.putBoolean("GearUp", ((Boolean)this.entityData.get(GEAR_UP)).booleanValue());
    }

    public boolean hasTracks() {
        return false;
    }

    public boolean canCrushEntities() {
        return true;
    }
}

