/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.ContainerBlockItem;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public abstract class VehicleEntity
extends Entity {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<String> LAST_ATTACKER_UUID = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> LAST_DRIVER_UUID = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Float> DELTA_ROT = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> MOUSE_SPEED_X = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> MOUSE_SPEED_Y = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<List<Integer>> SELECTED_WEAPON = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.INT_LIST_SERIALIZER.get()));
    public static final EntityDataAccessor<Integer> HEAT = SynchedEntityData.defineId(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public VehicleWeapon[][] availableWeapons;
    protected int interpolationSteps;
    protected double x;
    protected double y;
    protected double z;
    protected double serverYRot;
    protected double serverXRot;
    public float roll;
    public float prevRoll;
    public int lastHurtTick;
    public int repairCoolDown = this.maxRepairCoolDown();
    public boolean crash;
    public float turretYRot;
    public float turretXRot;
    public float turretYRotO;
    public float turretXRotO;
    public float turretYRotLock;
    public float gunYRot;
    public float gunXRot;
    public float gunYRotO;
    public float gunXRotO;
    public boolean cannotFire;
    private final List<Entity> orderedPassengers = this.generatePassengersList();
    public Function<Entity, Integer> entityIndexOverride = null;

    public void mouseInput(double x, double y) {
        this.entityData.set(MOUSE_SPEED_X, (Object)Float.valueOf((float)x));
        this.entityData.set(MOUSE_SPEED_Y, (Object)Float.valueOf((float)y));
    }

    private ArrayList<Entity> generatePassengersList() {
        ArrayList<Entity> list = new ArrayList<Entity>(this.getMaxPassengers());
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            list.add(null);
        }
        return list;
    }

    public List<Entity> getOrderedPassengers() {
        return this.orderedPassengers;
    }

    protected void addPassenger(@NotNull Entity newPassenger) {
        int index;
        if (newPassenger.getVehicle() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.entityIndexOverride != null && this.entityIndexOverride.apply(newPassenger) != -1) {
            index = this.entityIndexOverride.apply(newPassenger);
        } else {
            index = 0;
            for (Entity passenger : this.orderedPassengers) {
                if (passenger == null) break;
                ++index;
            }
        }
        if (index >= this.getMaxPassengers() || index < 0) {
            return;
        }
        this.orderedPassengers.set(index, newPassenger);
        this.passengers = ImmutableList.copyOf(this.orderedPassengers.stream().filter(Objects::nonNull).toList());
        this.gameEvent((Holder)GameEvent.ENTITY_MOUNT, newPassenger);
    }

    protected void removePassenger(@NotNull Entity pPassenger) {
        if (pPassenger.getVehicle() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        int index = this.getSeatIndex(pPassenger);
        if (index == -1) {
            return;
        }
        this.orderedPassengers.set(index, null);
        this.passengers = ImmutableList.copyOf(this.orderedPassengers.stream().filter(Objects::nonNull).toList());
        pPassenger.boardingCooldown = 60;
        this.gameEvent((Holder)GameEvent.ENTITY_DISMOUNT, pPassenger);
    }

    public VehicleData data() {
        return VehicleData.from(this);
    }

    public float maxUpStep() {
        return this.data().upStep();
    }

    @Nullable
    public Entity getFirstPassenger() {
        return this.orderedPassengers.getFirst();
    }

    public Entity getNthEntity(int index) {
        return this.orderedPassengers.get(index);
    }

    public boolean changeSeat(Entity entity, int index) {
        Level level;
        if (index < 0 || index >= this.getMaxPassengers()) {
            return false;
        }
        if (this.orderedPassengers.get(index) != null) {
            return false;
        }
        if (!this.orderedPassengers.contains(entity)) {
            return false;
        }
        this.orderedPassengers.set(this.orderedPassengers.indexOf(entity), null);
        this.orderedPassengers.set(index, entity);
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getPlayers(s -> true).forEach(p -> p.connection.send((Packet)new ClientboundSetPassengersPacket((Entity)this)));
        }
        return true;
    }

    public int getSeatIndex(Entity entity) {
        return this.orderedPassengers.indexOf(entity);
    }

    @Nullable
    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int seatIndex) {
        return null;
    }

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }

    public float getYaw(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.yRotO, (float)this.getYRot());
    }

    public float getPitch(float tickDelta) {
        return Mth.lerp((float)tickDelta, (float)this.xRotO, (float)this.getXRot());
    }

    public void setZRot(float rot) {
        this.roll = rot;
    }

    public void turretTurnSound(float diffX, float diffY, float pitch) {
        if (this.level().isClientSide && ((double)Math.abs(diffY) > 0.5 || (double)Math.abs(diffX) > 0.5)) {
            this.level().playLocalSound(this.getX(), this.getY() + (double)this.getBbHeight() * 0.5, this.getZ(), (SoundEvent)ModSounds.TURRET_TURN.get(), this.getSoundSource(), (float)Math.min(0.15 * (double)Math.max(Mth.abs((float)diffX), Mth.abs((float)diffY)), 0.75), this.random.nextFloat() * 0.05f + pitch, false);
        }
    }

    public VehicleEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        WeaponVehicleEntity weaponVehicle;
        this.setHealth(this.getMaxHealth());
        VehicleEntity vehicleEntity = this;
        if (vehicleEntity instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)((Object)vehicleEntity)).getAllWeapons().length > 0) {
            this.entityData.set(SELECTED_WEAPON, (Object)IntList.of((int[])this.initSelectedWeaponArray(weaponVehicle)));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(HEALTH, (Object)Float.valueOf(this.getMaxHealth())).define(LAST_ATTACKER_UUID, (Object)"undefined").define(LAST_DRIVER_UUID, (Object)"undefined").define(DELTA_ROT, (Object)Float.valueOf(0.0f)).define(MOUSE_SPEED_X, (Object)Float.valueOf(0.0f)).define(MOUSE_SPEED_Y, (Object)Float.valueOf(0.0f)).define(HEAT, (Object)0).define(SELECTED_WEAPON, (Object)IntList.of((int[])new int[this.getMaxPassengers()]));
    }

    private int[] initSelectedWeaponArray(WeaponVehicleEntity weaponVehicle) {
        weaponVehicle.getAllWeapons();
        int[] selected = new int[this.getMaxPassengers()];
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            selected[i] = weaponVehicle.hasWeapon(i) ? 0 : -1;
        }
        return selected;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        WeaponVehicleEntity weaponVehicle;
        this.entityData.set(LAST_ATTACKER_UUID, (Object)compound.getString("LastAttacker"));
        this.entityData.set(LAST_DRIVER_UUID, (Object)compound.getString("LastDriver"));
        this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        VehicleEntity vehicleEntity = this;
        if (vehicleEntity instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)((Object)vehicleEntity)).getAllWeapons().length > 0) {
            int[] selected = compound.getIntArray("SelectedWeapon");
            if (selected.length != this.getMaxPassengers()) {
                this.entityData.set(SELECTED_WEAPON, (Object)IntList.of((int[])this.initSelectedWeaponArray(weaponVehicle)));
            } else {
                this.entityData.set(SELECTED_WEAPON, (Object)IntList.of((int[])selected));
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        WeaponVehicleEntity weaponVehicle;
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
        compound.putString("LastAttacker", (String)this.entityData.get(LAST_ATTACKER_UUID));
        compound.putString("LastDriver", (String)this.entityData.get(LAST_DRIVER_UUID));
        VehicleEntity vehicleEntity = this;
        if (vehicleEntity instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)((Object)vehicleEntity)).getAllWeapons().length > 0) {
            compound.putIntArray("SelectedWeapon", (List)this.entityData.get(SELECTED_WEAPON));
        }
    }

    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        if (player.getVehicle() == this) {
            return InteractionResult.PASS;
        }
        VehicleData data = this.data();
        ItemStack stack = player.getMainHandItem();
        if (player.isShiftKeyDown() && stack.is((Item)ModItems.CROWBAR.get()) && this.getPassengers().isEmpty()) {
            ItemStack container = ContainerBlockItem.createInstance(this);
            if (!player.addItem(container)) {
                player.drop(container, false);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
            this.discard();
            return InteractionResult.SUCCESS;
        }
        if (this.getHealth() < this.getMaxHealth() && data.canRepairManually() && data.isRepairMaterial(stack)) {
            this.heal(org.joml.Math.min((float)data.repairMaterialHealAmount(), (float)this.getMaxHealth()));
            stack.shrink(1);
            if (!this.level().isClientSide) {
                this.level().playSound(null, (Entity)this, SoundEvents.IRON_GOLEM_REPAIR, this.getSoundSource(), 0.5f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            if (this.getFirstPassenger() == null) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                this.setDriverAngle(player);
                player.setSprinting(false);
                return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            if (!(this.getFirstPassenger() instanceof Player)) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                this.getFirstPassenger().stopRiding();
                this.setDriverAngle(player);
                player.setSprinting(false);
                return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            if (this.canAddPassenger((Entity)player)) {
                if (player instanceof FakePlayer) {
                    return InteractionResult.PASS;
                }
                player.setSprinting(false);
                return player.startRiding((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    public void setDriverAngle(Player player) {
        VehicleEntity vehicleEntity = this;
        if (vehicleEntity instanceof LandArmorEntity) {
            LandArmorEntity landArmorEntity = (LandArmorEntity)((Object)vehicleEntity);
            player.xRotO = -((float)VehicleEntity.getXRotFromVector(landArmorEntity.getBarrelVec(1.0f)));
            player.setXRot(-((float)VehicleEntity.getXRotFromVector(landArmorEntity.getBarrelVec(1.0f))));
            player.yRotO = -((float)VehicleEntity.getYRotFromVector(landArmorEntity.getBarrelVec(1.0f)));
            player.setYRot(-((float)VehicleEntity.getYRotFromVector(landArmorEntity.getBarrelVec(1.0f))));
            player.setYHeadRot(-((float)VehicleEntity.getYRotFromVector(landArmorEntity.getBarrelVec(1.0f))));
        } else {
            player.xRotO = this.getXRot();
            player.setXRot(this.getXRot());
            player.yRotO = this.getYRot();
            player.setYRot(this.getYRot());
        }
    }

    public static double getYRotFromVector(Vec3 vec3) {
        return Mth.atan2((double)vec3.x, (double)vec3.z) * 57.29577951308232;
    }

    public static double getXRotFromVector(Vec3 vec3) {
        double d0 = vec3.horizontalDistance();
        return Mth.atan2((double)vec3.y, (double)d0) * 57.29577951308232;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Level level;
        if (source.is(DamageTypes.CACTUS) || source.is(DamageTypes.SWEET_BERRY_BUSH) || source.is(DamageTypes.IN_WALL)) {
            return false;
        }
        float computedAmount = this.getDamageModifier().compute(source, amount);
        this.crash = source.is(ModDamageTypes.VEHICLE_STRIKE);
        if (source.getEntity() != null) {
            this.entityData.set(LAST_ATTACKER_UUID, (Object)source.getEntity().getStringUUID());
        }
        if (computedAmount > 0.0f) {
            this.lastHurtTick = 0;
            this.repairCoolDown = this.maxRepairCoolDown();
        }
        this.onHurt(computedAmount, source.getEntity(), true);
        if (this.sendFireStarParticleOnHurt() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), this.getX(), this.getY() + 0.5 * (double)this.getBbHeight(), this.getZ(), 2, 0.4, 0.4, 0.4, 0.2, false);
        }
        if (this.playHitSoundOnHurt()) {
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return super.hurt(source, computedAmount);
    }

    public boolean sendFireStarParticleOnHurt() {
        return true;
    }

    public boolean playHitSoundOnHurt() {
        return true;
    }

    public DamageModifier getDamageModifier() {
        return this.data().damageModifier();
    }

    public float getSourceAngle(DamageSource source, float multiply) {
        Entity attacker = source.getDirectEntity();
        if (attacker == null) {
            attacker = source.getEntity();
        }
        if (attacker != null) {
            Vec3 toVec = new Vec3(this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ()).vectorTo(attacker.position()).normalize();
            float angle = (float)Math.abs(VectorTool.calculateAngle(this.position().vectorTo(attacker.position()), this.getViewVector(1.0f)));
            return (float)Math.max(1.0 - (double)multiply * toVec.dot(this.getViewVector(1.0f)), 0.5);
        }
        return 1.0f;
    }

    public void heal(float pHealAmount) {
        if (this.level() instanceof ServerLevel) {
            this.setHealth(this.getHealth() + pHealAmount);
        }
    }

    public void onHurt(float pHealAmount, Entity attacker, boolean send) {
        if (this.level() instanceof ServerLevel) {
            Holder holder = Holder.direct((Object)((SoundEvent)ModSounds.INDICATION_VEHICLE.get()));
            if (attacker instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)attacker;
                if (pHealAmount > 0.0f && this.getHealth() > 0.0f && send && !(this instanceof DroneEntity)) {
                    player.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getEyeY(), player.getZ(), 0.25f + 2.75f * pHealAmount / this.getMaxHealth(), this.random.nextFloat() * 0.1f + 0.9f, player.level().random.nextLong()));
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(3, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (pHealAmount > 0.0f && this.getHealth() > 0.0f && send) {
                List passengers = this.getPassengers();
                for (Entity entity : passengers) {
                    if (!(entity instanceof ServerPlayer)) continue;
                    ServerPlayer player1 = (ServerPlayer)entity;
                    player1.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player1.getX(), player1.getEyeY(), player1.getZ(), 0.25f + 4.75f * pHealAmount / this.getMaxHealth(), this.random.nextFloat() * 0.1f + 0.6f, player1.level().random.nextLong()));
                }
            }
            this.setHealth(this.getHealth() - pHealAmount);
        }
    }

    public float getHealth() {
        return ((Float)this.entityData.get(HEALTH)).floatValue();
    }

    public void setHealth(float pHealth) {
        this.entityData.set(HEALTH, (Object)Float.valueOf(Mth.clamp((float)pHealth, (float)0.0f, (float)this.getMaxHealth())));
    }

    public float getMaxHealth() {
        return this.data().maxHealth();
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPushable() {
        return super.isPushable();
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean skipAttackInteraction(@NotNull Entity attacker) {
        return this.hasPassenger(attacker) || super.skipAttackInteraction(attacker);
    }

    protected boolean canAddPassenger(@NotNull Entity pPassenger) {
        return this.getPassengers().size() < this.getMaxPassengers();
    }

    public int getMaxPassengers() {
        return 1;
    }

    public double getSubmergedHeight(Entity entity) {
        for (Fluid fluid : BuiltInRegistries.FLUID) {
            FluidType type = fluid.getFluidType();
            if (entity.level().getFluidState(entity.blockPosition()).getFluidType() != type) continue;
            return entity.getFluidTypeHeight(type);
        }
        return 0.0;
    }

    public int maxRepairCoolDown() {
        return this.data().repairCooldown();
    }

    public float repairAmount() {
        return this.data().repairAmount();
    }

    public void baseTick() {
        super.baseTick();
        ++this.lastHurtTick;
        if (this.repairCoolDown > 0) {
            --this.repairCoolDown;
        }
        if ((Integer)this.entityData.get(HEAT) > 0) {
            this.entityData.set(HEAT, (Object)((Integer)this.entityData.get(HEAT) - 1));
        }
        if ((Integer)this.entityData.get(HEAT) < 40) {
            this.cannotFire = false;
        }
        if ((Integer)this.entityData.get(HEAT) > 100 && !this.cannotFire) {
            this.cannotFire = true;
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.MINIGUN_OVERHEAT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.prevRoll = this.getRoll();
        float delta = org.joml.Math.abs((float)(this.getYRot() - this.yRotO));
        while (this.getYRot() > 180.0f) {
            this.setYRot(this.getYRot() - 360.0f);
            this.yRotO = this.getYRot() - delta;
        }
        while (this.getYRot() <= -180.0f) {
            this.setYRot(this.getYRot() + 360.0f);
            this.yRotO = delta + this.getYRot();
        }
        float deltaX = org.joml.Math.abs((float)(this.getXRot() - this.xRotO));
        while (this.getXRot() > 180.0f) {
            this.setXRot(this.getXRot() - 360.0f);
            this.xRotO = this.getXRot() - deltaX;
        }
        while (this.getXRot() <= -180.0f) {
            this.setXRot(this.getXRot() + 360.0f);
            this.xRotO = deltaX + this.getXRot();
        }
        float deltaZ = org.joml.Math.abs((float)(this.getRoll() - this.prevRoll));
        while (this.getRoll() > 180.0f) {
            this.setZRot(this.getRoll() - 360.0f);
            this.prevRoll = this.getRoll() - deltaZ;
        }
        while (this.getRoll() <= -180.0f) {
            this.setZRot(this.getRoll() + 360.0f);
            this.prevRoll = deltaZ + this.getRoll();
        }
        this.handleClientSync();
        if (this.level() instanceof ServerLevel && this.getHealth() <= 0.0f) {
            this.destroy();
        }
        this.travel();
        Entity attacker = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_ATTACKER_UUID));
        VehicleData data = this.data();
        if (this.getHealth() <= data.selfHurtPercent() * this.getMaxHealth()) {
            this.onHurt(data.selfHurtAmount(), attacker, false);
        } else if (this.repairCoolDown == 0) {
            this.heal(this.repairAmount());
        }
        if (this.getFirstPassenger() != null) {
            this.entityData.set(LAST_DRIVER_UUID, (Object)this.getFirstPassenger().getStringUUID());
        }
        this.clearArrow();
        this.refreshDimensions();
    }

    public void clearArrow() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.0, 0.5, 0.0));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (!(entity instanceof AbstractArrow)) continue;
                entity.discard();
            }
        }
    }

    public void lowHealthWarning() {
        ServerLevel serverLevel;
        Level level;
        if ((double)this.getHealth() <= 0.4 * (double)this.getMaxHealth() && (level = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            ParticleTool.sendParticle(serverLevel, ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ(), 2, 0.35 * (double)this.getBbWidth(), 0.15 * (double)this.getBbHeight(), 0.35 * (double)this.getBbWidth(), 0.01, true);
        }
        if ((level = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            if ((double)this.getHealth() <= 0.25 * (double)this.getMaxHealth()) {
                this.playLowHealthParticle(serverLevel);
            }
            if ((double)this.getHealth() <= 0.15 * (double)this.getMaxHealth()) {
                this.playLowHealthParticle(serverLevel);
            }
        }
        if ((double)this.getHealth() <= 0.1 * (double)this.getMaxHealth()) {
            level = this.level();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ(), 2, 0.35 * (double)this.getBbWidth(), 0.15 * (double)this.getBbHeight(), 0.35 * (double)this.getBbWidth(), 0.01, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ(), 2, 0.35 * (double)this.getBbWidth(), 0.15 * (double)this.getBbHeight(), 0.35 * (double)this.getBbWidth(), 0.01, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.FLAME, this.getX(), this.getY() + (double)(0.85f * this.getBbHeight()), this.getZ(), 4, 0.35 * (double)this.getBbWidth(), 0.12 * (double)this.getBbHeight(), 0.35 * (double)this.getBbWidth(), 0.05, true);
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), this.getX(), this.getY() + (double)(0.85f * this.getBbHeight()), this.getZ(), 4, 0.1 * (double)this.getBbWidth(), 0.05 * (double)this.getBbHeight(), 0.1 * (double)this.getBbWidth(), 0.4, true);
            }
            if (this.tickCount % 15 == 0) {
                this.level().playSound(null, this.getOnPos(), SoundEvents.FIRE_AMBIENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
        if (this.getHealth() < 0.1f * this.getMaxHealth() && this.tickCount % 13 == 0) {
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.NO_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (this.getHealth() >= 0.1f && this.getHealth() < 0.4f * this.getMaxHealth() && this.tickCount % 10 == 0) {
            this.level().playSound(null, this.getOnPos(), (SoundEvent)ModSounds.LOW_HEALTH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public void playLowHealthParticle(ServerLevel serverLevel) {
        ParticleTool.sendParticle(serverLevel, ParticleTypes.LARGE_SMOKE, this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ(), 1, 0.35 * (double)this.getBbWidth(), 0.15 * (double)this.getBbHeight(), 0.35 * (double)this.getBbWidth(), 0.01, true);
        ParticleTool.sendParticle(serverLevel, ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX(), this.getY() + (double)(0.7f * this.getBbHeight()), this.getZ(), 1, 0.35 * (double)this.getBbWidth(), 0.15 * (double)this.getBbHeight(), 0.35 * (double)this.getBbWidth(), 0.01, true);
    }

    public void turretAngle(float ySpeed, float xSpeed) {
        Entity driver = this.getFirstPassenger();
        if (driver != null) {
            float turretAngle = -Mth.wrapDegrees((float)(driver.getYHeadRot() - this.getYRot()));
            float diffY = Mth.wrapDegrees((float)(turretAngle - this.getTurretYRot()));
            float diffX = Mth.wrapDegrees((float)(driver.getXRot() - this.getTurretXRot()));
            this.turretTurnSound(diffX, diffY, 0.95f);
            float min = -ySpeed + (float)(this.isInWater() && !this.onGround() ? 2.5 : 6.0) * ((Float)this.entityData.get(DELTA_ROT)).floatValue();
            float max = ySpeed + (float)(this.isInWater() && !this.onGround() ? 2.5 : 6.0) * ((Float)this.entityData.get(DELTA_ROT)).floatValue();
            this.setTurretXRot(this.getTurretXRot() + Mth.clamp((float)(0.95f * diffX), (float)(-xSpeed), (float)xSpeed));
            this.setTurretYRot(this.getTurretYRot() + Mth.clamp((float)(0.9f * diffY), (float)min, (float)max));
            this.turretYRotLock = Mth.clamp((float)(0.9f * diffY), (float)min, (float)max);
        } else {
            this.turretYRotLock = 0.0f;
        }
    }

    public void gunnerAngle(float ySpeed, float xSpeed) {
        Entity gunner = this.getNthEntity(1);
        float diffY = 0.0f;
        float diffX = 0.0f;
        float speed = 1.0f;
        if (gunner instanceof Player) {
            float gunAngle = -Mth.wrapDegrees((float)(gunner.getYHeadRot() - this.getYRot()));
            diffY = Mth.wrapDegrees((float)(gunAngle - this.getGunYRot()));
            diffX = Mth.wrapDegrees((float)(gunner.getXRot() - this.getGunXRot()));
            this.turretTurnSound(diffX, diffY, 0.95f);
            speed = 0.0f;
        }
        this.setGunXRot(this.getGunXRot() + Mth.clamp((float)(0.95f * diffX), (float)(-xSpeed), (float)xSpeed));
        this.setGunYRot(this.getGunYRot() + Mth.clamp((float)(0.9f * diffY), (float)(-ySpeed), (float)ySpeed) + speed * this.turretYRotLock);
    }

    public void destroy() {
        this.discard();
    }

    protected Entity getAttacker() {
        return EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_ATTACKER_UUID));
    }

    protected void crashPassengers() {
        for (Entity entity : this.getPassengers()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            Entity tempAttacker = living == this.getAttacker() ? null : this.getAttacker();
            living.hurt(ModDamageTypes.causeAirCrashDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
            living.invulnerableTime = 0;
            living.hurt(ModDamageTypes.causeAirCrashDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
            living.invulnerableTime = 0;
            living.hurt(ModDamageTypes.causeAirCrashDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
            living.invulnerableTime = 0;
            living.hurt(ModDamageTypes.causeAirCrashDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
            living.invulnerableTime = 0;
            living.hurt(ModDamageTypes.causeAirCrashDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
        }
    }

    protected void explodePassengers() {
        for (Entity entity : this.getPassengers()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            Entity tempAttacker = living == this.getAttacker() ? null : this.getAttacker();
            living.hurt(ModDamageTypes.causeVehicleExplosionDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
            living.invulnerableTime = 0;
            living.hurt(ModDamageTypes.causeVehicleExplosionDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
            living.invulnerableTime = 0;
            living.hurt(ModDamageTypes.causeVehicleExplosionDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
            living.invulnerableTime = 0;
            living.hurt(ModDamageTypes.causeVehicleExplosionDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
            living.invulnerableTime = 0;
            living.hurt(ModDamageTypes.causeVehicleExplosionDamage(this.level().registryAccess(), null, tempAttacker), 2.1474836E9f);
        }
    }

    public void travel() {
    }

    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)this.yo, (double)this.getY()), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(Mth.lerp((float)ticks, (float)this.xRotO, (float)this.getXRot())));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    public Matrix4f getVehicleFlatTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.lerp((double)ticks, (double)this.xo, (double)this.getX()), (float)Mth.lerp((double)ticks, (double)this.yo, (double)this.getY()), (float)Mth.lerp((double)ticks, (double)this.zo, (double)this.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)ticks, (float)this.yRotO, (float)this.getYRot())));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    public Vector4f transformPosition(Matrix4f transform, float x, float y, float z) {
        return transform.transform(new Vector4f(x, y, z, 1.0f));
    }

    public void handleClientSync() {
        if (this.isControlledByLocalInstance()) {
            this.interpolationSteps = 0;
            this.syncPacketPositionCodec(this.getX(), this.getY(), this.getZ());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedX = this.getX() + (this.x - this.getX()) / (double)this.interpolationSteps;
        double interpolatedY = this.getY() + (this.y - this.getY()) / (double)this.interpolationSteps;
        double interpolatedZ = this.getZ() + (this.z - this.getZ()) / (double)this.interpolationSteps;
        double interpolatedYaw = Mth.wrapDegrees((double)(this.serverYRot - (double)this.getYRot()));
        this.setYRot(this.getYRot() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.setXRot(this.getXRot() + (float)(this.serverXRot - (double)this.getXRot()) / (float)this.interpolationSteps);
        this.setPos(interpolatedX, interpolatedY, interpolatedZ);
        this.setRot(this.getYRot(), this.getXRot());
        --this.interpolationSteps;
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.serverYRot = yRot;
        this.serverXRot = xRot;
        this.interpolationSteps = 10;
    }

    public static double calculateAngle(Vec3 move, Vec3 view) {
        move = move.multiply(1.0, 0.0, 1.0).normalize();
        view = view.multiply(1.0, 0.0, 1.0).normalize();
        return VectorTool.calculateAngle(move, view);
    }

    protected Vec3 getDismountOffset(double vehicleWidth, double passengerWidth) {
        double offset = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 1.75;
        float yaw = this.getYRot() + 90.0f;
        float x = -Mth.sin((float)(yaw * ((float)Math.PI / 180)));
        float z = Mth.cos((float)(yaw * ((float)Math.PI / 180)));
        float n = org.joml.Math.max((float)org.joml.Math.abs((float)x), (float)org.joml.Math.abs((float)z));
        return new Vec3((double)x * offset / (double)n, 0.0, (double)z * offset / (double)n);
    }

    @NotNull
    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Vec3 vec3d = this.getDismountOffset(this.getBbWidth() * Mth.SQRT_OF_TWO, passenger.getBbWidth() * Mth.SQRT_OF_TWO);
        double ox = this.getX() - vec3d.x;
        double oz = this.getZ() + vec3d.z;
        BlockPos exitPos = new BlockPos((int)ox, (int)this.getY(), (int)oz);
        BlockPos floorPos = exitPos.below();
        if (!this.level().isWaterAt(floorPos)) {
            double floorHeight;
            ArrayList list = Lists.newArrayList();
            double exitHeight = this.level().getBlockFloorHeight(exitPos);
            if (DismountHelper.isBlockFloorValid((double)exitHeight)) {
                list.add(new Vec3(ox, (double)exitPos.getY() + exitHeight, oz));
            }
            if (DismountHelper.isBlockFloorValid((double)(floorHeight = this.level().getBlockFloorHeight(floorPos)))) {
                list.add(new Vec3(ox, (double)floorPos.getY() + floorHeight, oz));
            }
            for (Pose entityPose : passenger.getDismountPoses()) {
                for (Vec3 vec3d2 : list) {
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (Vec3)vec3d2, (LivingEntity)passenger, (Pose)entityPose)) continue;
                    passenger.setPose(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    public ResourceLocation getVehicleIcon() {
        return Mod.loc("textures/gun_icon/default_icon.png");
    }

    public boolean allowFreeCam() {
        return this.data().allowFreeCam();
    }

    public void push(double pX, double pY, double pZ) {
    }

    public Vec3 getNewEyePos(float pPartialTicks) {
        return this.getEyePosition();
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        return this.calculateViewVector(this.getBarrelXRot(pPartialTicks), this.getBarrelYRot(pPartialTicks));
    }

    public float getBarrelXRot(float pPartialTicks) {
        return Mth.lerp((float)pPartialTicks, (float)(this.turretXRotO - this.xRotO), (float)(this.getTurretXRot() - this.getXRot()));
    }

    public float getBarrelYRot(float pPartialTick) {
        return -Mth.lerp((float)pPartialTick, (float)(this.turretYRotO - this.yRotO), (float)(this.getTurretYRot() - this.getYRot()));
    }

    public Vec3 getGunVector(float pPartialTicks) {
        return this.calculateViewVector(this.getGunXRot(pPartialTicks), this.getGunYRot(pPartialTicks));
    }

    public float getGunXRot(float pPartialTicks) {
        return Mth.lerp((float)pPartialTicks, (float)(this.gunXRotO - this.xRotO), (float)(this.getGunXRot() - this.getXRot()));
    }

    public float getGunYRot(float pPartialTick) {
        return -Mth.lerp((float)pPartialTick, (float)(this.gunYRotO - this.yRotO), (float)(this.getGunYRot() - this.getYRot()));
    }

    public float turretYRotO() {
        return this.turretYRotO;
    }

    public float turretYRot() {
        return this.turretYRot;
    }

    public float turretXRotO() {
        return this.turretXRotO;
    }

    public float turretXRot() {
        return this.turretXRot;
    }

    public Vec3 getBarrelVec(float ticks) {
        return this.getBarrelVector(ticks);
    }

    public Vec3 getGunVec(float ticks) {
        return this.getGunVector(ticks);
    }

    public float getTurretYRot() {
        return this.turretYRot;
    }

    public float getTurretYaw(float pPartialTick) {
        return Mth.lerp((float)pPartialTick, (float)this.turretYRotO, (float)this.getTurretYRot());
    }

    public void setTurretYRot(float pTurretYRot) {
        this.turretYRot = pTurretYRot;
    }

    public float getTurretXRot() {
        return this.turretXRot;
    }

    public void setTurretXRot(float pTurretXRot) {
        this.turretXRot = pTurretXRot;
    }

    public float getTurretPitch(float pPartialTick) {
        return Mth.lerp((float)pPartialTick, (float)this.turretXRotO, (float)this.getTurretXRot());
    }

    public float getGunYRot() {
        return this.gunYRot;
    }

    public void setGunYRot(float pGunYRot) {
        this.gunYRot = pGunYRot;
    }

    public float getGunXRot() {
        return this.gunXRot;
    }

    public void setGunXRot(float pGunXRot) {
        this.gunXRot = pGunXRot;
    }

    public Vec3 driverZoomPos(float ticks) {
        return this.getEyePosition();
    }

    public double getMouseSensitivity() {
        return 0.1;
    }

    public double getMouseSpeedX() {
        return 0.4;
    }

    public double getMouseSpeedY() {
        return 0.4;
    }

    public float getMass() {
        return this.data().mass();
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return original;
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return null;
    }

    public boolean isEnclosed(int index) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        VehicleEntity vehicleEntity = this;
        if (!(vehicleEntity instanceof WeaponVehicleEntity)) {
            return;
        }
        WeaponVehicleEntity weaponVehicle = (WeaponVehicleEntity)((Object)vehicleEntity);
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        float minWH = org.joml.Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.floor((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        ResourceLocation texture = Mod.loc(switch (weaponVehicle.getWeaponIndex(0)) {
            case 0 -> "textures/screens/land/lav_cannon_cross.png";
            case 1 -> "textures/screens/land/lav_gun_cross.png";
            case 2 -> "textures/screens/land/lav_missile_cross.png";
            default -> "";
        });
        if (texture.getPath().isEmpty()) {
            return;
        }
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.preciseBlit(guiGraphics, texture, centerW, centerH, 0.0f, 0.0f, scaledMinWH, scaledMinWH, scaledMinWH, scaledMinWH);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useFixedCameraPos(Entity entity) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return null;
    }
}

