/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.api.event.ReloadEvent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;

@EventBusSubscriber
public class ReloadEventHandler {
    @SubscribeEvent
    public static void onPreReload(ReloadEvent.Pre event) {
        Player player = event.player;
        ItemStack stack = event.stack;
        if (player == null || !(stack.getItem() instanceof GunItem) || player.level().isClientSide) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().preReload(data, instance, (LivingEntity)player);
        }
    }

    @SubscribeEvent
    public static void onPostReload(ReloadEvent.Post event) {
        Player player = event.player;
        ItemStack stack = event.stack;
        if (player == null || !(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (player.level().isClientSide) {
            return;
        }
        GunData data = GunData.from(stack);
        for (Perk.Type type : Perk.Type.values()) {
            PerkInstance instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().postReload(data, instance, (LivingEntity)player);
        }
    }
}

