/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.init;

import com.atsuishio.superbwarfare.api.event.RegisterContainersEvent;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.ArmorPlate;
import com.atsuishio.superbwarfare.item.BatteryItem;
import com.atsuishio.superbwarfare.item.C4Bomb;
import com.atsuishio.superbwarfare.item.ElectricBaton;
import com.atsuishio.superbwarfare.item.SmallContainerBlockItem;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ModTabs {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"superbwarfare");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> GUN_TAB = TABS.register("guns", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"item_group.superbwarfare.guns")).icon(() -> new ItemStack((ItemLike)ModItems.TASER.get())).displayItems((param, output) -> ModItems.GUNS.getEntries().forEach(registryObject -> {
        ItemStack stack = new ItemStack((ItemLike)registryObject.get());
        output.accept(stack);
        ItemStack newStack = stack.copy();
        IEnergyStorage cap = (IEnergyStorage)newStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap != null) {
            cap.receiveEnergy(Integer.MAX_VALUE, false);
            output.accept(newStack);
        }
    })).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> PERK_TAB = TABS.register("perk", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"item_group.superbwarfare.perk")).icon(() -> new ItemStack((ItemLike)ModItems.AP_BULLET.get())).withTabsBefore(new ResourceKey[]{GUN_TAB.getKey()}).displayItems((param, output) -> ModItems.PERKS.getEntries().forEach(registryObject -> output.accept((ItemLike)registryObject.get()))).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> AMMO_TAB = TABS.register("ammo", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"item_group.superbwarfare.ammo")).icon(() -> new ItemStack((ItemLike)ModItems.SHOTGUN_AMMO_BOX.get())).withTabsBefore(new ResourceKey[]{PERK_TAB.getKey()}).displayItems((param, output) -> {
        ModItems.AMMO.getEntries().forEach(registryObject -> {
            if (registryObject.get() != ModItems.POTION_MORTAR_SHELL.get()) {
                output.accept((ItemLike)registryObject.get());
                if (registryObject.get() == ModItems.C4_BOMB.get()) {
                    output.accept(C4Bomb.makeInstance());
                }
            }
        });
        param.holders().lookup(Registries.POTION).ifPresent(potion -> ModTabs.generatePotionEffectTypes(output, (HolderLookup<Potion>)potion, (Item)ModItems.POTION_MORTAR_SHELL.get(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS, param.enabledFeatures()));
    }).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> ITEM_TAB = TABS.register("item", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"item_group.superbwarfare.item")).icon(() -> new ItemStack((ItemLike)ModItems.TARGET_DEPLOYER.get())).displayItems((param, output) -> ModItems.ITEMS.getEntries().forEach(registryObject -> {
        Object patt0$temp;
        output.accept((ItemLike)registryObject.get());
        if (registryObject.get() == ModItems.ARMOR_PLATE.get()) {
            output.accept(ArmorPlate.getInfiniteInstance());
        }
        if ((patt0$temp = registryObject.get()) instanceof BatteryItem) {
            BatteryItem batteryItem = (BatteryItem)patt0$temp;
            output.accept(batteryItem.makeFullEnergyStack());
        }
        if (registryObject.get() == ModItems.ELECTRIC_BATON.get()) {
            output.accept(ElectricBaton.makeFullEnergyStack());
        }
    })).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BLOCK_TAB = TABS.register("block", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"item_group.superbwarfare.block")).icon(() -> new ItemStack((ItemLike)ModItems.SANDBAG.get())).withTabsBefore(new ResourceKey[]{ITEM_TAB.getKey()}).displayItems((param, output) -> ModItems.BLOCKS.getEntries().forEach(registryObject -> {
        if (registryObject.get() == ModItems.CONTAINER.get()) {
            RegisterContainersEvent.containers.forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        } else if (registryObject.get() == ModItems.SMALL_CONTAINER.get()) {
            output.accept((ItemLike)registryObject.get());
            SmallContainerBlockItem.SMALL_CONTAINER_LOOT_TABLES.stream().map(Supplier::get).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
        } else {
            output.accept((ItemLike)registryObject.get());
        }
    })).build());

    @SubscribeEvent
    public static void buildTabContentsVanilla(BuildCreativeModeTabContentsEvent tabData) {
        if (tabData.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            tabData.accept((ItemLike)ModItems.SENPAI_SPAWN_EGG.get());
        }
    }

    private static void generatePotionEffectTypes(CreativeModeTab.Output output, HolderLookup<Potion> potions, Item item, CreativeModeTab.TabVisibility visibility, FeatureFlagSet requiredFeatures) {
        potions.listElements().filter(potion -> ((Potion)potion.value()).isEnabled(requiredFeatures)).map(potion -> PotionContents.createItemStack((Item)item, (Holder)potion)).forEach(itemStack -> output.accept(itemStack, visibility));
    }
}

