/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.ClaymoreEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ClaymoreMine
extends Item {
    public ClaymoreMine() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            ClaymoreEntity entity = new ClaymoreEntity((LivingEntity)player, level);
            entity.moveTo(player.getX(), player.getY() + 1.1, player.getZ(), player.getYRot(), 0.0f);
            entity.setYBodyRot(player.getYRot());
            entity.setYHeadRot(player.getYRot());
            entity.setDeltaMovement(0.5 * player.getLookAngle().x, 0.5 * player.getLookAngle().y, 0.5 * player.getLookAngle().z);
            level.addFreshEntity((Entity)entity);
        }
        player.getCooldowns().addCooldown((Item)this, 20);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public static class ClaymoreDispenseBehavior
    extends DefaultDispenseItemBehavior {
        @ParametersAreNonnullByDefault
        @NotNull
        protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
            ServerLevel level = blockSource.level();
            Position position = DispenserBlock.getDispensePosition((BlockSource)blockSource);
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            ClaymoreEntity claymore = new ClaymoreEntity((EntityType<ClaymoreEntity>)((EntityType)ModEntities.CLAYMORE.get()), (Level)level);
            claymore.setPos(position.x(), position.y(), position.z());
            int pX = direction.getStepX();
            float pY = (float)direction.getStepY() + 0.1f;
            int pZ = direction.getStepZ();
            Vec3 vec3 = new Vec3((double)pX, (double)pY, (double)pZ).normalize().scale(0.05);
            claymore.setDeltaMovement(vec3);
            double d0 = vec3.horizontalDistance();
            claymore.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
            claymore.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
            claymore.yRotO = claymore.getYRot();
            claymore.xRotO = claymore.getXRot();
            level.addFreshEntity((Entity)claymore);
            stack.shrink(1);
            return stack;
        }
    }
}

