/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.projectile.C4Entity;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Defuser
extends Item {
    public Defuser() {
        super(new Item.Properties().durability(8));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (Defuser.findBombInSight(pPlayer) != null) {
            pPlayer.startUsingItem(pUsedHand);
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private static C4Entity findBombInSight(Player player) {
        C4Entity c4Entity;
        Entity target = TraceTool.findLookingEntity((Entity)player, 4.0);
        return target instanceof C4Entity ? (c4Entity = (C4Entity)target) : null;
    }

    @ParametersAreNonnullByDefault
    public void onUseTick(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (!(pLivingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)pLivingEntity;
        C4Entity target = Defuser.findBombInSight(player);
        if (target == null) {
            return;
        }
        int useTick = pStack.getUseDuration((LivingEntity)player) - pRemainingUseDuration;
        if (!pLevel.isClientSide) {
            player.displayClientMessage((Component)Component.literal((String)FormatTool.format1DZZ((double)(100 - useTick) / 20.0, "s")).withStyle(ChatFormatting.GREEN), true);
        }
        if (useTick >= 100) {
            player.stopUsingItem();
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                pStack.hurtAndBreak(1, serverLevel, (LivingEntity)player, p -> {});
            }
            target.defuse();
        }
    }

    @ParametersAreNonnullByDefault
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }
}

