/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.client.tooltip.component.CellImageComponent;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.EnergyStorageItem;
import com.atsuishio.superbwarfare.tiers.ModItemTier;
import com.atsuishio.superbwarfare.tools.NBTTool;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class ElectricBaton
extends SwordItem
implements EnergyStorageItem {
    public static final int MAX_ENERGY = 30000;
    public static final int ENERGY_COST = 2000;
    public static final String TAG_OPEN = "Open";

    public ElectricBaton() {
        super((Tier)ModItemTier.STEEL, new Item.Properties().durability(1114).attributes(SwordItem.createAttributes((Tier)ModItemTier.STEEL, (int)2, (float)-2.5f)));
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.electric_baton").withStyle(ChatFormatting.AQUA));
        if (NBTTool.getTag(stack).getBoolean(TAG_OPEN)) {
            tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.electric_baton.open").withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public int getMaxEnergy() {
        return 30000;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isShiftKeyDown()) {
            CompoundTag tag;
            tag.putBoolean(TAG_OPEN, !(tag = NBTTool.getTag(stack)).getBoolean(TAG_OPEN));
            NBTTool.saveTag(stack, tag);
            player.displayClientMessage((Component)Component.translatable((String)("des.superbwarfare.electric_baton." + (tag.getBoolean(TAG_OPEN) ? "open" : "close"))), true);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        return NBTTool.getTag(stack).getBoolean(TAG_OPEN) || super.isBarVisible(stack);
    }

    public int getBarWidth(@NotNull ItemStack stack) {
        if (NBTTool.getTag(stack).getBoolean(TAG_OPEN)) {
            IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (cap == null) {
                return 0;
            }
            return java.lang.Math.round((float)cap.getEnergyStored() * 13.0f / 30000.0f);
        }
        return super.getBarWidth(stack);
    }

    public int getBarColor(@NotNull ItemStack stack) {
        return NBTTool.getTag(stack).getBoolean(TAG_OPEN) ? 0xFFFF00 : super.getBarColor(stack);
    }

    @ParametersAreNonnullByDefault
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        IEnergyStorage cap;
        attacker.level().playSound(null, target.getOnPos(), (SoundEvent)ModSounds.MELEE_HIT.get(), SoundSource.PLAYERS, 1.0f, (float)((2.0 * Math.random() - 1.0) * (double)0.1f + 1.0));
        if (NBTTool.getTag(stack).getBoolean(TAG_OPEN) && (cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) != null && cap.getEnergyStored() >= 2000) {
            cap.extractEnergy(2000, false);
            if (!target.level().isClientSide) {
                target.addEffect(new MobEffectInstance(ModMobEffects.SHOCK, 30, 2), (Entity)attacker);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new CellImageComponent(pStack));
    }

    public static ItemStack makeFullEnergyStack() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.ELECTRIC_BATON.get());
        IEnergyStorage cap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (cap != null) {
            cap.receiveEnergy(30000, false);
        }
        CompoundTag tag = NBTTool.getTag(stack);
        tag.putBoolean(TAG_OPEN, true);
        NBTTool.saveTag(stack, tag);
        return stack;
    }
}

