/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class Hammer
extends SwordItem {
    public Hammer() {
        super((Tier)Tiers.IRON, new Item.Properties().durability(400).attributes(SwordItem.createAttributes((Tier)Tiers.IRON, (int)9, (float)-3.2f)));
    }

    public boolean hasCraftingRemainingItem(@NotNull ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.setDamageValue(itemstack.getDamageValue() + 1);
        if (stack.getDamageValue() >= stack.getMaxDamage()) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public boolean isRepairable(@NotNull ItemStack itemstack) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        attacker.level().playSound(null, target.getOnPos(), (SoundEvent)ModSounds.MELEE_HIT.get(), SoundSource.PLAYERS, 1.0f, (float)((2.0 * Math.random() - 1.0) * (double)0.1f + 1.0));
        return super.hurtEnemy(stack, target, attacker);
    }

    @SubscribeEvent
    public static void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        ItemStack item = event.getCrafting();
        Container container = event.getInventory();
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (item.is((Item)ModItems.HAMMER.get())) {
            int count = 0;
            for (int i = 0; i < container.getContainerSize(); ++i) {
                if (!container.getItem(i).is((Item)ModItems.HAMMER.get())) continue;
                ++count;
            }
            if (count == 2) {
                container.clearContent();
            }
        }
    }
}

