/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.HandGrenadeEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class HandGrenade
extends Item
implements ProjectileItem {
    public HandGrenade() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.GRENADE_PULL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.SPEAR;
    }

    @ParametersAreNonnullByDefault
    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        Player player;
        int usingTime;
        if (!worldIn.isClientSide && entityLiving instanceof Player && (usingTime = this.getUseDuration(stack, (LivingEntity)(player = (Player)entityLiving)) - timeLeft) > 3) {
            player.getCooldowns().addCooldown(stack.getItem(), 25);
            float power = Math.min((float)usingTime / 10.0f, 1.5f);
            HandGrenadeEntity handGrenade = new HandGrenadeEntity((LivingEntity)player, worldIn, 100 - usingTime);
            handGrenade.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, power, 0.0f);
            worldIn.addFreshEntity((Entity)handGrenade);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.GRENADE_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!pLevel.isClientSide) {
            Player player;
            HandGrenadeEntity handGrenade = new HandGrenadeEntity(pLivingEntity, pLevel, 100);
            CustomExplosion explosion = new CustomExplosion(pLevel, null, ModDamageTypes.causeProjectileBoomDamage(pLevel.registryAccess(), (Entity)handGrenade, (Entity)pLivingEntity), ((Integer)ExplosionConfig.M67_GRENADE_EXPLOSION_DAMAGE.get()).intValue(), pLivingEntity.getX(), pLivingEntity.getY(), pLivingEntity.getZ(), ((Integer)ExplosionConfig.M67_GRENADE_EXPLOSION_RADIUS.get()).intValue(), (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP, true).setDamageMultiplier(1.25f);
            explosion.explode();
            EventHooks.onExplosionStart((Level)pLevel, (Explosion)explosion);
            explosion.finalizeExplosion(false);
            ParticleTool.spawnMediumExplosionParticles(pLevel, pLivingEntity.position());
            if (pLivingEntity instanceof Player) {
                player = (Player)pLivingEntity;
                player.getCooldowns().addCooldown(pStack.getItem(), 25);
            }
            if (pLivingEntity instanceof Player && !(player = (Player)pLivingEntity).isCreative()) {
                pStack.shrink(1);
            }
        }
        return super.finishUsingItem(pStack, pLevel, pLivingEntity);
    }

    @ParametersAreNonnullByDefault
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 100;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new HandGrenadeEntity((EntityType<? extends HandGrenadeEntity>)((EntityType)ModEntities.HAND_GRENADE.get()), pos.x(), pos.y(), pos.z(), level);
    }
}

