/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import org.jetbrains.annotations.NotNull;

public class MortarDeployer
extends Item {
    public MortarDeployer() {
        super(new Item.Properties().rarity(Rarity.RARE));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = pContext.getItemInHand();
        BlockPos clickedPos = pContext.getClickedPos();
        Direction direction = pContext.getClickedFace();
        Player player = pContext.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        BlockState blockstate = level.getBlockState(clickedPos);
        BlockPos pos = blockstate.getCollisionShape((BlockGetter)level, clickedPos).isEmpty() ? clickedPos : clickedPos.relative(direction);
        MortarEntity mortarEntity = new MortarEntity(level, player.getYRot());
        mortarEntity.setPos((double)pos.getX() + 0.5, pos.getY() + 1, (double)pos.getZ() + 0.5);
        double yOffset = this.getYOffset((LevelReader)level, pos, !Objects.equals(clickedPos, pos) && direction == Direction.UP, mortarEntity.getBoundingBox());
        mortarEntity.moveTo((double)pos.getX() + 0.5, (double)pos.getY() + yOffset, (double)pos.getZ() + 0.5);
        level.addFreshEntity((Entity)mortarEntity);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        level.gameEvent((Entity)pContext.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, clickedPos);
        return InteractionResult.CONSUME;
    }

    public double getYOffset(LevelReader pLevel, BlockPos pPos, boolean pShouldOffsetYMore, AABB pBox) {
        AABB aabb = new AABB(pPos);
        if (pShouldOffsetYMore) {
            aabb = aabb.expandTowards(0.0, -1.0, 0.0);
        }
        Iterable iterable = pLevel.getCollisions(null, aabb);
        return 1.0 + Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)pBox, (Iterable)iterable, (double)(pShouldOffsetYMore ? -2.0 : -1.0));
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        BlockHitResult blockhitresult = MortarDeployer.getPlayerPOVHitResult((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (!(pLevel instanceof ServerLevel)) {
            return InteractionResultHolder.success((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        if (!(pLevel.getBlockState(blockpos).getBlock() instanceof LiquidBlock)) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (pLevel.mayInteract(pPlayer, blockpos) && pPlayer.mayUseItemAt(blockpos, blockhitresult.getDirection(), itemstack)) {
            MortarEntity mortarEntity = new MortarEntity(pLevel, pPlayer.getYRot());
            mortarEntity.setPos((double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5);
            pLevel.addFreshEntity((Entity)mortarEntity);
            if (!pPlayer.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.ENTITY_PLACE, mortarEntity.position());
            return InteractionResultHolder.consume((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

