/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.registries.DeferredHolder;

public class PerkItem<T extends Perk>
extends Item {
    private final DeferredHolder<Perk, T> perk;

    public PerkItem(DeferredHolder<Perk, T> perk) {
        super(new Item.Properties());
        this.perk = perk;
    }

    public PerkItem(DeferredHolder<Perk, T> perk, Rarity rarity) {
        super(new Item.Properties().rarity(rarity));
        this.perk = perk;
    }

    public Perk getPerk() {
        return (Perk)this.perk.get();
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ChatFormatting chatFormatting = switch (this.getPerk().type) {
            default -> throw new MatchException(null, null);
            case Perk.Type.AMMO -> ChatFormatting.YELLOW;
            case Perk.Type.FUNCTIONAL -> ChatFormatting.GREEN;
            case Perk.Type.DAMAGE -> ChatFormatting.RED;
        };
        tooltipComponents.add((Component)Component.translatable((String)("des.superbwarfare." + this.getPerk().descriptionId)).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.empty());
        tooltipComponents.add((Component)Component.translatable((String)"perk.superbwarfare.slot").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)("perk.superbwarfare.slot_" + this.getPerk().type.getName())).withStyle(chatFormatting)));
        Perk perk = this.getPerk();
        if (perk instanceof AmmoPerk) {
            AmmoPerk ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.damageRate < 1.0f) {
                tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.perk_damage_reduce").withStyle(ChatFormatting.RED));
            } else if (ammoPerk.damageRate > 1.0f) {
                tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.perk_damage_plus").withStyle(ChatFormatting.GREEN));
            }
            if (ammoPerk.speedRate < 1.0f) {
                tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.perk_speed_reduce").withStyle(ChatFormatting.RED));
            } else if (ammoPerk.speedRate > 1.0f) {
                tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.perk_speed_plus").withStyle(ChatFormatting.GREEN));
            }
            if (ammoPerk.slug) {
                tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.perk_slug").withStyle(ChatFormatting.YELLOW));
            }
        }
    }
}

