/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.projectile.SwarmDroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SwarmDrone
extends Item
implements ProjectileItem {
    public SwarmDrone() {
        super(new Item.Properties());
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.swarm_drone").withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().uncertainty(1.0f).power(1.5f).build();
    }

    private static SwarmDroneEntity createProjectile(Level level, Position pos) {
        return new SwarmDroneEntity(pos.x(), pos.y(), pos.z(), level);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return SwarmDrone.createProjectile(level, pos);
    }

    public static class SwarmDroneDispenseBehavior
    extends ProjectileDispenseBehavior {
        public SwarmDroneDispenseBehavior() {
            super((Item)ModItems.SWARM_DRONE.get());
        }

        @ParametersAreNonnullByDefault
        @NotNull
        public ItemStack execute(BlockSource blockSource, ItemStack stack) {
            ServerLevel level = blockSource.level();
            Position position = DispenserBlock.getDispensePosition((BlockSource)blockSource);
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            SwarmDroneEntity projectile = SwarmDrone.createProjectile((Level)level, position);
            float yVec = direction.getStepY();
            if (direction != Direction.DOWN) {
                yVec += 1.0f;
            }
            projectile.shoot(direction.getStepX(), yVec, direction.getStepZ(), 1.5f, 1.0f);
            BlockHitResult result = level.clip(new ClipContext(new Vec3(position.x(), position.y(), position.z()), new Vec3(position.x(), position.y(), position.z()).add(new Vec3(direction.step().mul(128.0f))), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)projectile));
            Vec3 hitPos = result.getLocation();
            projectile.setGuideType(1);
            projectile.setTargetVec(hitPos);
            level.addFreshEntity((Entity)projectile);
            stack.shrink(1);
            blockSource.level().playSound(null, blockSource.pos(), (SoundEvent)ModSounds.DECOY_FIRE.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            return stack;
        }
    }
}

