/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.common.ammo;

import com.atsuishio.superbwarfare.client.PoseTool;
import com.atsuishio.superbwarfare.client.renderer.item.RocketItemRenderer;
import com.atsuishio.superbwarfare.entity.projectile.RpgRocketEntity;
import com.atsuishio.superbwarfare.init.ModCriteriaTriggers;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public class Rocket
extends Item
implements GeoItem,
ProjectileItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static ItemDisplayContext transformType;

    public Rocket() {
        super(new Item.Properties().stacksTo(16));
    }

    @SubscribeEvent
    private static void registerGunExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new RocketItemRenderer();

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }

            @ParametersAreNonnullByDefault
            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack stack) {
                return PoseTool.pose(entityLiving, hand, stack);
            }
        }, new Item[]{(Item)ModItems.ROCKET.get()});
    }

    public void getTransformType(ItemDisplayContext type) {
        transformType = type;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        ArrayList<ItemAttributeModifiers.Entry> list = new ArrayList<ItemAttributeModifiers.Entry>(super.getDefaultAttributeModifiers(stack).modifiers());
        list.addAll(List.of(new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 6.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND), new ItemAttributeModifiers.Entry(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)));
        return new ItemAttributeModifiers(list, true);
    }

    public boolean hurtEnemy(@NotNull ItemStack stack, LivingEntity entity, @NotNull LivingEntity source) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (Math.random() < 0.25) {
                level2.explode((Entity)source, source.getX(), source.getY() + 1.0, source.getZ(), 6.0f, Level.ExplosionInteraction.NONE);
                level2.explode(null, source.getX(), source.getY() + 1.0, source.getZ(), 6.0f, Level.ExplosionInteraction.NONE);
                if (!source.level().isClientSide() && source.getServer() != null) {
                    ParticleTool.spawnMediumExplosionParticles(source.level(), source.getPosition(0.0f));
                }
                if (source instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)source;
                    ModCriteriaTriggers.RPG_MELEE_EXPLOSION.get().trigger(player);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                } else {
                    stack.shrink(1);
                }
            }
        }
        return super.hurtEnemy(stack, entity, source);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return new RpgRocketEntity((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.RPG_ROCKET.get()), pos.x(), pos.y(), pos.z(), level);
    }

    @NotNull
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().power(1.5f).build();
    }

    public static class RocketDispenseBehavior
    extends ProjectileDispenseBehavior {
        public RocketDispenseBehavior() {
            super((Item)ModItems.ROCKET.get());
        }

        protected void playSound(BlockSource blockSource) {
            blockSource.level().playSound(null, blockSource.pos(), (SoundEvent)ModSounds.RPG_FIRE_3P.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

