/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.handgun;

import com.atsuishio.superbwarfare.client.ClickHandler;
import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.renderer.gun.TracheliumItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.NBTTool;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class Trachelium
extends GunItem {
    public Trachelium() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.TRACHELIUM_RELOAD_EMPTY.get());
    }

    @Override
    public Supplier<GeoItemRenderer<? extends Item>> getRenderer() {
        return TracheliumItemRenderer::new;
    }

    private PlayState fireAnimPredicate(AnimationState<Trachelium> event) {
        boolean grip;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
        }
        GunData data = GunData.from(stack);
        boolean stock = data.attachment.get(AttachmentType.STOCK) == 2;
        boolean bl = grip = data.attachment.get(AttachmentType.GRIP) > 0 || data.attachment.get(AttachmentType.SCOPE) > 0;
        if (ClientEventHandler.firePosTimer > 0.0 && ClientEventHandler.firePosTimer < 1.7) {
            if (stock) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.fire_stock_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.fire_stock"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.fire_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.fire"));
        }
        if (stock) {
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock"));
        }
        if (grip) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock_grip"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
    }

    private PlayState idlePredicate(AnimationState<Trachelium> event) {
        boolean grip;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
        }
        GunData data = GunData.from(stack);
        boolean stock = data.attachment.get(AttachmentType.STOCK) == 2;
        boolean bl = grip = data.attachment.get(AttachmentType.GRIP) > 0 || data.attachment.get(AttachmentType.SCOPE) > 0;
        if (data.bolt.actionTimer.get() > 0) {
            if (stock) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.action_stock_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.action_stock"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.action_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.action"));
        }
        if (GunData.from((ItemStack)stack).reload.empty()) {
            if (stock) {
                if (grip) {
                    return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.reload_stock_grip"));
                }
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.reload_stock"));
            }
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.reload_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.reload"));
        }
        if (player.isSprinting() && player.onGround() && ClientEventHandler.cantSprint == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (stock) {
                if (grip) {
                    if (ClientEventHandler.tacticalSprint) {
                        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.run_fast_stock"));
                    }
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.run_stock_grip"));
                }
                if (ClientEventHandler.tacticalSprint) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.run_fast_stock"));
                }
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.run_stock"));
            }
            if (grip) {
                if (ClientEventHandler.tacticalSprint) {
                    return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.run_fast"));
                }
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.run_grip"));
            }
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.run"));
        }
        if (stock) {
            if (grip) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock_grip"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_stock"));
        }
        if (grip) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle_grip"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
    }

    private PlayState editPredicate(AnimationState<Trachelium> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
        }
        if (ClickHandler.isEditing) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.trachelium.edit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.trachelium.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController fireAnimController = new AnimationController((GeoAnimatable)this, "fireAnimController", 0, this::fireAnimPredicate);
        data.add(fireAnimController);
        AnimationController idlePredicate = new AnimationController((GeoAnimatable)this, "idlePredicate", 3, this::idlePredicate);
        data.add(idlePredicate);
        AnimationController editController = new AnimationController((GeoAnimatable)this, "editController", 1, this::editPredicate);
        data.add(editController);
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.empty());
        list.add((Component)Component.translatable((String)"des.superbwarfare.trachelium_1").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        list.add((Component)Component.translatable((String)"des.superbwarfare.trachelium_2").withStyle(ChatFormatting.GRAY));
        TooltipTool.addHideText(list, (Component)Component.empty());
        TooltipTool.addHideText(list, (Component)Component.translatable((String)"des.superbwarfare.trachelium_3").withStyle(ChatFormatting.WHITE));
        TooltipTool.addHideText(list, (Component)Component.translatable((String)"des.superbwarfare.trachelium_4").withStyle(Style.EMPTY.withColor(0xF4F0FF)));
    }

    @Override
    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        GunData data = GunData.from(stack);
        int scopeType = data.attachment.get(AttachmentType.SCOPE);
        int stockType = data.attachment.get(AttachmentType.STOCK);
        if (stockType == 1) {
            data.attachment.set(AttachmentType.STOCK, 2);
        }
        if (scopeType == 3) {
            data.attachment.set(AttachmentType.SCOPE, 0);
        }
    }

    @Override
    public boolean canSwitchScope(ItemStack stack) {
        return GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE) == 2;
    }

    private boolean useSpecialAttributes(ItemStack stack) {
        int scopeType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE);
        int gripType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.GRIP);
        return scopeType > 0 || gripType > 0;
    }

    @Override
    public double getCustomDamage(ItemStack stack) {
        if (this.useSpecialAttributes(stack)) {
            return 2.0;
        }
        return super.getCustomDamage(stack);
    }

    @Override
    public double getCustomZoom(ItemStack stack) {
        int scopeType = GunData.from((ItemStack)stack).attachment.get(AttachmentType.SCOPE);
        return scopeType == 2 ? (NBTTool.getTag(stack).getBoolean("ScopeAlt") ? 0.0 : 2.75) : 0.0;
    }

    @Override
    public double getCustomVelocity(ItemStack stack) {
        if (this.useSpecialAttributes(stack)) {
            return 15.0;
        }
        return super.getCustomVelocity(stack);
    }

    @Override
    public double getCustomHeadshot(ItemStack stack) {
        if (this.useSpecialAttributes(stack)) {
            return 0.5;
        }
        return super.getCustomHeadshot(stack);
    }

    @Override
    public double getCustomBypassArmor(ItemStack stack) {
        if (this.useSpecialAttributes(stack)) {
            return 0.1;
        }
        return super.getCustomBypassArmor(stack);
    }

    @Override
    public String getGunDisplayName() {
        return "TRACHELIUM";
    }

    @Override
    public boolean isCustomizable(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomBarrel(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomGrip(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomScope(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasCustomStock(ItemStack stack) {
        return true;
    }
}

