/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.launcher;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.gun.JavelinItemRenderer;
import com.atsuishio.superbwarfare.client.tooltip.component.LauncherImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.DecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.JavelinMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModEnumExtensions;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.receive.ShootClientMessage;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class JavelinItem
extends GunItem {
    public JavelinItem() {
        super(new Item.Properties().stacksTo(1).rarity(ModEnumExtensions.getLegendary()));
    }

    @Override
    public Supplier<GeoItemRenderer<? extends Item>> getRenderer() {
        return JavelinItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<JavelinItem> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.javelin.idle"));
        }
        if (GunData.from((ItemStack)stack).reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.javelin.reload"));
        }
        if (player.isSprinting() && player.onGround() && ClientEventHandler.cantSprint == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.javelin.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.javelin.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.javelin.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 4, this::idlePredicate);
        data.add(idleController);
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.JAVELIN_RELOAD_EMPTY.get(), (SoundEvent)ModSounds.JAVELIN_LOCK.get(), (SoundEvent)ModSounds.JAVELIN_LOCKON.get());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        GunData data;
        block15: {
            CompoundTag tag;
            block14: {
                Entity seekingEntity;
                Player player;
                block17: {
                    block16: {
                        ServerPlayer serverPlayer;
                        super.inventoryTick(stack, world, entity, slot, selected);
                        data = GunData.from(stack);
                        tag = data.tag();
                        if (!(entity instanceof Player)) break block14;
                        player = (Player)entity;
                        if (!selected) break block14;
                        if (!tag.getBoolean("Seeking")) break block15;
                        List<Entity> decoy = SeekTool.seekLivingEntities((Entity)player, player.level(), 512.0, 8.0);
                        for (Entity e : decoy) {
                            if (!(e instanceof DecoyEntity)) continue;
                            DecoyEntity decoyEntity = (DecoyEntity)e;
                            tag.putString("TargetEntity", decoyEntity.getDecoyUUID());
                            tag.putDouble("TargetPosX", decoyEntity.getPosition().x);
                            tag.putDouble("TargetPosY", decoyEntity.getPosition().y);
                            tag.putDouble("TargetPosZ", decoyEntity.getPosition().z);
                        }
                        Entity targetEntity = EntityFindUtil.findEntity(player.level(), tag.getString("TargetEntity"));
                        if (tag.getInt("GuideType") != 0) break block16;
                        if (targetEntity != null && VectorTool.calculateAngle(player.getViewVector(1.0f), player.getEyePosition().vectorTo(targetEntity.getBoundingBox().getCenter())) < 8.0) {
                            tag.putInt("SeekTime", tag.getInt("SeekTime") + 1);
                            if (tag.getInt("SeekTime") > 0 && (!targetEntity.getPassengers().isEmpty() || targetEntity instanceof VehicleEntity) && targetEntity.tickCount % 3 == 0) {
                                targetEntity.level().playSound(null, targetEntity.getOnPos(), targetEntity instanceof Pig ? SoundEvents.PIG_HURT : (SoundEvent)ModSounds.LOCKING_WARNING.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            }
                        } else {
                            tag.putInt("SeekTime", 0);
                        }
                        if (tag.getInt("SeekTime") == 1 && player instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)player;
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.JAVELIN_LOCK.get(), 1.0f, 1.0f);
                        }
                        if (targetEntity != null && tag.getInt("SeekTime") > 20) {
                            if (player instanceof ServerPlayer) {
                                serverPlayer = (ServerPlayer)player;
                                SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.JAVELIN_LOCKON.get(), 1.0f, 1.0f);
                            }
                            if ((!targetEntity.getPassengers().isEmpty() || targetEntity instanceof VehicleEntity) && targetEntity.tickCount % 2 == 0) {
                                targetEntity.level().playSound(null, targetEntity.getOnPos(), targetEntity instanceof Pig ? SoundEvents.PIG_HURT : (SoundEvent)ModSounds.LOCKED_WARNING.get(), SoundSource.PLAYERS, 1.0f, 0.95f);
                            }
                        }
                        break block17;
                    }
                    if (tag.getInt("GuideType") == 1) {
                        ServerPlayer serverPlayer;
                        Vec3 toVec = player.getEyePosition().vectorTo(new Vec3(tag.getDouble("TargetPosX"), tag.getDouble("TargetPosY"), tag.getDouble("TargetPosZ"))).normalize();
                        if (VectorTool.calculateAngle(player.getViewVector(1.0f), toVec) < 8.0) {
                            tag.putInt("SeekTime", tag.getInt("SeekTime") + 1);
                        } else {
                            tag.putInt("SeekTime", 0);
                        }
                        if (tag.getInt("SeekTime") == 1 && player instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)player;
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.JAVELIN_LOCK.get(), 1.0f, 1.0f);
                        }
                        if (tag.getInt("SeekTime") > 20 && player instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)player;
                            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.JAVELIN_LOCKON.get(), 1.0f, 1.0f);
                        }
                    }
                }
                if ((seekingEntity = SeekTool.seekEntity((Entity)player, player.level(), 512.0, 8.0)) instanceof DecoyEntity) {
                    tag.putInt("SeekTime", 0);
                }
                break block15;
            }
            tag.putInt("SeekTime", 0);
        }
        data.save();
    }

    @Override
    public ResourceLocation getGunIcon() {
        return Mod.loc("textures/gun_icon/javelin_icon.png");
    }

    @Override
    public String getGunDisplayName() {
        return "FGM-148";
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new LauncherImageComponent(pStack));
    }

    @Override
    public String getAmmoDisplayName(GunData data) {
        return "Javelin Missile";
    }

    private void fire(Player player) {
        Level level = player.level();
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        CompoundTag tag = data.tag();
        if (tag.getInt("SeekTime") < 20) {
            return;
        }
        float yRot = player.getYRot() + 360.0f;
        yRot = (yRot + 90.0f) % 360.0f;
        Vector3d firePos = new Vector3d(0.0, -0.2, 0.15);
        firePos.rotateZ((double)(-player.getXRot() * ((float)Math.PI / 180)));
        firePos.rotateY((double)(-yRot * ((float)Math.PI / 180)));
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            JavelinMissileEntity missileEntity = new JavelinMissileEntity((LivingEntity)player, level, (float)data.damage(), (float)data.explosionDamage(), (float)data.explosionRadius(), tag.getInt("GuideType"), new Vec3(tag.getDouble("TargetPosX"), tag.getDouble("TargetPosY"), tag.getDouble("TargetPosZ")));
            for (Perk.Type type : Perk.Type.values()) {
                PerkInstance instance = data.perk.getInstance(type);
                if (instance == null) continue;
                instance.perk().modifyProjectile(data, instance, (Entity)missileEntity);
            }
            missileEntity.setPos(player.getX() + firePos.x, player.getEyeY() + firePos.y, player.getZ() + firePos.z);
            missileEntity.shoot(player.getLookAngle().x, player.getLookAngle().y + 0.3, player.getLookAngle().z, 3.0f, 1.0f);
            missileEntity.setTargetUuid(tag.getString("TargetEntity"));
            missileEntity.setAttackMode(tag.getBoolean("TopMode"));
            level.addFreshEntity((Entity)missileEntity);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, player.getX() + 1.8 * player.getLookAngle().x, player.getY() + (double)player.getBbHeight() - 0.1 + 1.8 * player.getLookAngle().y, player.getZ() + 1.8 * player.getLookAngle().z, 30, 0.4, 0.4, 0.4, 0.005, true);
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.JAVELIN_FIRE_1P.get(), 2.0f, 1.0f);
            serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.JAVELIN_FIRE_3P.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
            serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.JAVELIN_FAR.get(), SoundSource.PLAYERS, 10.0f, 1.0f);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShootClientMessage(10.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        player.getCooldowns().addCooldown(stack.getItem(), 10);
        data.ammo.set(data.ammo.get() - 1);
        data.save();
    }

    @Override
    public void onShoot(GunData data, Player player, double spread, boolean zoom) {
    }

    @Override
    public void onFireKeyRelease(GunData data, Player player, double power, boolean zoom) {
        super.onFireKeyRelease(data, player, power, zoom);
        this.fire(player);
        CompoundTag tag = data.tag();
        tag.putBoolean("Seeking", false);
        tag.putInt("SeekTime", 0);
        tag.putString("TargetEntity", "none");
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(Mod.loc("javelin_lock"), SoundSource.PLAYERS);
            serverPlayer.connection.send((Packet)clientboundstopsoundpacket);
        }
    }

    @Override
    public void onFireKeyPress(GunData data, Player player, boolean zoom) {
        super.onFireKeyPress(data, player, zoom);
        if (!zoom || data.ammo.get() <= 0) {
            return;
        }
        CompoundTag tag = data.tag();
        Entity seekingEntity = SeekTool.seekEntity((Entity)player, player.level(), 512.0, 8.0);
        if (seekingEntity != null && !player.isCrouching()) {
            tag.putInt("GuideType", 0);
            tag.putString("TargetEntity", seekingEntity.getStringUUID());
        } else {
            BlockHitResult result = player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(player.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 hitPos = result.getLocation();
            tag.putInt("GuideType", 1);
            tag.putDouble("TargetPosX", hitPos.x);
            tag.putDouble("TargetPosY", hitPos.y);
            tag.putDouble("TargetPosZ", hitPos.z);
        }
        tag.putBoolean("Seeking", true);
        tag.putInt("SeekTime", 0);
    }
}

