/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.machinegun;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.gun.M60ItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class M60Item
extends GunItem {
    public M60Item() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    @Override
    public Supplier<GeoItemRenderer<? extends Item>> getRenderer() {
        return M60ItemRenderer::new;
    }

    private PlayState fireAnimPredicate(AnimationState<M60Item> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_60.idle"));
        }
        if (ClientEventHandler.firePosTimer > 0.0 && ClientEventHandler.firePosTimer < 0.45) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_60.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_60.idle"));
    }

    private PlayState idlePredicate(AnimationState<M60Item> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_60.idle"));
        }
        if (GunData.from((ItemStack)stack).reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_60.reload"));
        }
        if (GunData.from((ItemStack)stack).reload.normal()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.m_60.reload2"));
        }
        if (player.isSprinting() && player.onGround() && ClientEventHandler.cantSprint == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_60.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_60.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.m_60.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController fireAnimController = new AnimationController((GeoAnimatable)this, "fireAnimController", 0, this::fireAnimPredicate);
        data.add(fireAnimController);
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 4, this::idlePredicate);
        data.add(idleController);
    }

    @Override
    public Set<SoundEvent> getReloadSound() {
        return Set.of((SoundEvent)ModSounds.M_60_RELOAD_EMPTY.get(), (SoundEvent)ModSounds.M_60_RELOAD_NORMAL.get());
    }

    @Override
    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        GunData data = GunData.from(stack);
        if (data.draw.get()) {
            data.draw.set(false);
            if (data.ammo.get() <= 5) {
                data.hideBulletChain.set(true);
            }
            data.save();
        }
        super.inventoryTick(stack, level, entity, slot, selected);
    }

    @Override
    public ResourceLocation getGunIcon() {
        return Mod.loc("textures/gun_icon/m_60_icon.png");
    }

    @Override
    public String getGunDisplayName() {
        return "M60";
    }

    @Override
    public boolean isOpenBolt(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canEjectShell(ItemStack stack) {
        return true;
    }

    @Override
    public void beforeShoot(GunData data, Player player, double spread, boolean zoom) {
        super.beforeShoot(data, player, spread, zoom);
        if (data.ammo.get() <= 5) {
            data.hideBulletChain.set(true);
        }
    }

    @Override
    public void addReloadTimeBehavior(Map<Integer, Consumer<GunData>> behaviors) {
        super.addReloadTimeBehavior(behaviors);
        behaviors.put(55, data -> data.hideBulletChain.reset());
    }
}

