/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.special;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.renderer.gun.BocekItemRenderer;
import com.atsuishio.superbwarfare.client.tooltip.component.BocekImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.network.message.receive.ShootClientMessage;
import com.atsuishio.superbwarfare.perk.AmmoPerk;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.tools.GunsTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class BocekItem
extends GunItem {
    public BocekItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    @Override
    public Supplier<GeoItemRenderer<? extends Item>> getRenderer() {
        return BocekItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<BocekItem> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
        }
        if (ClientEventHandler.bowPull) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.bocek.pull"));
        }
        if (player.isSprinting() && player.onGround() && ClientEventHandler.cantSprint == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
    }

    private PlayState firePredicate(AnimationState<BocekItem> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
        }
        if (GunsTool.getGunIntTag(GunData.from((ItemStack)stack).tag, "ArrowEmpty") > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.bocek.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
    }

    private PlayState reloadPredicate(AnimationState<BocekItem> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
        }
        GunData data = GunData.from(stack);
        if (data.reload.empty()) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.bocek.reload"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.bocek.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 3, this::idlePredicate);
        data.add(idleController);
        AnimationController fireController = new AnimationController((GeoAnimatable)this, "fireController", 0, this::firePredicate);
        data.add(fireController);
        AnimationController reloadController = new AnimationController((GeoAnimatable)this, "reloadController", 0, this::reloadPredicate);
        data.add(reloadController);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (GunsTool.getGunIntTag(GunData.from((ItemStack)stack).tag, "ArrowEmpty") > 0) {
            GunsTool.setGunIntTag(GunData.from((ItemStack)stack).tag, "ArrowEmpty", GunsTool.getGunIntTag(GunData.from((ItemStack)stack).tag, "ArrowEmpty") - 1);
        }
    }

    @Override
    public ResourceLocation getGunIcon() {
        return Mod.loc("textures/gun_icon/bocek_icon.png");
    }

    @Override
    public String getGunDisplayName() {
        return "Bocek";
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack pStack) {
        return Optional.of(new BocekImageComponent(pStack));
    }

    @Override
    public String getAmmoDisplayName(GunData data) {
        return "Arrow";
    }

    @Override
    public void onShoot(GunData data, Player player, double spread, boolean zoom) {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onFireKeyRelease(GunData data, Player player, double power, boolean zoom) {
        block7: {
            block9: {
                block8: {
                    super.onFireKeyRelease(data, player, power, zoom);
                    if (data.ammo.get() == 0) {
                        return;
                    }
                    perk = data.perk.get(Perk.Type.AMMO);
                    if (player instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)player;
                        SoundTool.stopSound(serverPlayer, ModSounds.BOCEK_PULL_1P.getId(), SoundSource.PLAYERS);
                        SoundTool.stopSound(serverPlayer, ModSounds.BOCEK_PULL_3P.getId(), SoundSource.PLAYERS);
                        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShootClientMessage(10.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    if (!(power * 12.0 >= 6.0)) break block7;
                    if (!zoom) break block8;
                    this.spawnBullet(data, player, power, true);
                    SoundTool.playLocalSound(player, (SoundEvent)ModSounds.BOCEK_ZOOM_FIRE_1P.get(), 10.0f, 1.0f);
                    player.playSound((SoundEvent)ModSounds.BOCEK_ZOOM_FIRE_3P.get(), 2.0f, 1.0f);
                    break block9;
                }
                i = 0;
                while (true) {
                    if (!(perk instanceof AmmoPerk)) ** GOTO lbl-1000
                    ammoPerk = (AmmoPerk)perk;
                    if (ammoPerk.slug) {
                        v0 = 1;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = 10;
                    }
                    if (i >= v0) break;
                    this.spawnBullet(data, player, power, false);
                    ++i;
                }
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.BOCEK_SHATTER_CAP_FIRE_1P.get(), 10.0f, 1.0f);
                player.playSound((SoundEvent)ModSounds.BOCEK_SHATTER_CAP_FIRE_3P.get(), 2.0f, 1.0f);
            }
            if (perk == ModPerks.BEAST_BULLET.get()) {
                player.playSound((SoundEvent)ModSounds.HENG.get(), 4.0f, 1.0f);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.HENG.get(), 4.0f, 1.0f);
                }
            }
            GunsTool.setGunIntTag(data.tag, "ArrowEmpty", 7);
            data.ammo.set(data.ammo.get() - 1);
            data.save();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void spawnBullet(GunData data, Player player, double power, boolean zoom) {
        block6: {
            block5: {
                stack = data.stack;
                perk = data.perk.get(Perk.Type.AMMO);
                headshot = (float)data.headshot();
                velocity = (float)(24.0 * power);
                bypassArmorRate = (float)data.bypassArmor();
                if (!zoom) break block5;
                spread = 0.01f;
                damage = 0.08333333 * data.damage() * 12.0 * power * BocekItem.perkDamage(perk);
                break block6;
            }
            if (!(perk instanceof AmmoPerk)) ** GOTO lbl-1000
            ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                v0 = 0.5f;
            } else lbl-1000:
            // 2 sources

            {
                v0 = spread = 2.5f;
            }
            if (!(perk instanceof AmmoPerk)) ** GOTO lbl-1000
            ammoPerk = (AmmoPerk)perk;
            if (ammoPerk.slug) {
                v1 = 0.08333333;
            } else lbl-1000:
            // 2 sources

            {
                v1 = 0.008333333;
            }
            damage = v1 * data.damage() * 12.0 * power * BocekItem.perkDamage(perk);
        }
        projectile = new ProjectileEntity(player.level()).shooter((LivingEntity)player).headShot(headshot).zoom(zoom).bypassArmorRate(bypassArmorRate).setGunItemId(stack);
        for (Perk.Type type : Perk.Type.values()) {
            instance = data.perk.getInstance(type);
            if (instance == null) continue;
            instance.perk().modifyProjectile(data, instance, (Entity)projectile);
        }
        projectile.setPos(player.getX() - 0.1 * player.getLookAngle().x, player.getEyeY() - 0.1 - 0.1 * player.getLookAngle().y, player.getZ() + -0.1 * player.getLookAngle().z);
        projectile.shoot(player, player.getLookAngle().x, player.getLookAngle().y, player.getLookAngle().z, (zoom == false && perk == ModPerks.INCENDIARY_BULLET.get() ? 0.2f : 1.0f) * velocity, spread);
        projectile.damage((float)damage);
        player.level().addFreshEntity((Entity)projectile);
    }
}

