/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModMenuTypes;
import com.atsuishio.superbwarfare.network.message.receive.DogTagEditorMessage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class DogTagEditorMenu
extends AbstractContainerMenu {
    protected final Container container;
    protected final ContainerLevelAccess access;
    @Nullable
    private String itemName;
    public ItemStack stack;

    public DogTagEditorMenu(int pContainerId) {
        this(pContainerId, (Container)new SimpleContainer(0), ContainerLevelAccess.NULL, ItemStack.EMPTY);
    }

    public DogTagEditorMenu(int pContainerId, ContainerLevelAccess access, ItemStack stack) {
        this(pContainerId, (Container)new SimpleContainer(0), access, stack);
    }

    public DogTagEditorMenu(int pContainerId, Container container, ContainerLevelAccess pContainerLevelAccess, ItemStack stack) {
        super(ModMenuTypes.DOG_TAG_EDITOR_MENU.get(), pContainerId);
        DogTagEditorMenu.checkContainerSize((Container)container, (int)0);
        this.container = container;
        this.access = pContainerLevelAccess;
        this.stack = stack;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player pPlayer) {
        return pPlayer.isAlive();
    }

    public boolean setItemName(String name) {
        String s = DogTagEditorMenu.validateName(name);
        if (s != null && !s.equals(this.itemName)) {
            this.itemName = s;
            if (!this.stack.isEmpty()) {
                if (StringUtil.isBlank((String)s)) {
                    this.stack.remove(DataComponents.CUSTOM_NAME);
                } else {
                    this.stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)s));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String pItemName) {
        String s = StringUtil.filterText((String)pItemName);
        return s.length() <= 30 ? s : null;
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof DogTagEditorMenu) {
            ServerPlayer serverPlayer;
            ItemStack stack;
            DogTagEditorMenu menu = (DogTagEditorMenu)abstractContainerMenu;
            abstractContainerMenu = event.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer && (stack = (serverPlayer = (ServerPlayer)abstractContainerMenu).getItemInHand(serverPlayer.getUsedItemHand())).is((Item)ModItems.DOG_TAG.get())) {
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new DogTagEditorMessage(menu.containerId, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void finishEdit(List<Short> colors, String name) {
        if (this.stack.isEmpty()) {
            return;
        }
        this.stack.set(ModDataComponents.DOG_TAG_IMAGE, colors);
        if (!name.isEmpty()) {
            this.stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
        }
    }
}

