/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.menu.FuMO25Menu;
import com.atsuishio.superbwarfare.network.dataslot.ContainerEnergyData;
import com.atsuishio.superbwarfare.network.dataslot.ContainerEnergyDataSlot;
import com.atsuishio.superbwarfare.network.message.receive.ContainerDataMessage;
import com.atsuishio.superbwarfare.network.message.receive.RadarMenuCloseMessage;
import com.atsuishio.superbwarfare.network.message.receive.RadarMenuOpenMessage;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public abstract class EnergyMenu
extends AbstractContainerMenu {
    private final List<ContainerEnergyDataSlot> containerEnergyDataSlots = Lists.newArrayList();
    private final List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();

    public EnergyMenu(@Nullable MenuType<?> pMenuType, int id, ContainerEnergyData containerData) {
        super(pMenuType, id);
        for (int i = 0; i < containerData.getCount(); ++i) {
            this.addDataSlot(DataSlot.standalone());
            this.containerEnergyDataSlots.add(ContainerEnergyDataSlot.forContainer(containerData, i));
        }
    }

    public void broadcastChanges() {
        ArrayList<ContainerDataMessage.Pair> pairs = new ArrayList<ContainerDataMessage.Pair>();
        for (int i = 0; i < this.containerEnergyDataSlots.size(); ++i) {
            ContainerEnergyDataSlot dataSlot = this.containerEnergyDataSlots.get(i);
            if (!dataSlot.checkAndClearUpdateFlag()) continue;
            pairs.add(new ContainerDataMessage.Pair(i, dataSlot.get()));
        }
        if (!pairs.isEmpty()) {
            this.usingPlayers.forEach(p -> PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new ContainerDataMessage(this.containerId, pairs), (CustomPacketPayload[])new CustomPacketPayload[0]));
        }
        super.broadcastChanges();
    }

    public void setData(int id, int data) {
        super.setData(id, data);
        this.containerEnergyDataSlots.get(id).set(data);
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof EnergyMenu) {
            EnergyMenu menu = (EnergyMenu)abstractContainerMenu;
            abstractContainerMenu = event.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                menu.usingPlayers.add(serverPlayer);
                ArrayList<ContainerDataMessage.Pair> toSync = new ArrayList<ContainerDataMessage.Pair>();
                for (int i = 0; i < menu.containerEnergyDataSlots.size(); ++i) {
                    toSync.add(new ContainerDataMessage.Pair(i, menu.containerEnergyDataSlots.get(i).get()));
                }
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ContainerDataMessage(menu.containerId, toSync), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof EnergyMenu) {
            EnergyMenu menu = (EnergyMenu)abstractContainerMenu;
            abstractContainerMenu = event.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                menu.usingPlayers.remove(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onFuMO25Opened(PlayerContainerEvent.Open event) {
        AbstractContainerMenu abstractContainerMenu = event.getContainer();
        if (abstractContainerMenu instanceof FuMO25Menu) {
            FuMO25Menu fuMO25Menu = (FuMO25Menu)abstractContainerMenu;
            abstractContainerMenu = event.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                fuMO25Menu.getSelfPos().ifPresent(pos -> PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new RadarMenuOpenMessage((BlockPos)pos), (CustomPacketPayload[])new CustomPacketPayload[0]));
            }
        }
    }

    @SubscribeEvent
    public static void onFuMO25Closed(PlayerContainerEvent.Close event) {
        Player player;
        if (event.getContainer() instanceof FuMO25Menu && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new RadarMenuCloseMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

