/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.init.ModMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class VehicleMenu
extends AbstractContainerMenu {
    private final Container container;
    private final int containerRows;
    public static final int DEFAULT_SIZE = 102;
    public static final int X_OFFSET = 97;
    public static final int Y_OFFSET = 20;

    public VehicleMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, (Container)new SimpleContainer(102));
    }

    public VehicleMenu(int pContainerId, Inventory pPlayerInventory, Container pContainer) {
        super(ModMenuTypes.VEHICLE_MENU.get(), pContainerId);
        VehicleMenu.checkContainerSize((Container)pContainer, (int)102);
        this.container = pContainer;
        this.containerRows = 6;
        pContainer.startOpen(pPlayerInventory.player);
        int i = (this.containerRows - 4) * 18;
        for (int j = 0; j < this.containerRows; ++j) {
            for (int k = 0; k < 17; ++k) {
                this.addSlot(new Slot(pContainer, k + j * 17, 8 + k * 18 + 25, 18 + j * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)pPlayerInventory, j + l * 9 + 9, 8 + j * 18 + 97, 84 + l * 18 + 20 + i));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)pPlayerInventory, k, 8 + k * 18 + 97, 162 + i));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (pIndex < this.containerRows * 17 + 3 ? !this.moveItemStackTo(stack, this.containerRows * 17 + 3, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, this.containerRows * 17, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return this.container.stillValid(pPlayer);
    }
}

