/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.network.message.send.ChangeVehicleSeatMessage;
import com.atsuishio.superbwarfare.network.message.send.SwitchVehicleWeaponMessage;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Final
    public Options options;

    @Inject(method={"handleKeybinds()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleKeybinds(CallbackInfo ci) {
        WeaponVehicleEntity weaponVehicle;
        Entity entity;
        if (this.player == null || !((entity = this.player.getVehicle()) instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity;
        int index = -1;
        for (int i = 0; i < 9; ++i) {
            if (!this.options.keyHotbarSlots[i].isDown()) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return;
        }
        if (vehicle.getMaxPassengers() > 1 && this.options.keyShift.isDown() && index < vehicle.getMaxPassengers() && vehicle.getNthEntity(index) == null) {
            ci.cancel();
            this.options.keyHotbarSlots[index].consumeClick();
            PacketDistributor.sendToServer((CustomPacketPayload)new ChangeVehicleSeatMessage(index), (CustomPacketPayload[])new CustomPacketPayload[0]);
            vehicle.changeSeat((Entity)this.player, index);
            return;
        }
        int seatIndex = vehicle.getSeatIndex((Entity)this.player);
        if (vehicle instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)((Object)vehicle)).banHand((Player)this.player)) {
            ci.cancel();
            this.options.keyHotbarSlots[index].consumeClick();
            if (!this.options.keyShift.isDown() && weaponVehicle.hasWeapon(seatIndex) && weaponVehicle.getWeaponIndex(seatIndex) != index) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SwitchVehicleWeaponMessage(seatIndex, index, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

