/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mobeffect;

import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class BurnMobEffect
extends MobEffect {
    public BurnMobEffect() {
        super(MobEffectCategory.HARMFUL, -12708330);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Entity attacker = !entity.getPersistentData().contains("BurnAttacker") ? null : entity.level().getEntity(entity.getPersistentData().getInt("BurnAttacker"));
        entity.hurt(ModDamageTypes.causeBurnDamage(entity.level().registryAccess(), attacker), 0.6f + 0.3f * (float)amplifier);
        entity.invulnerableTime = 0;
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance != null && !((MobEffect)instance.getEffect().value()).equals(ModMobEffects.BURN.value())) {
            return;
        }
        float amount = 0.6f + 0.3f * (float)(instance == null ? 0 : instance.getAmplifier());
        living.hurt(new DamageSource((Holder)living.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.IN_FIRE), event.getEffectSource()), amount);
        living.invulnerableTime = 0;
        Entity entity = event.getEffectSource();
        if (entity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            living.getPersistentData().putInt("BurnAttacker", source.getId());
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance == null) {
            return;
        }
        if (instance.getEffect().equals(ModMobEffects.BURN)) {
            living.getPersistentData().remove("BurnAttacker");
        }
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        LivingEntity living = event.getEntity();
        MobEffectInstance instance = event.getEffectInstance();
        if (instance == null) {
            return;
        }
        if (instance.getEffect().equals(ModMobEffects.BURN)) {
            living.getPersistentData().remove("BurnAttacker");
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.hasEffect(ModMobEffects.BURN)) {
            living.setRemainingFireTicks(2);
        }
        if (living.isInWater()) {
            living.removeEffect(ModMobEffects.BURN);
        }
    }
}

