/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.Mod;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ContainerDataMessage(int containerId, List<Pair> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ContainerDataMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("container_data"));
    public static final StreamCodec<ByteBuf, ContainerDataMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ContainerDataMessage::containerId, (StreamCodec)StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, Pair::id, (StreamCodec)ByteBufCodecs.INT, Pair::data, Pair::new).apply(ByteBufCodecs.list()), ContainerDataMessage::data, ContainerDataMessage::new);

    public static void handler(ContainerDataMessage message, IPayloadContext context) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.player.containerMenu.containerId == message.containerId) {
            message.data.forEach(p -> mc.player.containerMenu.setData(p.id, p.data));
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public record Pair(int id, int data) {
    }
}

