/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.SeekTool;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record DroneFireMessage(int msgType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DroneFireMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("drone_fire"));
    public static final StreamCodec<ByteBuf, DroneFireMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, DroneFireMessage::msgType, DroneFireMessage::new);

    public static void handler(DroneFireMessage message, IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getMainHandItem();
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            DroneEntity drone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"));
            if (drone == null) {
                return;
            }
            if (!player.getOffhandItem().is((Item)ModItems.FIRING_PARAMETERS.get())) {
                drone.fire = true;
            } else {
                ItemStack offStack;
                FiringParameters.Parameters parameters;
                boolean isDepressed;
                boolean lookAtEntity = false;
                Entity lookingEntity = SeekTool.seekLivingEntity(drone, drone.level(), 512.0, 2.0);
                BlockHitResult result = drone.level().clip(new ClipContext(drone.getEyePosition(), drone.getEyePosition().add(drone.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)drone));
                Vec3 hitPos = result.getLocation();
                if (lookingEntity != null) {
                    lookAtEntity = true;
                }
                boolean bl = isDepressed = (parameters = (FiringParameters.Parameters)(offStack = player.getOffhandItem()).get(ModDataComponents.FIRING_PARAMETERS)) != null && parameters.isDepressed();
                if (lookAtEntity) {
                    offStack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters(lookingEntity.blockPosition(), isDepressed));
                } else {
                    offStack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters(new BlockPos((int)hitPos.x, (int)hitPos.y, (int)hitPos.z), isDepressed));
                }
                BlockPos pos = Objects.requireNonNull((FiringParameters.Parameters)offStack.get(ModDataComponents.FIRING_PARAMETERS)).pos();
                player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.mortar.target_pos").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)("[" + pos.getX() + "," + pos.getY() + "," + pos.getZ() + "]"))), true);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

