/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.Hpj11Entity;
import com.atsuishio.superbwarfare.entity.vehicle.LaserTowerEntity;
import com.atsuishio.superbwarfare.menu.FuMO25Menu;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import java.util.stream.StreamSupport;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record RadarSetTargetMessage(UUID target) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RadarSetTargetMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("radar_set_target"));
    public static final StreamCodec<ByteBuf, RadarSetTargetMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, RadarSetTargetMessage::target, RadarSetTargetMessage::new);

    public static void handler(RadarSetTargetMessage message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        AbstractContainerMenu menu = player.containerMenu;
        if (menu instanceof FuMO25Menu) {
            FuMO25Menu fuMO25Menu = (FuMO25Menu)menu;
            if (!player.containerMenu.stillValid((Player)player)) {
                return;
            }
            fuMO25Menu.getSelfPos().ifPresent(pos -> StreamSupport.stream(EntityFindUtil.getEntities(player.level()).getAll().spliterator(), false).filter(e -> {
                Hpj11Entity hpj11Entity;
                LaserTowerEntity towerEntity;
                return e instanceof LaserTowerEntity && (towerEntity = (LaserTowerEntity)e).getOwner() == player && towerEntity.distanceTo((Entity)player) <= 16.0f || e instanceof Hpj11Entity && (hpj11Entity = (Hpj11Entity)e).getOwner() == player && hpj11Entity.distanceTo((Entity)player) <= 16.0f;
            }).forEach(e -> RadarSetTargetMessage.setTarget(e, message.target.toString())));
        }
    }

    public static void setTarget(Entity e, String uuid) {
        if (e instanceof LaserTowerEntity) {
            LaserTowerEntity laserTower = (LaserTowerEntity)e;
            laserTower.getEntityData().set(LaserTowerEntity.TARGET_UUID, (Object)uuid);
        } else if (e instanceof Hpj11Entity) {
            Hpj11Entity hpj11Entity = (Hpj11Entity)e;
            hpj11Entity.getEntityData().set(Hpj11Entity.TARGET_UUID, (Object)uuid);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

