/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.TraceTool;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SetFiringParametersMessage(int msgType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetFiringParametersMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("set_firing_parameters"));
    public static final StreamCodec<ByteBuf, SetFiringParametersMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SetFiringParametersMessage::msgType, SetFiringParametersMessage::new);

    public static void handler(SetFiringParametersMessage message, IPayloadContext context) {
        FiringParameters.Parameters parameters;
        boolean isDepressed;
        Player player = context.player();
        ItemStack stack = player.getOffhandItem();
        boolean lookAtEntity = false;
        Entity lookingEntity = TraceTool.findLookingEntity((Entity)player, 520.0);
        BlockHitResult result = player.level().clip(new ClipContext(player.getEyePosition(), player.getEyePosition().add(player.getViewVector(1.0f).scale(512.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 hitPos = result.getLocation();
        if (lookingEntity != null) {
            lookAtEntity = true;
        }
        boolean bl = isDepressed = (parameters = (FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS)) != null && parameters.isDepressed();
        if (lookAtEntity) {
            stack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters(lookingEntity.blockPosition(), isDepressed));
        } else {
            stack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters(new BlockPos((int)hitPos.x, (int)hitPos.y, (int)hitPos.z), isDepressed));
        }
        BlockPos pos = Objects.requireNonNull((FiringParameters.Parameters)stack.get(ModDataComponents.FIRING_PARAMETERS)).pos();
        player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.mortar.target_pos").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)("[" + pos.getX() + "," + pos.getY() + "," + pos.getZ() + "]"))), true);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

