/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SwitchVehicleWeaponMessage(int index, double value, boolean isScroll) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SwitchVehicleWeaponMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("switch_vehicle_weapon"));
    public static final StreamCodec<ByteBuf, SwitchVehicleWeaponMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SwitchVehicleWeaponMessage::index, (StreamCodec)ByteBufCodecs.DOUBLE, SwitchVehicleWeaponMessage::value, (StreamCodec)ByteBufCodecs.BOOL, SwitchVehicleWeaponMessage::isScroll, SwitchVehicleWeaponMessage::new);

    public static void handler(SwitchVehicleWeaponMessage message, IPayloadContext context) {
        WeaponVehicleEntity weaponVehicle;
        ServerPlayer player = (ServerPlayer)context.player();
        Entity entity = player.getVehicle();
        if (entity instanceof WeaponVehicleEntity && (weaponVehicle = (WeaponVehicleEntity)entity).isDriver((Player)player)) {
            double value = message.isScroll ? (double)Mth.clamp((int)(message.value > 0.0 ? Mth.ceil((double)message.value) : Mth.floor((double)message.value)), (int)-1, (int)1) : message.value;
            weaponVehicle.changeWeapon(message.index, (int)value, message.isScroll);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

