/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.SoundTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ZoomMessage(int msgType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ZoomMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("zoom"));
    public static final StreamCodec<ByteBuf, ZoomMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ZoomMessage::msgType, ZoomMessage::new);

    public static void handler(ZoomMessage message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        Entity vehicle = player.getVehicle();
        if (message.msgType == 0) {
            if (player.isPassenger() && vehicle instanceof WeaponVehicleEntity) {
                VehicleEntity vehicleEntity;
                WeaponVehicleEntity weaponEntity = (WeaponVehicleEntity)vehicle;
                if (vehicle instanceof VehicleEntity && weaponEntity.hasWeapon((vehicleEntity = (VehicleEntity)vehicle).getSeatIndex((Entity)player)) && weaponEntity.banHand((Player)player)) {
                    SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_IN.get(), 2.0f, 1.0f);
                }
            }
        } else if (message.msgType == 1) {
            if (player.isPassenger() && vehicle instanceof WeaponVehicleEntity) {
                VehicleEntity vehicleEntity;
                WeaponVehicleEntity weaponEntity = (WeaponVehicleEntity)vehicle;
                if (vehicle instanceof VehicleEntity && weaponEntity.hasWeapon((vehicleEntity = (VehicleEntity)vehicle).getSeatIndex((Entity)player)) && weaponEntity.banHand((Player)player)) {
                    SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_OUT.get(), 2.0f, 1.0f);
                }
            }
            if (player.getMainHandItem().getItem() == ModItems.JAVELIN.get()) {
                ItemStack handItem = player.getMainHandItem();
                GunData data = GunData.from(handItem);
                CompoundTag tag = data.tag();
                tag.putBoolean("Seeking", false);
                tag.putInt("SeekTime", 0);
                tag.putString("TargetEntity", "none");
                data.save();
                ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(Mod.loc("javelin_lock"), SoundSource.PLAYERS);
                player.connection.send((Packet)clientboundstopsoundpacket);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

