/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.item.common.ammo.box.AmmoBox;
import com.atsuishio.superbwarfare.item.common.ammo.box.AmmoBoxInfo;
import com.atsuishio.superbwarfare.tools.Ammo;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AmmoBoxExtractAmmoRecipe
extends CustomRecipe {
    public AmmoBoxExtractAmmoRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    @ParametersAreNonnullByDefault
    public boolean matches(CraftingInput input, Level level) {
        boolean hasAmmoBox = false;
        ItemStack ammoBoxItem = ItemStack.EMPTY;
        for (ItemStack item : input.items()) {
            if (item.getItem() instanceof AmmoBox) {
                if (hasAmmoBox) {
                    return false;
                }
                hasAmmoBox = true;
                ammoBoxItem = item;
                continue;
            }
            if (item.isEmpty()) continue;
            return false;
        }
        AmmoBoxInfo data = (AmmoBoxInfo)ammoBoxItem.get(ModDataComponents.AMMO_BOX_INFO);
        if (data == null) {
            return false;
        }
        String typeString = data.type();
        Ammo type = Ammo.getType(typeString);
        if (type == null) {
            return false;
        }
        return type.get(ammoBoxItem) > 0;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        Enum type = null;
        for (ItemStack item : input.items()) {
            if (!(item.getItem() instanceof AmmoBox)) continue;
            AmmoBoxInfo data = (AmmoBoxInfo)item.get(ModDataComponents.AMMO_BOX_INFO);
            assert (data != null);
            type = Ammo.getType(data.type());
            break;
        }
        assert (type != null);
        return switch (1.$SwitchMap$com$atsuishio$superbwarfare$tools$Ammo[type.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> new ItemStack((ItemLike)ModItems.HANDGUN_AMMO.get());
            case 2 -> new ItemStack((ItemLike)ModItems.RIFLE_AMMO.get());
            case 3 -> new ItemStack((ItemLike)ModItems.SHOTGUN_AMMO.get());
            case 4 -> new ItemStack((ItemLike)ModItems.SNIPER_AMMO.get());
            case 5 -> new ItemStack((ItemLike)ModItems.HEAVY_AMMO.get());
        };
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput input) {
        NonNullList remaining = super.getRemainingItems((RecipeInput)input);
        for (int i = 0; i < input.items().size(); ++i) {
            ItemStack item = input.getItem(i);
            if (!(item.getItem() instanceof AmmoBox)) continue;
            ItemStack ammoBox = item.copy();
            AmmoBoxInfo data = (AmmoBoxInfo)ammoBox.get(ModDataComponents.AMMO_BOX_INFO);
            assert (data != null);
            Ammo type = Ammo.getType(data.type());
            assert (type != null);
            type.add(ammoBox, -1);
            remaining.set(i, (Object)ammoBox);
            break;
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.AMMO_BOX_ADD_AMMO_SERIALIZER.get();
    }
}

