/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.Mod;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public class ChunkLoadTool {
    private static final TicketController controller = new TicketController(Mod.loc("chunk_loader"));

    public static void updateLoadedChunks(ServerLevel level, Entity entity, Set<Long> loadedChunks) {
        double x = entity.position().x;
        double z = entity.position().z;
        double nextX = x + entity.getDeltaMovement().x;
        double nextZ = z + entity.getDeltaMovement().z;
        HashSet<Long> newChunks = new HashSet<Long>();
        newChunks.add(ChunkPos.asLong((BlockPos)new BlockPos((int)x, 0, (int)z)));
        newChunks.add(ChunkPos.asLong((BlockPos)new BlockPos((int)nextX, 0, (int)nextZ)));
        List<Long> chunksToLoad = newChunks.stream().filter(chunk -> !loadedChunks.contains(chunk)).toList();
        List<Long> chunksToUnload = loadedChunks.stream().filter(chunk -> !newChunks.contains(chunk)).toList();
        chunksToLoad.forEach(chunk -> {
            ChunkPos chunkPos = new ChunkPos(chunk.longValue());
            controller.forceChunk(level, entity, chunkPos.x, chunkPos.z, true, false);
        });
        chunksToUnload.forEach(chunk -> {
            ChunkPos chunkPos = new ChunkPos(chunk.longValue());
            Mod.queueServerWork(10, () -> controller.forceChunk(level, entity, chunkPos.x, chunkPos.z, false, false));
        });
        loadedChunks.clear();
        loadedChunks.addAll(newChunks);
    }

    public static void unloadAllChunks(ServerLevel level, Entity entity, Set<Long> loadedChunks) {
        loadedChunks.forEach(chunk -> {
            ChunkPos chunkPos = new ChunkPos(chunk.longValue());
            Mod.queueServerWork(10, () -> controller.forceChunk(level, entity, chunkPos.x, chunkPos.z, false, false));
        });
    }

    @SubscribeEvent
    public static void register(RegisterTicketControllersEvent event) {
        event.register(controller);
    }
}

