/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.config.server.SeekConfig;
import com.atsuishio.superbwarfare.entity.projectile.DecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmokeDecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.SwarmDroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.MobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SeekTool {
    public static List<Entity> getVehicleWithinRange(Player player, Level level, double range) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> e.position().distanceTo(player.getEyePosition()) <= range && e instanceof MobileVehicleEntity).toList();
    }

    public static List<Entity> getEntityWithinRange(Player player, Level level, double range) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> e.position().distanceTo(player.getEyePosition()) <= range).toList();
    }

    public static Entity seekEntity(Entity entity, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> {
            if ((double)e.distanceTo(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.getVehicle() == null) {
                return level.clip(new ClipContext(entity.getEyePosition(), e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() != HitResult.Type.BLOCK;
            }
            return false;
        }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(e, entity))).orElse(null);
    }

    public static Entity seekCustomSizeEntity(Entity entity, Level level, double seekRange, double seekAngle, double size, boolean checkOnGround) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> {
            if ((double)e.distanceTo(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && (!checkOnGround || SeekTool.isOnGround(e, 10.0)) && e.getBoundingBox().getSize() >= size && SeekTool.smokeFilter(e) && e.getVehicle() == null) {
                return level.clip(new ClipContext(entity.getEyePosition(), e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() != HitResult.Type.BLOCK;
            }
            return false;
        }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(e, entity))).orElse(null);
    }

    public static Entity seekLivingEntity(Entity entity, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> {
            SwarmDroneEntity swarmDrone;
            if ((double)e.distanceTo(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.getVehicle() == null && (!(e instanceof SwarmDroneEntity) || (swarmDrone = (SwarmDroneEntity)e).getOwner() == entity) && (!e.isAlliedTo(entity) || e.getTeam() == null || e.getTeam().getName().equals("TDM"))) {
                return level.clip(new ClipContext(entity.getEyePosition(), e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() != HitResult.Type.BLOCK;
            }
            return false;
        }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngle(e, entity))).orElse(null);
    }

    public static List<Entity> seekLivingEntities(Entity entity, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> {
            if ((double)e.distanceTo(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.getVehicle() == null && (!e.isAlliedTo(entity) || e.getTeam() == null || e.getTeam().getName().equals("TDM"))) {
                return level.clip(new ClipContext(entity.getEyePosition(), e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() != HitResult.Type.BLOCK;
            }
            return false;
        }).toList();
    }

    public static List<Entity> seekCustomSizeEntities(Entity entity, Level level, double seekRange, double seekAngle, double size, boolean checkOnGround) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> {
            if ((double)e.distanceTo(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && e.getBoundingBox().getSize() >= size && SeekTool.baseFilter(e) && (!checkOnGround || SeekTool.isOnGround(e, 10.0)) && SeekTool.smokeFilter(e) && e.getVehicle() == null && (!e.isAlliedTo(entity) || e.getTeam() == null || e.getTeam().getName().equals("TDM"))) {
                return level.clip(new ClipContext(entity.getEyePosition(), e.getEyePosition(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() != HitResult.Type.BLOCK;
            }
            return false;
        }).toList();
    }

    public static Entity vehicleSeekEntity(VehicleEntity vehicle, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> {
            if ((double)e.distanceTo((Entity)vehicle) <= seekRange && SeekTool.calculateAngleVehicle(e, vehicle) < seekAngle && e != vehicle && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && e.getVehicle() == null && (!e.isAlliedTo((Entity)vehicle) || e.getTeam() == null || e.getTeam().getName().equals("TDM"))) {
                return level.clip(new ClipContext(vehicle.getNewEyePos(1.0f), vehicle.getNewEyePos(1.0f), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)vehicle)).getType() != HitResult.Type.BLOCK;
            }
            return false;
        }).min(Comparator.comparingDouble(e -> SeekTool.calculateAngleVehicle(e, vehicle))).orElse(null);
    }

    public static List<Entity> seekLivingEntitiesThroughWall(Entity entity, Level level, double seekRange, double seekAngle) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> (double)e.distanceTo(entity) <= seekRange && SeekTool.calculateAngle(e, entity) < seekAngle && e != entity && SeekTool.baseFilter(e) && e.getVehicle() == null && (!e.isAlliedTo(entity) || e.getTeam() == null || e.getTeam().getName().equals("TDM"))).toList();
    }

    public static List<Entity> getEntitiesWithinRange(BlockPos pos, Level level, double range) {
        return StreamSupport.stream(EntityFindUtil.getEntities(level).getAll().spliterator(), false).filter(e -> e.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) <= range * range && SeekTool.baseFilter(e) && SeekTool.smokeFilter(e) && !(e instanceof DecoyEntity)).toList();
    }

    private static double calculateAngle(Entity entityA, Entity entityB) {
        Vec3 start = new Vec3(entityA.getX() - entityB.getX(), entityA.getY() - entityB.getY(), entityA.getZ() - entityB.getZ());
        Vec3 end = entityB.getLookAngle();
        return VectorTool.calculateAngle(start, end);
    }

    private static double calculateAngleVehicle(Entity entityA, VehicleEntity entityB) {
        Vec3 entityBEyePos = entityB.getNewEyePos(1.0f);
        Vec3 start = new Vec3(entityA.getX() - entityBEyePos.x, entityA.getY() - entityBEyePos.y, entityA.getZ() - entityBEyePos.z);
        Vec3 end = entityB.getBarrelVector(1.0f);
        return VectorTool.calculateAngle(start, end);
    }

    public static boolean baseFilter(Entity entity) {
        Player player;
        return !(!entity.isAlive() || entity instanceof HangingEntity || entity instanceof Projectile && !(entity instanceof DestroyableProjectileEntity) || entity instanceof Player && (player = (Player)entity).isSpectator() || SeekTool.isInBlackList(entity));
    }

    public static boolean isOnGround(Entity entity) {
        return SeekTool.isOnGround(entity, 0.0);
    }

    public static boolean isOnGround(Entity entity, double height) {
        Level level = entity.level();
        double y = entity.getY();
        int minY = level.getMinBuildHeight();
        int maxY = level.getMaxBuildHeight();
        if (y < (double)minY || y > (double)maxY) {
            return false;
        }
        AtomicBoolean onGround = new AtomicBoolean(false);
        AABB aabb = entity.getBoundingBox().expandTowards(0.0, -height, 0.0);
        BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> {
            if (pos.getY() < minY || pos.getY() > maxY) {
                return;
            }
            BlockState state = level.getBlockState(pos);
            if (!state.isAir()) {
                onGround.set(true);
            }
        });
        return entity.onGround() || entity.isInWater() || onGround.get();
    }

    public static boolean smokeFilter(Entity pEntity) {
        AABB Box = pEntity.getBoundingBox().inflate(8.0);
        List entities = pEntity.level().getEntities(EntityTypeTest.forClass(Entity.class), Box, entity -> entity instanceof SmokeDecoyEntity).stream().toList();
        boolean result = true;
        for (Entity e : entities) {
            if (e == null) continue;
            result = false;
            break;
        }
        return result;
    }

    public static boolean isInBlackList(Entity entity) {
        ResourceLocation type = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        return ((List)SeekConfig.SEEK_BLACKLIST.get()).contains(type.toString());
    }
}

