/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.entity.projectile.DecoyEntity;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.tools.SeekTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TraceTool {
    public static boolean laserHeadshot = false;

    public static Entity findLookingEntity(Entity entity, double entityReach) {
        AABB aabb;
        double blockReach;
        double distance = entityReach * entityReach;
        Vec3 eyePos = entity.getEyePosition(1.0f);
        HitResult hitResult = entity.pick(entityReach, 1.0f, false);
        if (hitResult.getType() != HitResult.Type.MISS && (distance = hitResult.getLocation().distanceToSqr(eyePos)) > (blockReach = 5.0) * blockReach) {
            Vec3 pos = hitResult.getLocation();
            hitResult = BlockHitResult.miss((Vec3)pos, (Direction)Direction.getNearest((double)eyePos.x, (double)eyePos.y, (double)eyePos.z), (BlockPos)BlockPos.containing((Position)pos));
        }
        Vec3 viewVec = entity.getViewVector(1.0f);
        Vec3 toVec = eyePos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = entity.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0, 1.0, 1.0)), p -> !p.isSpectator() && entity.getVehicle() != p && p.isAlive() && SeekTool.smokeFilter(p), (double)distance);
        if (entityhitresult != null) {
            Vec3 targetPos = entityhitresult.getLocation();
            double distanceToTarget = eyePos.distanceToSqr(targetPos);
            if (distanceToTarget > distance || distanceToTarget > entityReach * entityReach) {
                hitResult = BlockHitResult.miss((Vec3)targetPos, (Direction)Direction.getNearest((double)viewVec.x, (double)viewVec.y, (double)viewVec.z), (BlockPos)BlockPos.containing((Position)targetPos));
            } else if (distanceToTarget < distance) {
                hitResult = entityhitresult;
            }
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static Entity findMeleeEntity(Entity entity, double entityReach) {
        AABB aabb;
        double distance = entityReach * entityReach;
        Vec3 eyePos = entity.getEyePosition(1.0f);
        HitResult hitResult = entity.pick(entityReach, 1.0f, false);
        Vec3 viewVec = entity.getViewVector(1.0f);
        Vec3 toVec = eyePos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = entity.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0, 1.0, 1.0)), p -> !p.isSpectator() && entity.getVehicle() != p && p.isAlive(), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static Entity laserfindLookingEntity(Entity player, double entityReach) {
        AABB aabb;
        double distance = entityReach * entityReach;
        Vec3 eyePos = player.getEyePosition(1.0f);
        HitResult hitResult = player.pick(entityReach, 1.0f, false);
        Vec3 viewVec = player.getViewVector(1.0f);
        Vec3 toVec = eyePos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)eyePos, (Vec3)toVec, (AABB)(aabb = player.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0, 1.0, 1.0)), p -> !p.isSpectator() && player.getVehicle() != p && p.isAlive() && SeekTool.smokeFilter(p), (double)distance);
        if (entityhitresult != null) {
            Vec3 hitVec = entityhitresult.getLocation();
            if (TraceTool.checkNoClip(player, hitVec)) {
                hitResult = entityhitresult;
            }
            if (hitResult.getType() == HitResult.Type.ENTITY && ((EntityHitResult)hitResult).getEntity().isAlive()) {
                LivingEntity living;
                Entity entity = ((EntityHitResult)hitResult).getEntity();
                laserHeadshot = entity instanceof LivingEntity ? (living = (LivingEntity)entity).getEyeY() - 0.4 < hitVec.y && hitVec.y < living.getEyeY() + 0.5 : false;
                return ((EntityHitResult)hitResult).getEntity();
            }
        }
        return null;
    }

    public static boolean checkNoClip(Entity entity, Vec3 target) {
        return entity.level().clip(new ClipContext(entity.getEyePosition(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).getType() != HitResult.Type.BLOCK;
    }

    public static Entity vehiclefFindLookingEntity(VehicleEntity vehicle, Vec3 eye, double entityReach) {
        AABB aabb;
        double distance = entityReach * entityReach;
        HitResult hitResult = TraceTool.pickNew(eye, 512.0, vehicle);
        Vec3 viewVec = vehicle.getBarrelVector(1.0f);
        Vec3 toVec = eye.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)vehicle, (Vec3)eye, (Vec3)toVec, (AABB)(aabb = vehicle.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0, 1.0, 1.0)), p -> !p.isSpectator() && p.isAlive() && (!(p instanceof Projectile) || p instanceof DestroyableProjectileEntity) && SeekTool.baseFilter(p) && !(p instanceof DecoyEntity) && SeekTool.smokeFilter(p), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static Entity droneFindLookingEntity(Entity entity, Vec3 pos, double entityReach, float ticks) {
        AABB aabb;
        double distance = entityReach * entityReach;
        HitResult hitResult = entity.pick(entityReach, 1.0f, false);
        Vec3 viewVec = entity.getViewVector(ticks);
        Vec3 toVec = pos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = entity.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0, 1.0, 1.0)), p -> !p.isSpectator() && p.isAlive() && !(p instanceof Projectile) && SeekTool.baseFilter(p) && !(p instanceof DecoyEntity) && SeekTool.smokeFilter(p) && p != entity && p != entity.getVehicle(), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static Entity camerafFindLookingEntity(Player player, Vec3 pos, double entityReach, float ticks) {
        AABB aabb;
        double distance = entityReach * entityReach;
        HitResult hitResult = player.pick(entityReach, 1.0f, false);
        Vec3 viewVec = player.getViewVector(ticks);
        Vec3 toVec = pos.add(viewVec.x * entityReach, viewVec.y * entityReach, viewVec.z * entityReach);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)pos, (Vec3)toVec, (AABB)(aabb = player.getBoundingBox().expandTowards(viewVec.scale(entityReach)).inflate(1.0, 1.0, 1.0)), p -> !p.isSpectator() && p.isAlive() && !(p instanceof Projectile) && SeekTool.baseFilter(p) && !(p instanceof DecoyEntity) && SeekTool.smokeFilter(p) && p != player && p != player.getVehicle(), (double)distance);
        if (entityhitresult != null) {
            hitResult = entityhitresult;
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).getEntity();
        }
        return null;
    }

    public static HitResult pickNew(Vec3 pos, double pHitDistance, VehicleEntity vehicle) {
        Vec3 vec31 = vehicle.getBarrelVector(1.0f);
        Vec3 vec32 = pos.add(vec31.x * pHitDistance, vec31.y * pHitDistance, vec31.z * pHitDistance);
        return vehicle.level().clip(new ClipContext(pos, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)vehicle));
    }
}

